/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import com.mathworks.toolbox.testmeas.guiutil.EditTextFieldTableCellEditor;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DataExporter
extends JPanel
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final int[] ALL_ROWS = new int[]{-1};
    private static final String ACTION = "ACTION";
    private static final int DESTINATION = 0;
    private static final int EXPORT = 1;
    private static final int CLOSE = 2;
    private static final int HELP = 3;
    private static final String[] destinations = new String[]{"MATLAB Workspace", "MATLAB Figure Window", "MAT-File", "MATLAB Variable Editor"};
    private static final int MATLAB_WORKSPACE = 0;
    private static final int FIGURE_WINDOW = 1;
    private static final int MAT_FILE = 2;
    private static final int ARRAY_EDITOR = 3;
    private ExportTableModel model;
    protected Object[][] data;
    protected String[] columnNames = new String[]{" ", "Action", "Value", "Variable Name"};
    private JComboBox destinationComboBox;
    private MJDialog dialog;
    private HistoryTable historyTable;
    private static String directoryName = "";
    private String filename;
    private MJFrame exporterFrame;
    private Object[] matlabArgs;
    private Hashtable<String, Object> variables;
    private int[] selectedRows;
    private String[] variableNames;

    public DataExporter(HistoryTable historyTable) {
        this(historyTable, ALL_ROWS);
    }

    public DataExporter(HistoryTable historyTable, int[] nArray) {
        this.selectedRows = nArray;
        this.historyTable = historyTable;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 4, 4, 4));
        this.defineTableData();
        this.layoutPanel();
        directoryName = Instrument.getPreferenceFile().read("SaveDirectory");
    }

    public void setVariableNames(String[] stringArray) {
        this.variableNames = stringArray;
    }

    private void layoutPanel() {
        this.add((Component)this.createDestinationPanel(), "North");
        this.add((Component)this.createTablePanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createDestinationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.destinationComboBox = new JComboBox<String>(destinations);
        this.destinationComboBox.setSelectedItem("MATLAB Workspace");
        this.destinationComboBox.putClientProperty(ACTION, new Integer(0));
        this.destinationComboBox.addActionListener(this);
        this.destinationComboBox.setName("Destination ComboBox");
        jPanel.add((Component)new JLabel("Data destination:"), "West");
        jPanel.add((Component)this.destinationComboBox, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        JButton jButton = new JButton("Export");
        jButton.addActionListener(this);
        jButton.setMnemonic(69);
        jButton.putClientProperty(ACTION, new Integer(1));
        jButton.setName("Export Button");
        if (this.data == null || this.data.length == 0) {
            jButton.setEnabled(false);
        }
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(67);
        jButton2.putClientProperty(ACTION, new Integer(2));
        jButton2.setName("Close Button");
        JButton jButton3 = new JButton("Help");
        jButton3.setMnemonic(72);
        jButton3.addActionListener(this);
        jButton3.putClientProperty(ACTION, new Integer(3));
        jButton3.setName("Help Button");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add((Component)new JLabel("Select the data to export:"), "North");
        this.model = new ExportTableModel();
        ExportTable exportTable = new ExportTable(this.model);
        exportTable.setName("Export Table");
        JScrollPane jScrollPane = new JScrollPane(exportTable);
        jPanel.add((Component)jScrollPane, "Center");
        JTableHeader jTableHeader = exportTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        exportTable.setSelectionMode(0);
        exportTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        exportTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        exportTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        exportTable.getColumnModel().getColumn(3).setPreferredWidth(75);
        return jPanel;
    }

    protected void defineTableData() {
        if (this.selectedRows == ALL_ROWS) {
            this.defineAllTableData();
        } else {
            Object[][] objectArray = this.historyTable.getTableData();
            this.variables = this.historyTable.getVariables();
            this.data = new Object[this.selectedRows.length][4];
            for (int i = 0; i < this.selectedRows.length; ++i) {
                this.data[i][0] = new Boolean(true);
                this.data[i][1] = objectArray[this.selectedRows[i]][0];
                this.data[i][2] = objectArray[this.selectedRows[i]][1];
                this.data[i][3] = "data" + (i + 1);
            }
        }
    }

    protected void defineAllTableData() {
        this.variables = this.historyTable.getVariables();
        int n = this.variables.size();
        if (n == 0) {
            return;
        }
        this.data = new Object[n][4];
        Object[][] objectArray = this.historyTable.getTableData();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][0];
            if (!string.equals("Read") && !string.equals("Read (Query)")) continue;
            this.data[n2][0] = new Boolean(true);
            this.data[n2][1] = objectArray[i][0];
            this.data[n2][2] = objectArray[i][1];
            this.data[n2++][3] = "data" + n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.okToExport()) {
                    return;
                }
                int n2 = this.destinationComboBox.getSelectedIndex();
                if (n2 == 2) {
                    this.createSaveDialog();
                    if (this.filename == null) {
                        return;
                    }
                }
                this.export(n2);
                if (!directoryName.equals("")) {
                    Instrument.getPreferenceFile().update("SaveDirectory", directoryName);
                }
                this.dialog.dispose();
                break;
            }
            case 2: {
                this.dialog.dispose();
                break;
            }
            case 3: {
                TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
                tMHelpViewer.update("instrument", "tmtool_csh\\data_exporter.html", "Data Exporter Help");
                tMHelpViewer.addToDialog();
            }
        }
    }

    private void export(int n) {
        switch (n) {
            case 0: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = "privateDataExporterHelper";
                this.matlabArgs[1] = "workspace";
                this.matlabArgs[2] = this.getSelectedInfo();
                this.matlabArgs[3] = this.variables;
                break;
            }
            case 2: {
                this.matlabArgs = new Object[5];
                this.matlabArgs[0] = "privateDataExporterHelper";
                this.matlabArgs[1] = "mat-file";
                this.matlabArgs[2] = this.filename;
                this.matlabArgs[3] = this.getSelectedInfo();
                this.matlabArgs[4] = this.variables;
                break;
            }
            case 1: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = "privateDataExporterHelper";
                this.matlabArgs[1] = "figure";
                this.matlabArgs[2] = this.getSelectedInfo();
                this.matlabArgs[3] = this.variables;
                break;
            }
            case 3: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = "privateDataExporterHelper";
                this.matlabArgs[1] = "arrayeditor";
                this.matlabArgs[2] = this.getSelectedInfo();
                this.matlabArgs[3] = this.variables;
            }
        }
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.matlabArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println("Exporter Exception: " + exception.getMessage());
        }
    }

    private boolean okToExport() {
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < this.data.length; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            if (vector.contains(this.data[i][3]) && !vector2.contains(this.data[i][3])) {
                int n = TMStringUtil.confirm((MJFrame)this.exporterFrame, (String)"Duplicate variable names", (String)("There are duplicate occurrences of the variable: " + this.data[i][3] + ". Do you want to continue exporting?"));
                switch (n) {
                    case 0: {
                        vector2.addElement(this.data[i][3]);
                        break;
                    }
                    case 1: {
                        return false;
                    }
                }
                continue;
            }
            vector.addElement(this.data[i][3]);
        }
        vector = null;
        vector2 = null;
        return true;
    }

    private Vector<Object> getSelectedInfo() {
        if (this.data == null) {
            return null;
        }
        int n = this.data.length;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            vector.addElement(this.data[i][3]);
            if (this.selectedRows != ALL_ROWS) {
                vector.addElement(this.variableNames[i]);
                continue;
            }
            vector.addElement(this.historyTable.getVariableName(i));
        }
        return vector;
    }

    private void createSaveDialog() {
        TMFileDialog tMFileDialog = new TMFileDialog("Export to MAT-File", 0);
        if (!directoryName.equals("")) {
            tMFileDialog.setCurrentDirectory(new File(directoryName));
        }
        tMFileDialog.setSelectedFile(new File("untitled.mat"));
        tMFileDialog.showSaveDialog((Component)this.exporterFrame);
        int n = tMFileDialog.getState();
        if (n == 0) {
            int n2;
            File file = tMFileDialog.getSelectedFile();
            directoryName = tMFileDialog.getCurrentDirectory().getAbsolutePath();
            this.filename = file.getPath();
            if (this.filename.indexOf(".") == -1) {
                if (new File(this.filename + ".mat").exists()) {
                    int n3 = TMStringUtil.confirm((MJFrame)this.exporterFrame, (String)"Save Confirmation", (String)("File " + file.getName() + ".mat already exists. Overwrite it?"));
                    this.filename = n3 == 0 ? this.filename + ".mat" : null;
                }
            } else if (file.exists() && (n2 = TMStringUtil.confirm((MJFrame)this.exporterFrame, (String)"Save Confirmation", (String)("File " + file.getName() + " already exists. Overwrite it?"))) != 0) {
                this.filename = null;
            }
        } else {
            this.filename = null;
        }
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.exporterFrame = mJFrame;
        this.dialog = new MJDialog((Frame)mJFrame, "Data Exporter", true);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(404, 451);
        Point point = mJFrame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.show();
    }

    public class ExportTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return DataExporter.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (DataExporter.this.data == null) {
                return 0;
            }
            return DataExporter.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return DataExporter.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return DataExporter.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DataExporter.this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 0;
        }
    }

    public class ExportTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public ExportTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == DataExporter.this.columnNames.length - 1) {
                EditTextFieldTableCellEditor editTextFieldTableCellEditor = new EditTextFieldTableCellEditor((AbstractTableModel)DataExporter.this.model, new JTextField(), n, n2);
                editTextFieldTableCellEditor.checkForValidVariableName(DataExporter.this.exporterFrame);
                return editTextFieldTableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }
}

