/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.mathworks.desktop.event.EventHandler;
import com.mathworks.desktop.event.EventService;
import com.mathworks.desktop.event.EventSubscriber;
import com.mathworks.desktop.event.InvalidEventSubscriberException;
import com.mathworks.desktop.event.VetoableEvent;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.async.Callback;
import com.mathworks.util.async.Status;
import com.mathworks.util.logger.Log;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class DefaultEventService
implements EventService {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.desktop.event");
    private final SetMultimap<Class<?>, Listener> fClassBasedMap;
    private final SetMultimap<String, Listener> fNameBasedMap;
    private final SetMultimap<PatternWrapper, Listener> fPatternBasedMap;
    private final UIThreadInvoker fUIInvoker;
    private static final Supplier<Set<Listener>> FACTORY = new Supplier<Set<Listener>>(){

        public Set<Listener> get() {
            return new LinkedHashSet<Listener>();
        }
    };
    private static final UIThreadInvoker sUI_INVOKER = new UIThreadInvoker(){

        @Override
        public void invoke(Runnable runnable) {
            EventQueue.invokeLater(runnable);
        }
    };

    public DefaultEventService() {
        this(sUI_INVOKER);
    }

    public DefaultEventService(UIThreadInvoker uIThreadInvoker) {
        this.fUIInvoker = uIThreadInvoker;
        this.fClassBasedMap = Multimaps.newSetMultimap(new IdentityHashMap(), FACTORY);
        this.fNameBasedMap = Multimaps.newSetMultimap(new HashMap(), FACTORY);
        this.fPatternBasedMap = Multimaps.newSetMultimap(new HashMap(), FACTORY);
    }

    @Override
    public Status.And publish(Object object) {
        return this.publish(object, null);
    }

    @Override
    public Status.And publish(Object object, Object object2) {
        Preconditions.checkNotNull((Object)object, (Object)"Event cannot be null");
        Preconditions.checkArgument((!(object instanceof String) ? 1 : 0) != 0, (Object)"Use publishName to publish String events");
        PublishingState publishingState = new PublishingState();
        DefaultEventService.publishToList(object, object2, null, this.getListenersFor(object), publishingState, false);
        return this.publishToDeferredListeners(object, object2, publishingState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status.And publishName(String string, Object ... objectArray) {
        Preconditions.checkNotNull((Object)string, (Object)"Event name cannot be null");
        PublishingState publishingState = new PublishingState();
        ImmutableList immutableList = null;
        Object object = this.fNameBasedMap;
        synchronized (object) {
            if (this.fNameBasedMap.containsKey((Object)string)) {
                immutableList = ImmutableList.copyOf((Iterable)this.fNameBasedMap.get((Object)string));
            }
        }
        if (immutableList != null) {
            DefaultEventService.publishToList(string, null, objectArray, (Collection<Listener>)immutableList, publishingState, false);
        }
        object = null;
        SetMultimap<PatternWrapper, Listener> setMultimap = this.fPatternBasedMap;
        synchronized (setMultimap) {
            for (PatternWrapper patternWrapper : this.fPatternBasedMap.keySet()) {
                if (!patternWrapper.pattern().matcher(string).matches()) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                object.addAll(this.fPatternBasedMap.get((Object)patternWrapper));
            }
        }
        if (object != null) {
            DefaultEventService.publishToList(string, null, objectArray, object, publishingState, false);
        }
        return this.publishToDeferredListeners(string, null, publishingState, objectArray);
    }

    private Status.And publishToDeferredListeners(final Object object, final Object object2, final PublishingState publishingState, final Object[] objectArray) {
        int n;
        Status[] statusArray;
        int n2;
        if (publishingState.fUIListeners == null) {
            if (publishingState.fLastListeners != null) {
                DefaultEventService.publishToList(object, object2, objectArray, publishingState.fLastListeners, publishingState, true);
            }
            if (publishingState.fStatuses != null) {
                return new Status.And((Collection)publishingState.fStatuses);
            }
            return new Status.And(new Status[0]);
        }
        if (publishingState.fLastListeners != null) {
            publishingState.fUIListeners.addAll(publishingState.fLastListeners);
            publishingState.fLastListeners.clear();
        }
        if (publishingState.fStatuses != null) {
            n2 = publishingState.fStatuses.size();
            statusArray = new Status[n2 + publishingState.fUIListeners.size()];
            for (n = 0; n < n2; ++n) {
                statusArray[n] = (Status)publishingState.fStatuses.get(n);
            }
        } else {
            statusArray = new Status[publishingState.fUIListeners.size()];
            n2 = 0;
        }
        for (n = n2; n < statusArray.length; ++n) {
            statusArray[n2] = new Status.Future();
        }
        publishingState.fStatuses = null;
        this.fUIInvoker.invoke(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: {
                    try {
                        DefaultEventService.publishToList(object, object2, objectArray, publishingState.fUIListeners, publishingState, false);
                        if (publishingState.fLastListeners == null) break block13;
                        DefaultEventService.publishToList(object, object2, objectArray, publishingState.fLastListeners, publishingState, true);
                    }
                    catch (Exception exception) {
                        try {
                            LOG.warn((Throwable)exception);
                        }
                        catch (Throwable throwable) {
                            List list = publishingState.fStatuses;
                            int n = statusArray.length - (list == null ? 0 : list.size());
                            for (int i = n2; i < n; ++i) {
                                ((Status.Future)statusArray[i]).success(null);
                            }
                            if (list != null) {
                                Callback callback = new Callback(n){
                                    private AtomicInteger fIdx;
                                    final /* synthetic */ int val$size;
                                    {
                                        this.val$size = n;
                                        this.fIdx = new AtomicInteger(this.val$size);
                                    }

                                    public void success(Object object) {
                                        ((Status.Future)statusArray[this.fIdx.getAndIncrement()]).success(object);
                                    }

                                    public void fail(Object object) {
                                        ((Status.Future)statusArray[this.fIdx.getAndIncrement()]).fail(object);
                                    }
                                };
                                for (Status status : list) {
                                    status.on(callback);
                                }
                            }
                            throw throwable;
                        }
                        List list = publishingState.fStatuses;
                        int n = statusArray.length - (list == null ? 0 : list.size());
                        for (int i = n2; i < n; ++i) {
                            ((Status.Future)statusArray[i]).success(null);
                        }
                        if (list != null) {
                            Callback callback = new /* invalid duplicate definition of identical inner class */;
                            for (Status status : list) {
                                status.on(callback);
                            }
                        }
                    }
                }
                List list = publishingState.fStatuses;
                int n = statusArray.length - (list == null ? 0 : list.size());
                for (int i = n2; i < n; ++i) {
                    ((Status.Future)statusArray[i]).success(null);
                }
                if (list != null) {
                    Callback callback = new /* invalid duplicate definition of identical inner class */;
                    for (Status status : list) {
                        status.on(callback);
                    }
                }
            }
        });
        return new Status.And(statusArray);
    }

    private static void publishToList(Object object, Object object2, Object[] objectArray, Collection<Listener> collection, PublishingState publishingState, boolean bl) {
        boolean bl2 = EventQueue.isDispatchThread();
        block3: for (Listener listener : collection) {
            Object object3;
            if (listener.fHandShake != null && !Objects.equal((Object)listener.fHandShake, (Object)object2) || (object3 = listener.fSubscriber.get()) == null) continue;
            try {
                Object object4;
                if (listener.fUIOnly && !bl2) {
                    publishingState.add(listener);
                    continue;
                }
                if (listener.fOrder == Order.LAST && !bl) {
                    publishingState.addLast(listener);
                    continue;
                }
                if (objectArray != null && objectArray.length > 0) {
                    if (listener.fParameterTypes.length - 1 != objectArray.length) continue;
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object5 = objectArray[i];
                        if (object5 != null && !listener.fParameterTypes[i + 1].isAssignableFrom(object5.getClass())) continue block3;
                    }
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    objectArray2[0] = object;
                    System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                    object4 = listener.fMethod.invoke(object3, objectArray2);
                } else {
                    object4 = listener.fMethod.invoke(object3, object);
                }
                if (object4 == null) continue;
                if (object4 instanceof Status) {
                    publishingState.add((Status)object4);
                    continue;
                }
                publishingState.add((Status)new Status.Success(object4));
            }
            catch (InvocationTargetException invocationTargetException) {
                publishingState.add(invocationTargetException.getTargetException());
                LOG.warn((Throwable)invocationTargetException, "Error publishing event %s to %s.%s", new Object[]{object, object3.getClass(), listener.fMethod});
            }
            catch (Throwable throwable) {
                publishingState.add(throwable);
                LOG.warn(throwable, "Error publishing event %s to %s.%s", new Object[]{object, object3.getClass(), listener.fMethod});
            }
        }
    }

    @Override
    public Status.And publishVetoable(VetoableEvent vetoableEvent, Object object) {
        List<Listener> list = this.getListenersFor(vetoableEvent);
        if (!list.isEmpty()) {
            Status.Future[] futureArray = new Status.Future[list.size()];
            ArrayList<Status.Future> arrayList = new ArrayList<Status.Future>(futureArray.length);
            for (int i = 0; i < futureArray.length; ++i) {
                Status.Future future = new Status.Future();
                futureArray[futureArray.length - i - 1] = future;
                arrayList.add(future);
            }
            this.publishVetoableToList(vetoableEvent, object, list, new PublishingState(), arrayList, false);
            return new Status.And((Status[])futureArray);
        }
        return new Status.And(new Status[0]);
    }

    private void publishVetoableToList(final Object object, final Object object2, final List<Listener> list, final PublishingState publishingState, final List<Status.Future> list2, final boolean bl) {
        if (list.isEmpty()) {
            if (publishingState.fUIListeners == null) {
                if (publishingState.fLastListeners != null) {
                    List list3 = publishingState.fLastListeners;
                    publishingState.fLastListeners = null;
                    this.publishVetoableToList(object, object2, list3, publishingState, list2, true);
                }
            } else {
                final List list4 = publishingState.fUIListeners;
                if (publishingState.fLastListeners != null) {
                    list4.addAll(publishingState.fLastListeners);
                }
                publishingState.fLastListeners = null;
                publishingState.fUIListeners = null;
                this.fUIInvoker.invoke(new Runnable(){

                    @Override
                    public void run() {
                        DefaultEventService.this.publishVetoableToList(object, object2, list4, publishingState, list2, bl);
                    }
                });
            }
        } else {
            Object object3;
            boolean bl2 = false;
            boolean bl3 = false;
            Listener listener = list.remove(list.size() - 1);
            if ((listener.fHandShake == null || Objects.equal((Object)listener.fHandShake, (Object)object2)) && (object3 = listener.fSubscriber.get()) != null) {
                try {
                    if (listener.fUIOnly && !EventQueue.isDispatchThread()) {
                        publishingState.add(listener);
                    } else if (listener.fOrder == Order.LAST && !bl) {
                        publishingState.addLast(listener);
                    } else {
                        Status status = (Status)listener.fMethod.invoke(object3, object);
                        status.on(new Callback(){

                            public void success(Object object3) {
                                ((Status.Future)list2.remove(list2.size() - 1)).success(object3);
                                DefaultEventService.this.publishVetoableToList(object, object2, list, publishingState, list2, bl);
                            }

                            public void fail(Object object3) {
                                DefaultEventService.failList(list2, object3);
                            }
                        });
                        bl3 = true;
                    }
                    bl2 = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    publishingState.add(invocationTargetException.getTargetException());
                    LOG.warn((Throwable)invocationTargetException, "Error publishing event %s to %s.%s", new Object[]{object, object3.getClass(), listener.fMethod});
                    DefaultEventService.failList(list2, null);
                    return;
                }
                catch (Throwable throwable) {
                    publishingState.add(throwable);
                    LOG.warn(throwable, "Error publishing event %s to %s.%s", new Object[]{object, object3.getClass(), listener.fMethod});
                    DefaultEventService.failList(list2, null);
                    return;
                }
            }
            if (!bl2) {
                list2.remove(list2.size() - 1).success(null);
            }
            if (!bl3) {
                this.publishVetoableToList(object, object2, list, publishingState, list2, bl);
            }
        }
    }

    private static void failList(List<Status.Future> list, Object object) {
        for (Status.Future future : list) {
            future.fail(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Listener> getListenersFor(Object object) {
        ArrayList<Listener> arrayList = new ArrayList<Listener>();
        SetMultimap<Class<?>, Listener> setMultimap = this.fClassBasedMap;
        synchronized (setMultimap) {
            for (Class<?> clazz = object.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                Set set = this.fClassBasedMap.get(clazz);
                if (set == null) continue;
                arrayList.addAll(set);
            }
        }
        return arrayList;
    }

    @Override
    public <V> V subscribe(V v) {
        return this.subscribe(v, null, null, false);
    }

    @Override
    public <V> V subscribe(V v, Object object, Disposable disposable) {
        return this.subscribe(v, object, disposable, false);
    }

    @Override
    public <V> V subscribeWeakly(V v) {
        return this.subscribe(v, null, null, true);
    }

    @Override
    public <V> V unSubscribe(V v) {
        List<Listener> list = DefaultEventService.getListeners(v);
        if (!list.isEmpty()) {
            this.unRegister(list, v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void unRegister(List<Listener> list, V v) {
        SetMultimap<Class<?>, Listener> setMultimap = this.fClassBasedMap;
        synchronized (setMultimap) {
            for (Listener listener : list) {
                Object object;
                Method method = listener.fMethod;
                listener.fSubscriber = new Ref(v, false);
                boolean bl = false;
                EventHandler eventHandler = method.getAnnotation(EventHandler.class);
                if (eventHandler != null) {
                    HashSet<Object> hashSet;
                    object = eventHandler.name();
                    SetMultimap<String, Listener> setMultimap2 = eventHandler.names();
                    if (((String)object).length() != 0 || ((String[])setMultimap2).length != 0) {
                        bl = true;
                        hashSet = new HashSet<Object>();
                        if (((String)object).length() != 0) {
                            hashSet.add(object);
                        }
                        for (String string : setMultimap2) {
                            if (string == null || string.length() == 0) continue;
                            hashSet.add(string);
                        }
                        SetMultimap<String, Listener> setMultimap3 = this.fNameBasedMap;
                        synchronized (setMultimap3) {
                            for (String string : hashSet) {
                                this.fNameBasedMap.remove((Object)string, (Object)listener);
                            }
                            DefaultEventService.clean(this.fNameBasedMap);
                        }
                    }
                    if (eventHandler.pattern().length() != 0) {
                        bl = true;
                        hashSet = this.fPatternBasedMap;
                        synchronized (hashSet) {
                            this.fPatternBasedMap.remove((Object)new PatternWrapper(eventHandler.pattern()), (Object)listener);
                            DefaultEventService.clean(this.fPatternBasedMap);
                        }
                    }
                }
                if (bl || (object = listener.eventType()) == null || ((Class)object).isPrimitive()) continue;
                this.fClassBasedMap.remove(object, (Object)listener);
                DefaultEventService.clean(this.fClassBasedMap);
            }
        }
    }

    private static void clean(Multimap<?, Listener> multimap) {
        ArrayList<Map.Entry> arrayList = new ArrayList<Map.Entry>();
        for (Map.Entry entry : multimap.entries()) {
            if (((Listener)entry.getValue()).fSubscriber.get() != null) continue;
            arrayList.add(entry);
        }
        for (Map.Entry entry : arrayList) {
            multimap.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V subscribe(final V v, Object object, Disposable disposable, boolean bl) {
        List<Listener> list = DefaultEventService.getListeners(v);
        if (!list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Listener listener : list) {
                Object object2;
                Class<?> clazz;
                Method method = listener.fMethod;
                String string = DefaultEventService.getMethodSignature(method);
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                method.setAccessible(true);
                boolean bl2 = false;
                listener.fSubscriber = new Ref(v, bl);
                listener.fHandShake = object;
                EventHandler eventHandler = method.getAnnotation(EventHandler.class);
                if (eventHandler != null) {
                    HashSet<Object> hashSet2;
                    listener.fUIOnly = eventHandler.uiOnly();
                    clazz = eventHandler.order();
                    if ("last".equals(clazz)) {
                        listener.fOrder = Order.LAST;
                    } else if (!"".equals(clazz)) {
                        throw new InvalidEventSubscriberException("Event handler " + method + " has invalid order " + (String)((Object)clazz) + ", only order=last is supported");
                    }
                    object2 = eventHandler.name();
                    SetMultimap<String, Listener> setMultimap = eventHandler.names();
                    if (((String)object2).length() != 0 || ((String[])setMultimap).length != 0) {
                        hashSet2 = new HashSet<Object>();
                        if (((String)object2).length() != 0) {
                            hashSet2.add(object2);
                        }
                        for (String string2 : setMultimap) {
                            if (string2 == null || string2.length() == 0) continue;
                            hashSet2.add(string2);
                        }
                        if (listener.eventType() != String.class) {
                            throw new InvalidEventSubscriberException("Event handler " + method + " should have first parameter of class String");
                        }
                        SetMultimap<String, Listener> setMultimap2 = this.fNameBasedMap;
                        synchronized (setMultimap2) {
                            for (String string3 : hashSet2) {
                                this.fNameBasedMap.put((Object)string3, (Object)listener);
                            }
                            bl2 = true;
                        }
                    }
                    if (eventHandler.pattern().length() != 0) {
                        if (listener.eventType() != String.class) {
                            throw new InvalidEventSubscriberException("Event handler " + method + " should have first parameter of class String");
                        }
                        hashSet2 = this.fPatternBasedMap;
                        synchronized (hashSet2) {
                            this.fPatternBasedMap.put((Object)new PatternWrapper(eventHandler.pattern()), (Object)listener);
                            bl2 = true;
                        }
                    }
                    if (VetoableEvent.class.isAssignableFrom(listener.eventType()) && !Status.class.isAssignableFrom(listener.returnType())) {
                        throw new InvalidEventSubscriberException("Event handler " + method + " handles vetoable events, but does not return Status");
                    }
                }
                if (bl2) continue;
                clazz = listener.eventType();
                if (clazz != null && !clazz.isPrimitive()) {
                    object2 = this.fClassBasedMap;
                    synchronized (object2) {
                        this.fClassBasedMap.put((Object)clazz, (Object)listener);
                    }
                    if (!listener.fUIOnly || !VetoableEvent.class.isAssignableFrom(clazz)) continue;
                    throw new InvalidEventSubscriberException("UIOnly subscriber " + method + " attempted to subscribe to vetoable event " + clazz);
                }
                throw new InvalidEventSubscriberException("Event handler " + method + " should have at least one parameter and first parameters should not be primitive");
            }
            if (disposable != null) {
                Disposer.register((Disposable)new Disposable(){

                    public void dispose() {
                        DefaultEventService.this.unSubscribe(v);
                    }

                    public boolean isDisposed() {
                        return false;
                    }
                }, (Disposable)disposable);
            }
        } else {
            throw new InvalidEventSubscriberException("No event handlers found in subscriber " + v.getClass());
        }
        return v;
    }

    private static List<Listener> getListeners(Object object) {
        Class<?> clazz = object.getClass();
        ArrayList<Listener> arrayList = new ArrayList<Listener>();
        Collection<Class<?>> collection = DefaultEventService.getEventHandlerContainers(clazz);
        if (!collection.isEmpty()) {
            Class<?>[] classArray;
            for (Class object2 : collection) {
                classArray = object2.getAnnotation(EventSubscriber.class);
                boolean method = classArray.uiOnly();
                for (Method method2 : object2.getDeclaredMethods()) {
                    if (!DefaultEventService.isMyMethod(method2)) continue;
                    arrayList.add(new Listener(method2, method));
                }
            }
            for (Listener listener : arrayList) {
                classArray = listener.fMethod.getParameterTypes();
                try {
                    listener.fMethod = clazz.getDeclaredMethod(listener.fMethod.getName(), classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!DefaultEventService.isEventHandler(method)) continue;
            arrayList.add(new Listener(method, false));
        }
        return arrayList;
    }

    private static boolean isMyMethod(Method method) {
        return !method.isBridge() && !method.isSynthetic() && (method.getModifiers() & 8) == 0;
    }

    private static String getMethodSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder(method.getName());
        stringBuilder.append(":");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(clazz.getName()).append(",");
        }
        return stringBuilder.toString();
    }

    private static Collection<Class<?>> getEventHandlerContainers(Class<?> clazz) {
        return DefaultEventService.findEventHandlerContainers(clazz, new HashSet());
    }

    private static Set<Class<?>> findEventHandlerContainers(Class<?> clazz, Set<Class<?>> set) {
        if (clazz == null || clazz == Object.class || set.contains(clazz)) {
            return set;
        }
        if (DefaultEventService.isEventHandlerContainer(clazz)) {
            set.add(clazz);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            DefaultEventService.findEventHandlerContainers(clazz2, set);
        }
        DefaultEventService.findEventHandlerContainers(clazz.getSuperclass(), set);
        return set;
    }

    private static boolean isEventHandlerContainer(Class<?> clazz) {
        return clazz.isAnnotationPresent(EventSubscriber.class);
    }

    private static boolean isEventHandler(Method method) {
        return method.isAnnotationPresent(EventHandler.class) && DefaultEventService.isMyMethod(method);
    }

    public static interface UIThreadInvoker {
        public void invoke(Runnable var1);
    }

    private static class Ref {
        private Object fRef;
        private boolean fWeak;

        private Ref(Object object, boolean bl) {
            this.fWeak = bl;
            this.fRef = bl ? new WeakReference<Object>(object) : object;
        }

        public Object get() {
            if (this.fWeak) {
                return ((WeakReference)this.fRef).get();
            }
            return this.fRef;
        }

        public boolean equals(Object object) {
            Ref ref = (Ref)object;
            return ref.fWeak == this.fWeak && Objects.equal((Object)ref.get(), (Object)this.get());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fWeak, this.get()});
        }
    }

    private static class PatternWrapper {
        private Pattern fPattern;
        private String fPatternStr;

        private PatternWrapper(String string) {
            this.fPatternStr = string;
        }

        Pattern pattern() {
            if (this.fPattern == null) {
                this.fPattern = Pattern.compile(this.fPatternStr);
            }
            return this.fPattern;
        }

        public int hashCode() {
            return this.fPatternStr.hashCode();
        }

        public boolean equals(Object object) {
            return ((PatternWrapper)object).fPatternStr.equals(this.fPatternStr);
        }
    }

    private static class Listener {
        private Method fMethod;
        private Class<?>[] fParameterTypes;
        private boolean fUIOnly;
        private Ref fSubscriber;
        private Object fHandShake;
        private Order fOrder = Order.UNSPECIFIED;

        private Listener(Method method, boolean bl) {
            this.fMethod = method;
            this.fUIOnly = bl;
            this.fParameterTypes = method.getParameterTypes();
        }

        @Nullable
        Class<?> eventType() {
            return this.fParameterTypes.length > 0 ? this.fParameterTypes[0] : null;
        }

        Class<?> returnType() {
            return this.fMethod.getReturnType();
        }

        public boolean equals(Object object) {
            if (object instanceof Listener) {
                return ((Listener)object).fMethod.equals(this.fMethod) && ((Listener)object).fSubscriber.equals(this.fSubscriber);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fMethod, this.fSubscriber});
        }

        public String toString() {
            return this.fMethod.getName().toString();
        }
    }

    private static enum Order {
        FIRST,
        LAST,
        UNSPECIFIED;

    }

    private static class PublishingState {
        private List<Listener> fUIListeners;
        private List<Status> fStatuses;
        private List<Throwable> fErrors;
        private List<Listener> fLastListeners;

        private PublishingState() {
        }

        void add(Listener listener) {
            if (this.fUIListeners == null) {
                this.fUIListeners = new ArrayList<Listener>();
            }
            this.fUIListeners.add(listener);
        }

        void addLast(Listener listener) {
            if (this.fLastListeners == null) {
                this.fLastListeners = new ArrayList<Listener>();
            }
            this.fLastListeners.add(listener);
        }

        void add(Status status) {
            if (this.fStatuses == null) {
                this.fStatuses = new ArrayList<Status>();
            }
            this.fStatuses.add(status);
        }

        void add(Throwable throwable) {
            if (this.fErrors == null) {
                this.fErrors = new ArrayList<Throwable>();
            }
            this.fErrors.add(throwable);
        }
    }
}

