/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.DocumentationAnalyzer;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;

public class IndexUtils {
    private static final Set<String> SENTENCE_BREAK_TAGS = new HashSet<String>();
    private static final Set<String> NO_SPACE_TAGS;

    private IndexUtils() {
    }

    public static boolean isSentenceBreakTag(String tagName) {
        return SENTENCE_BREAK_TAGS.contains(tagName.toUpperCase(Locale.ENGLISH));
    }

    public static boolean isWordBreakTag(String tagName) {
        String upperTag = tagName.toUpperCase(Locale.ENGLISH);
        return !NO_SPACE_TAGS.contains(upperTag) && !SENTENCE_BREAK_TAGS.contains(upperTag);
    }

    public static String[] getDirectoriesForFilePath(String fromPath) {
        String[] pathParts = fromPath.split("[\\\\/]");
        String[] fromPathDirs = new String[pathParts.length - 1];
        System.arraycopy(pathParts, 0, fromPathDirs, 0, fromPathDirs.length);
        return fromPathDirs;
    }

    public static String resolveRelativePath(String relPath, String ... parentDirs) {
        String result = IndexUtils.resolveCurrentDirs(relPath);
        result = IndexUtils.resolveNonLeadingParentDirs(result);
        for (int i = parentDirs.length - 1; i > -1; --i) {
            result = result.startsWith("../") ? result.substring("../".length()) : parentDirs[i] + "/" + result;
        }
        return result;
    }

    private static String resolveCurrentDirs(String relPath) {
        return relPath.replaceAll("(^|/)\\./", "$1");
    }

    private static String resolveNonLeadingParentDirs(String relPath) {
        String result = relPath;
        boolean keepGoing = true;
        while (keepGoing) {
            String next = result.replaceAll("[^/]*\\w/\\.\\./", "");
            keepGoing = !next.equals(result);
            result = next;
        }
        return result;
    }

    public static boolean includeLinkInBreadCrumb(String href) {
        if (href == null || href.trim().length() == 0) {
            return false;
        }
        if (href.startsWith("..")) {
            return false;
        }
        return !href.equals("index.html");
    }

    static File getResourceDirectory(IndexerConfig config, boolean create) {
        File indexDir = config.getIndexDirectory();
        File parentDir = indexDir.getParentFile();
        File resourcesDir = new File(parentDir, "resources");
        if (resourcesDir.exists() || create && resourcesDir.mkdirs()) {
            return resourcesDir;
        }
        return null;
    }

    static File getProductResourceDirectory(IndexerConfig config, DocProduct product, boolean create) {
        File globalResourcesDir = IndexUtils.getResourceDirectory(config, create);
        if (globalResourcesDir != null) {
            File productResourcesDir = new File(globalResourcesDir, product.getShortName());
            productResourcesDir.mkdirs();
            return productResourcesDir;
        }
        return null;
    }

    public static Indexer createDocCenterIndexer(SearchLanguage language, IndexerConfig config, boolean create) throws IOException {
        DocumentationAnalyzer docCenterAnalyzer = DocumentationAnalyzer.getIndexAnalyzer(language);
        IndexLocation location = IndexUtils.getIndexLocation(config);
        return new LuceneIndexer(location, language, (Analyzer)docCenterAnalyzer, create);
    }

    private static IndexLocation getIndexLocation(IndexerConfig config) {
        File indexDir = config.getIndexDirectory();
        return new FileSystemIndexLocation(indexDir, false);
    }

    static {
        SENTENCE_BREAK_TAGS.add("H1");
        SENTENCE_BREAK_TAGS.add("H2");
        SENTENCE_BREAK_TAGS.add("H3");
        SENTENCE_BREAK_TAGS.add("H4");
        SENTENCE_BREAK_TAGS.add("BR");
        SENTENCE_BREAK_TAGS.add("P");
        SENTENCE_BREAK_TAGS.add("HR");
        SENTENCE_BREAK_TAGS.add("TABLE");
        SENTENCE_BREAK_TAGS.add("TR");
        SENTENCE_BREAK_TAGS.add("TD");
        SENTENCE_BREAK_TAGS.add("DIV");
        SENTENCE_BREAK_TAGS.add("PRE");
        SENTENCE_BREAK_TAGS.add("LI");
        SENTENCE_BREAK_TAGS.add("DL");
        SENTENCE_BREAK_TAGS.add("DT");
        SENTENCE_BREAK_TAGS.add("DD");
        NO_SPACE_TAGS = new HashSet<String>();
        NO_SPACE_TAGS.add("TT");
        NO_SPACE_TAGS.add("B");
        NO_SPACE_TAGS.add("I");
        NO_SPACE_TAGS.add("EM");
        NO_SPACE_TAGS.add("SPAN");
    }
}

