/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.classic;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.index.HtmlParser;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.classic.BodyFragmentHandler;
import com.mathworks.helpsearch.index.classic.ClassicHtmlParser;
import com.mathworks.helpsearch.index.classic.PageSummaryFragmentHandler;
import com.mathworks.helpsearch.index.classic.TitleFragmentHandler;
import com.mathworks.helpsearch.index.shared.DescriptionFragmentHandler;
import com.mathworks.helpsearch.index.shared.InfoTypeFragmentHandler;
import com.mathworks.helpsearch.index.shared.RefEntityFragmentHandler;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class ClassicDocHtmlParserFactory
implements HtmlParserFactory {
    @Override
    public HtmlParser createParserForDocument(Document domDoc, String relPath) {
        return new ClassicHtmlParser(domDoc, ClassicDocHtmlParserFactory.createHandlers());
    }

    private static List<XmlFragmentHandler> createHandlers() {
        ArrayList<XmlFragmentHandler> handlers = new ArrayList<XmlFragmentHandler>();
        handlers.add(new TitleFragmentHandler());
        handlers.add(new DescriptionFragmentHandler());
        handlers.add(new BodyFragmentHandler());
        handlers.add(new InfoTypeFragmentHandler(ContentFormat.CLASSIC_DOC));
        handlers.add(new RefEntityFragmentHandler());
        handlers.add(new PageSummaryFragmentHandler());
        return handlers;
    }
}

