/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import com.mathworks.helpsearch.index.DocumentBody;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.microdata.MicrodataUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MicrodataItemBuilder {
    private final Node fNode;
    private final MicrodataItem fItem;
    private final Map<String, Node> fNodesById;
    private final Set<Node> fVisitedNodes = new HashSet<Node>();
    private final List<DocumentBody> fActiveProperties = new LinkedList<DocumentBody>();

    private MicrodataItemBuilder(Node node, Map<String, Node> nodesById) {
        this.fNode = node;
        this.fItem = new MicrodataItem(MicrodataUtils.getAttribute(this.fNode, "itemtype"));
        this.fNodesById = nodesById;
    }

    static MicrodataItem buildMicrodataItem(Node node, Map<String, Node> nodesById) {
        MicrodataItemBuilder builder = new MicrodataItemBuilder(node, nodesById);
        builder.createMicrodataItem();
        return builder.fItem;
    }

    private void createMicrodataItem() {
        this.fVisitedNodes.add(this.fNode);
        LinkedList<Node> pendingNodes = new LinkedList<Node>(MicrodataItemBuilder.getChildNodes(this.fNode));
        pendingNodes.addAll(this.getItemRefNodes());
        for (Node pendingNode : pendingNodes) {
            this.parseNodeWithinItemScope(pendingNode);
        }
    }

    private List<Node> getItemRefNodes() {
        String[] itemRefIds = MicrodataItemBuilder.getMicrodataAttribute(this.fNode, "itemref");
        if (itemRefIds != null) {
            LinkedList<Node> itemRefNodes = new LinkedList<Node>();
            for (String itemRefId : itemRefIds) {
                Node itemRefNode = this.fNodesById.get(itemRefId);
                if (itemRefNode == null) continue;
                itemRefNodes.add(itemRefNode);
            }
            return itemRefNodes;
        }
        return Collections.emptyList();
    }

    private void parseNodeWithinItemScope(Node current) {
        if (this.fVisitedNodes.contains(current)) {
            throw new IllegalStateException();
        }
        this.fVisitedNodes.add(current);
        if (current.getNodeType() == 1) {
            this.handleElementNode(current);
        } else if (current.getNodeType() == 3) {
            this.handleTextNode(current);
        }
    }

    private void handleElementNode(Node current) {
        String itemScope = MicrodataUtils.getAttribute(current, "itemscope");
        String[] props = MicrodataItemBuilder.getMicrodataAttribute(current, "itemprop");
        if (itemScope == null) {
            boolean isContentProperty;
            for (DocumentBody body : this.fActiveProperties) {
                body.appendTagReplacement(current.getNodeName());
            }
            boolean bl = isContentProperty = props != null && !this.handleAttributeProperty(current, props);
            if (isContentProperty) {
                this.startContentProperty();
            }
            List<Node> children = MicrodataItemBuilder.getChildNodes(current);
            for (Node child : children) {
                this.parseNodeWithinItemScope(child);
            }
            if (isContentProperty) {
                this.endContentProperty(props);
            }
        } else if (props != null) {
            this.handleNestedItem(current, props);
        }
    }

    private boolean handleAttributeProperty(Node current, String[] props) {
        String propertyAttribute = MicrodataUtils.getPropertyAttribute(current.getNodeName());
        if (propertyAttribute != null) {
            for (String prop : props) {
                this.fItem.addStringProperty(prop, MicrodataUtils.getAttribute(current, propertyAttribute));
            }
            return true;
        }
        return false;
    }

    private void startContentProperty() {
        this.fActiveProperties.add(0, new DocumentBody());
    }

    private void endContentProperty(String[] props) {
        DocumentBody last = this.fActiveProperties.remove(0);
        for (String prop : props) {
            this.fItem.addStringProperty(prop, last.getBody());
        }
    }

    private void handleNestedItem(Node current, String[] props) {
        MicrodataItem childItem = MicrodataItemBuilder.buildMicrodataItem(current, this.fNodesById);
        for (String prop : props) {
            this.fItem.addItemProperty(prop, childItem);
        }
    }

    private void handleTextNode(Node current) {
        String value = current.getNodeValue();
        for (DocumentBody body : this.fActiveProperties) {
            body.append(value);
        }
    }

    private static String[] getMicrodataAttribute(Node node, String attName) {
        String attValue = MicrodataUtils.getAttribute(node, attName);
        return attValue == null ? null : attValue.split("\\s");
    }

    private static List<Node> getChildNodes(Node node) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            LinkedList<Node> childList = new LinkedList<Node>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                childList.add(childNodes.item(i));
            }
            return childList;
        }
        return Collections.emptyList();
    }
}

