/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.microdata.MicrodataItemBuilder;
import com.mathworks.helpsearch.index.microdata.MicrodataUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MicrodataParser {
    private final Document fDoc;
    private final List<MicrodataItem> fTopLevelItems = new LinkedList<MicrodataItem>();
    private final Map<String, Node> fNodesById = new HashMap<String, Node>();

    public MicrodataParser(Document doc) {
        this.fDoc = doc;
    }

    public void parseDocument() {
        Node documentElement;
        LinkedList<Node> topLevelItemNodes = new LinkedList<Node>();
        try {
            documentElement = this.fDoc.getDocumentElement();
        }
        catch (Exception e) {
            NodeList htmlElts = this.fDoc.getElementsByTagName("html");
            if (htmlElts.getLength() > 0) {
                documentElement = htmlElts.item(0);
            }
            return;
        }
        if (documentElement != null) {
            this.findTopLevelItemNodes(documentElement, topLevelItemNodes);
            for (Node topLevelItemNode : topLevelItemNodes) {
                MicrodataItem item = MicrodataItemBuilder.buildMicrodataItem(topLevelItemNode, this.fNodesById);
                this.fTopLevelItems.add(item);
            }
        }
    }

    private void findTopLevelItemNodes(Node node, List<Node> topLevelItems) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            String id = MicrodataUtils.getAttribute(node, "id");
            if (id != null && !this.fNodesById.containsKey(id)) {
                this.fNodesById.put(id, node);
            }
            if (MicrodataParser.isTopLevelItem(node)) {
                topLevelItems.add(node);
            }
        }
        int numChildren = node.getChildNodes().getLength();
        for (int i = 0; i < numChildren; ++i) {
            this.findTopLevelItemNodes(node.getChildNodes().item(i), topLevelItems);
        }
    }

    private static boolean isTopLevelItem(Node node) {
        return MicrodataUtils.getAttribute(node, "itemscope") != null && MicrodataUtils.getAttribute(node, "itemprop") == null;
    }

    public List<MicrodataItem> getTopLevelItems() {
        return Collections.unmodifiableList(this.fTopLevelItems);
    }
}

