/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.report.ReportSerializer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;

public class ReportWriter<T> {
    private final File fFile;
    private final ReportSerializer<T> fSerializer;

    public ReportWriter(File file, ReportSerializer<T> serializer) {
        this.fFile = file;
        this.fSerializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReport(Collection<T> items) throws IOException {
        if (items != null && !items.isEmpty()) {
            FileWriter writer = new FileWriter(this.fFile);
            try {
                for (T item : items) {
                    String line = this.fSerializer.toReportLine(item);
                    writer.append(line);
                    writer.append("\n");
                }
            }
            finally {
                writer.close();
            }
        } else if (this.fFile.exists()) {
            this.fFile.delete();
        }
    }
}

