/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.search.SearchResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ReferenceData {
    private final DocProduct fProduct;
    private final String fRelativePath;
    private final String fTopic;
    private final String fPurposeLine;
    private final String fDescription;
    private final RefEntityType fType;
    private final List<String> fSyntaxLines;

    public ReferenceData(DocProduct product, String topic, String relativePath, String purposeLine, String description, RefEntityType type, List<String> syntaxLines) {
        this.fProduct = product;
        this.fTopic = topic;
        this.fRelativePath = relativePath;
        this.fPurposeLine = purposeLine;
        this.fDescription = description;
        this.fType = type;
        if (syntaxLines == null) {
            syntaxLines = Collections.emptyList();
        }
        this.fSyntaxLines = new LinkedList<String>(syntaxLines);
    }

    public static ReferenceData fromSearchResult(DocumentationSet docSet, SearchResult result) {
        List<ReferenceEntity> entities;
        String prodName = result.getFieldValue(DocumentationSearchField.PRODUCT.getFieldName());
        DocProduct product = docSet.getProductByIndexString(prodName);
        String topic = null;
        RefEntityType type = null;
        String refEntityString = result.getFieldValue(DocumentationSearchField.REFPAGE_ENTITY_INFO.getFieldName());
        if (refEntityString != null && (entities = ReferenceEntity.fromIndexString(refEntityString.trim())) != null && !entities.isEmpty()) {
            ReferenceEntity firstEntity = entities.get(0);
            type = firstEntity.getType();
            topic = firstEntity.getName();
        }
        if (topic == null) {
            topic = result.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
        }
        String relPath = result.getFieldValue(DocumentationSearchField.RELATIVE_PATH.getFieldName());
        String purposeLine = result.getFieldValue(DocumentationSearchField.SUMMARY.getFieldName());
        String description = result.getFieldValue(DocumentationSearchField.DESCRIPTION.getFieldName());
        String rawSyntaxLines = result.getFieldValue(DocumentationSearchField.SYNTAX_LINES.getFieldName());
        List<Object> syntaxLines = rawSyntaxLines == null ? Collections.emptyList() : Arrays.asList(rawSyntaxLines.split("\\n"));
        return new ReferenceData(product, topic, relPath, purposeLine, description, type, syntaxLines);
    }

    public String getTopic() {
        return this.fTopic;
    }

    public String getPurposeLine() {
        return this.fPurposeLine;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public DocProduct getProduct() {
        return this.fProduct;
    }

    public String getRelativePath() {
        return this.fRelativePath;
    }

    public RefEntityType getType() {
        return this.fType;
    }

    public List<String> getSyntaxLines() {
        return Collections.unmodifiableList(this.fSyntaxLines);
    }
}

