/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.reference.ReferenceEntityNameComparator;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.SearchStringParser;

public class ReferenceSearchRequest
extends ReferenceRequest {
    private final SearchExpression fBaseExpression;
    private static final DocumentationSearchField[] DEFAULT_FIELDS = new DocumentationSearchField[]{DocumentationSearchField.TITLE_SEARCH};

    public ReferenceSearchRequest(SearchExpression expression) {
        this.fBaseExpression = expression;
    }

    public ReferenceSearchRequest(String searchString, SearchField<DocumentationSearchField> ... searchFields) throws SearchStringParseException {
        this(ReferenceSearchRequest.buildSearchExpression(searchString, searchFields));
        this.setResultComparator(new ReferenceEntityNameComparator(searchString));
    }

    @Override
    protected SearchExpression getBaseExpression() {
        return this.fBaseExpression;
    }

    private static SearchExpression buildSearchExpression(String searchString, SearchField<DocumentationSearchField> ... searchFields) throws SearchStringParseException {
        if (searchFields.length == 0) {
            searchFields = DEFAULT_FIELDS;
        }
        return SearchStringParser.buildExpression((String)searchString, (BooleanSearchOperator)BooleanSearchOperator.MUST_OCCUR, searchFields);
    }
}

