/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.array;

import com.mathworks.mde.array.ArrayEditorPrefs;
import com.mathworks.mde.array.ArrayEditorResources;
import com.mathworks.mde.array.FormatPrefComboBox;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.spreadsheet.SpreadsheetPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;

public class ArrayEditorPrefsPanel
extends MJPanel {
    private static ArrayEditorPrefsPanel sPrefsPanel = null;
    private FormatPrefComboBox fFormatComboBox;
    private MJCheckBox fEnterMovesCheckBox;
    private MJComboBox fEnterDirectionComboBox;
    private JFormattedTextField fDecimalSepTextField;
    private static Runnable sCommitter;

    private ArrayEditorPrefsPanel() {
        ResourceBundle resourceBundle = ArrayEditorResources.getBundle();
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 8, 8, 131072));
        this.fFormatComboBox = new FormatPrefComboBox();
        this.fFormatComboBox.setName("FormatComboBox");
        this.fFormatComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("prefs.arrayformat.access"));
        this.fFormatComboBox.setAlignmentX(0.0f);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout());
        mJPanel.setName("FormatPanel");
        mJPanel.add((Component)new MJLabel(resourceBundle.getString("prefs.arrayformat.label")));
        mJPanel.add((Component)((Object)this.fFormatComboBox));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(resourceBundle.getString("prefs.arrayformat.border")));
        mJPanel2.add((Component)mJPanel, (Object)"West");
        this.fEnterMovesCheckBox = new MJCheckBox(resourceBundle.getString("prefs.entermotion.check.box"));
        this.fEnterMovesCheckBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("prefs.entermotion.check.access"));
        this.fEnterMovesCheckBox.setName("EnterMovesCheckBox");
        this.fEnterMovesCheckBox.setAlignmentX(0.0f);
        MJLabel mJLabel = new MJLabel(resourceBundle.getString("prefs.entermotion.combo.box"));
        this.fEnterDirectionComboBox = new MJComboBox();
        this.fEnterDirectionComboBox.setName("EnterMovesComboBox");
        this.fEnterDirectionComboBox.addItem((Object)resourceBundle.getString("prefs.entermotion.combo.down"));
        this.fEnterDirectionComboBox.addItem((Object)resourceBundle.getString("prefs.entermotion.combo.right"));
        this.fEnterDirectionComboBox.addItem((Object)resourceBundle.getString("prefs.entermotion.combo.up"));
        this.fEnterDirectionComboBox.addItem((Object)resourceBundle.getString("prefs.entermotion.combo.left"));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new MGridLayout(0, 1, 4, 6, 196608, (Object)new Float(0.0f), null));
        mJPanel3.setName("EditingPanel");
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 3, 196608));
        mJPanel4.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        mJPanel4.add((Component)mJLabel);
        mJPanel4.add((Component)this.fEnterDirectionComboBox);
        mJPanel3.add((Component)this.fEnterMovesCheckBox);
        mJPanel3.add((Component)mJPanel4);
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel5.setBorder((Border)BorderFactory.createTitledBorder(resourceBundle.getString("prefs.entermotion.border")));
        mJPanel5.add((Component)mJPanel3, (Object)"West");
        try {
            this.fDecimalSepTextField = new JFormattedTextField(new MaskFormatter("*"));
        }
        catch (Exception exception) {
            this.fDecimalSepTextField = new JFormattedTextField();
        }
        this.fDecimalSepTextField.setColumns(2);
        this.fDecimalSepTextField.setValue(Character.toString(SpreadsheetPrefs.getDecimalSeparator()));
        this.fDecimalSepTextField.setName("DecimalSepTextField");
        this.fDecimalSepTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("prefs.decimalSep.access"));
        this.fFormatComboBox.setAlignmentX(0.0f);
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new FlowLayout());
        mJPanel6.setName("DecimalSepPanel");
        mJPanel6.add((Component)new MJLabel(resourceBundle.getString("prefs.decimalSep.label")));
        mJPanel6.add((Component)this.fDecimalSepTextField);
        MJPanel mJPanel7 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel7.setBorder((Border)BorderFactory.createTitledBorder(resourceBundle.getString("prefs.decimalSep.border")));
        mJPanel7.add((Component)mJPanel6, (Object)"West");
        Box box = Box.createVerticalBox();
        box.add((Component)mJPanel2);
        box.add((Component)mJPanel5);
        box.add((Component)mJPanel7);
        box.add(box.createVerticalGlue());
        this.add(box);
        sPrefsPanel = this;
        this.fEnterMovesCheckBox.addItemListener((ItemListener)new CBL());
        this.fEnterMovesCheckBox.setSelected(ArrayEditorPrefs.isEnterCausesMotion());
        this.fEnterDirectionComboBox.setSelectedIndex(ArrayEditorPrefs.getEnterMotionDirection());
        AEPrefL aEPrefL = new AEPrefL();
        Prefs.addListener((PrefListener)aEPrefL, (String)ArrayEditorPrefs.getEnterCausesMotionKey());
        Prefs.addListener((PrefListener)aEPrefL, (String)ArrayEditorPrefs.getEnterMotionDirectionKey());
        Prefs.addListener((PrefListener)aEPrefL, (String)SpreadsheetPrefs.getDecimalSeparatorKey());
    }

    private void updateEnabledStates() {
        this.fEnterDirectionComboBox.setEnabled(this.fEnterMovesCheckBox.isSelected());
    }

    private void savePrefs() {
        this.fFormatComboBox.savePreference();
        ArrayEditorPrefs.setEnterCausesMotion(this.fEnterMovesCheckBox.isSelected());
        ArrayEditorPrefs.setEnterMotionDirection(this.fEnterDirectionComboBox.getSelectedIndex());
        String string = (String)this.fDecimalSepTextField.getValue();
        if (string.length() > 0) {
            SpreadsheetPrefs.setDecimalSeparator((char)string.charAt(0));
        }
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            if (sCommitter == null) {
                sCommitter = new Committer();
            }
            SwingUtilities.invokeLater(sCommitter);
        }
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel == null) {
            sPrefsPanel = new ArrayEditorPrefsPanel();
        }
        return sPrefsPanel;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_arrayeditor_prefs"};
    }

    class AEPrefL
    implements PrefListener {
        AEPrefL() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals(ArrayEditorPrefs.getEnterCausesMotionKey())) {
                ArrayEditorPrefsPanel.this.fEnterMovesCheckBox.setSelected(ArrayEditorPrefs.isEnterCausesMotion());
            }
            if (prefEvent.getPrefKey().equals(ArrayEditorPrefs.getEnterMotionDirectionKey())) {
                ArrayEditorPrefsPanel.this.fEnterDirectionComboBox.setSelectedIndex(ArrayEditorPrefs.getEnterMotionDirection());
            }
            if (prefEvent.getPrefKey().equals(SpreadsheetPrefs.getDecimalSeparatorKey())) {
                ArrayEditorPrefsPanel.this.fDecimalSepTextField.setValue(Character.toString(SpreadsheetPrefs.getDecimalSeparator()));
            }
        }
    }

    static class Committer
    implements Runnable {
        Committer() {
        }

        @Override
        public void run() {
            sPrefsPanel.savePrefs();
        }
    }

    class CBL
    implements ItemListener {
        CBL() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayEditorPrefsPanel.this.updateEnabledStates();
        }
    }
}

