/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class CmdHistoryPrefsPanel
extends MJPanel {
    private static CmdHistoryPrefsPanel sPrefsPanel = null;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    private MJCheckBox fSaveExitCheckbox;
    private MJCheckBox fSaveDupCheckbox;
    private MJRadioButton fSaveOnQuitButton;
    private MJRadioButton fSaveNumCommandsButton;
    private MJRadioButton fDontSaveButton;
    private MJSpinner fSaveNCmdsSpinner;

    public CmdHistoryPrefsPanel() {
        this.setName("CommandHistoryPrefsPanel");
        int n = CmdHistoryPrefs.getHistoryOptions();
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("chpp.options.groupbox")));
        this.fSaveExitCheckbox = new MJCheckBox(sRes.getString("chpp.filter.exit"), (n & 8) != 0);
        this.fSaveExitCheckbox.setName("ExitCheckbox");
        mJPanel.add((Component)this.fSaveExitCheckbox);
        this.fSaveDupCheckbox = new MJCheckBox(sRes.getString("chpp.filter.dups"), (n & 4) != 0);
        this.fSaveDupCheckbox.setName("DupsCheckbox");
        mJPanel.add((Component)this.fSaveDupCheckbox);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(3, 1));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("chpp.save.groupbox")));
        ButtonGroup buttonGroup = new ButtonGroup();
        NLinesStateListener nLinesStateListener = new NLinesStateListener();
        this.fSaveOnQuitButton = new MJRadioButton(sRes.getString("chpp.quit.checkbox"), false);
        this.fSaveOnQuitButton.setName("SaveOnQuit");
        this.fSaveOnQuitButton.addItemListener((ItemListener)nLinesStateListener);
        buttonGroup.add((AbstractButton)this.fSaveOnQuitButton);
        mJPanel2.add((Component)this.fSaveOnQuitButton);
        int n2 = CmdHistoryPrefs.getSaveNLines();
        n2 = this.validateNCmds(n2);
        this.fSaveNCmdsSpinner = new MJSpinner(new SpinnerNumberModel(n2, 1, 99, 1)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 4;
                return dimension;
            }
        };
        this.fSaveNCmdsSpinner.setDefaultEditorAccessibleName(sRes.getString("chpp.nlines.label"));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fSaveNumCommandsButton = new MJRadioButton(sRes.getString("chpp.nlines.checkbox"), false);
        this.fSaveNumCommandsButton.setName("SaveOnNLines");
        this.fSaveNumCommandsButton.addItemListener((ItemListener)nLinesStateListener);
        buttonGroup.add((AbstractButton)this.fSaveNumCommandsButton);
        mJPanel3.add((Component)this.fSaveNumCommandsButton);
        mJPanel3.add((Component)this.fSaveNCmdsSpinner);
        MJLabel mJLabel = new MJLabel(sRes.getString("chpp.nlines.label"));
        mJPanel3.add((Component)mJLabel);
        mJPanel2.add((Component)mJPanel3);
        this.fDontSaveButton = new MJRadioButton(sRes.getString("chpp.nosave.checkbox"), false);
        this.fDontSaveButton.setName("NoSave");
        this.fDontSaveButton.addItemListener((ItemListener)nLinesStateListener);
        buttonGroup.add((AbstractButton)this.fDontSaveButton);
        mJPanel2.add((Component)this.fDontSaveButton);
        if ((n & 3) == 1) {
            this.fSaveOnQuitButton.setSelected(true);
        } else if ((n & 3) == 2) {
            this.fSaveNumCommandsButton.setSelected(true);
        } else {
            this.fDontSaveButton.setSelected(true);
        }
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.add((Component)mJPanel);
        this.add((Component)mJPanel2);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new CmdHistoryPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        int n = 0;
        if (this.fSaveOnQuitButton.isSelected()) {
            n |= 1;
        } else if (this.fSaveNumCommandsButton.isSelected()) {
            n |= 2;
        }
        if (this.fSaveDupCheckbox.isSelected()) {
            n |= 4;
        }
        if (this.fSaveExitCheckbox.isSelected()) {
            n |= 8;
        }
        CmdHistoryPrefs.setHistoryOptions(n);
        String string = this.fSaveNCmdsSpinner.getValue().toString();
        try {
            Integer n2 = new Integer(string);
            int n3 = n2;
            n3 = this.validateNCmds(n3);
            CmdHistoryPrefs.setSaveNLines(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int validateNCmds(int n) {
        if (n < 0 || n > 99) {
            n = 1;
        }
        return n;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env__commandhistory_prefs"};
    }

    class NLinesStateListener
    implements ItemListener {
        NLinesStateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getID() == 701) {
                CmdHistoryPrefsPanel.this.fSaveNCmdsSpinner.setEnabled(CmdHistoryPrefsPanel.this.fSaveNumCommandsButton.isSelected());
            }
        }
    }
}

