/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class FunctionBrowserRowHeader
extends MJPanel
implements DocumentListener {
    private MJButton fFunctionBrowserBtn;
    private XCmdWndView fCmdWin;
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
    private static int RIGHT_HORIZONTAL_BORDER = 0;
    private int fIconSize;
    private MJPopupMenu fPopup;

    public FunctionBrowserRowHeader(XCmdWndView xCmdWndView) {
        super(null);
        this.setName("FunctionBrowserRowHeader");
        Color color = UIManager.getColor("control");
        if (MJUtilities.isHighContrast() && ColorUtils.isDark((Color)color)) {
            color = Color.black;
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.white));
        }
        this.setBackground(color);
        this.fCmdWin = xCmdWndView;
        this.fitButtonIcon();
        this.fFunctionBrowserBtn.setOpaque(false);
        this.fFunctionBrowserBtn.setEnabled(false);
        this.fFunctionBrowserBtn.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.fFunctionBrowserBtn);
        this.fFunctionBrowserBtn.setName("FunctionBrowserRowHeader:fFunctionBrowserBtn");
        CmdWinDocument cmdWinDocument = CmdWinDocument.getInstance();
        cmdWinDocument.addDocumentListener(this);
        FontPrefs.addCodeFontListener((FontListener)new FontListener(){

            public void fontChanged(Font font) {
                FunctionBrowserRowHeader.this.fitButtonIcon();
                FunctionBrowserRowHeader.this.updatePreferredWidth();
                FunctionBrowserRowHeader.this.doLayout();
            }
        });
        this.fFunctionBrowserBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FunctionBrowserRowHeader.this.maybeOpenPopup(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FunctionBrowserRowHeader.this.maybeOpenPopup(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FunctionBrowserRowHeader.this.maybeOpenPopup(mouseEvent);
            }
        });
        if (Matlab.isMatlabAvailable()) {
            CmdWinMLIF.addMLExecutionListener(new MLExecutionListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
                    if (mLExecutionEvent.getInterpretedStatus() == MLExecutionEvent.InterpretedStatus.IDLE) {
                        CmdWinMLIF.removeMLExecutionListener(this);
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FunctionBrowserRowHeader.this.fFunctionBrowserBtn.setEnabled(true);
                            }
                        });
                    }
                }
            });
        }
        this.updatePreferredWidth();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    private Point getPromptPosition() {
        try {
            CmdWinDocument cmdWinDocument = CmdWinDocument.getInstance();
            Rectangle rectangle = this.fCmdWin.modelToView(cmdWinDocument.getAfterThePrompt());
            if (rectangle != null) {
                return new Point(rectangle.x, rectangle.y);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void maybeOpenPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && !MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent)) {
            return;
        }
        if (this.fPopup == null) {
            this.fPopup = new MJPopupMenu();
            this.fPopup.add((Action)new MJAbstractAction(resources.getString("functionbrowser.closemargin")){

                public void actionPerformed(ActionEvent actionEvent) {
                    CmdWinPrefs.setShowFunctionBrowser(false);
                }
            });
        }
        FunctionBrowser.closeUnfloating();
        this.fPopup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void fitButtonIcon() {
        int n = this.fIconSize = this.fCmdWin.fRowHeight - 2 < 16 ? 16 : this.fCmdWin.fRowHeight - 2;
        ApplicationIcon applicationIcon = MJUtilities.isHighContrast() && ColorUtils.isDark((Color)this.getBackground()) ? (this.fIconSize > 48 ? ApplicationIcon.FUNCTION_BROWSER64_HC : (this.fIconSize > 32 ? ApplicationIcon.FUNCTION_BROWSER48_HC : (this.fIconSize > 24 ? ApplicationIcon.FUNCTION_BROWSER32_HC : (this.fIconSize > 16 ? ApplicationIcon.FUNCTION_BROWSER24_HC : ApplicationIcon.FUNCTION_BROWSER16_HC)))) : (this.fIconSize > 48 ? ApplicationIcon.FUNCTION_BROWSER64 : (this.fIconSize > 32 ? ApplicationIcon.FUNCTION_BROWSER48 : (this.fIconSize > 24 ? ApplicationIcon.FUNCTION_BROWSER32 : (this.fIconSize > 16 ? ApplicationIcon.FUNCTION_BROWSER24 : ApplicationIcon.FUNCTION_BROWSER16))));
        if (this.fFunctionBrowserBtn == null) {
            MJAbstractAction mJAbstractAction = new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Cursor cursor = FunctionBrowserRowHeader.this.fFunctionBrowserBtn.getCursor();
                    FunctionBrowserRowHeader.this.fFunctionBrowserBtn.setCursor(new Cursor(3));
                    Point point = new Point(0, ((FunctionBrowserRowHeader)FunctionBrowserRowHeader.this).fFunctionBrowserBtn.getBounds().height);
                    SwingUtilities.convertPointToScreen(point, (Component)FunctionBrowserRowHeader.this.fFunctionBrowserBtn);
                    FunctionBrowser.open(new Rectangle(point.x, point.y, FunctionBrowserRowHeader.this.fFunctionBrowserBtn.getWidth(), FunctionBrowserRowHeader.this.fFunctionBrowserBtn.getHeight()), FunctionBrowserRowHeader.this.fCmdWin);
                    FunctionBrowserRowHeader.this.fFunctionBrowserBtn.setCursor(cursor);
                }
            };
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandWindow", "function-browser-key", (ExtendedAction)mJAbstractAction);
            this.fFunctionBrowserBtn = new MJButton((Action)mJAbstractAction);
        }
        this.fFunctionBrowserBtn.setIcon((Icon)applicationIcon.getIcon());
        MJToolBar.configureButton((MJButton)this.fFunctionBrowserBtn);
    }

    private void updatePreferredWidth() {
        int n = this.fCmdWin.fRowHeight + 1;
        if (this.fCmdWin.fRowHeight < this.fIconSize) {
            n = this.fIconSize;
        }
        this.setPreferredSize(new Dimension(n + RIGHT_HORIZONTAL_BORDER, -1));
    }

    public void doLayout() {
        Point point = this.getPromptPosition();
        if (point == null) {
            this.fFunctionBrowserBtn.setVisible(false);
            return;
        }
        this.fFunctionBrowserBtn.setVisible(true);
        Rectangle rectangle = this.fCmdWin.getBounds();
        Rectangle rectangle2 = null;
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.fCmdWin);
        if (jViewport != null) {
            rectangle2 = jViewport.getBounds();
        }
        int n = point.y + rectangle.y;
        int n2 = this.fCmdWin.fRowHeight + 1;
        if (this.fCmdWin.fRowHeight < this.fIconSize) {
            n2 = this.fIconSize;
            n -= (-this.fCmdWin.fRowHeight + this.fIconSize) / 2;
        }
        int n3 = n = n > rectangle.height - n2 ? rectangle.height - n2 : n;
        if (rectangle2 != null) {
            n = n > rectangle2.height - n2 ? rectangle2.height - n2 : n;
        }
        this.fFunctionBrowserBtn.setPreferredSize(new Dimension(n2, n2));
        this.fFunctionBrowserBtn.setBounds(new Rectangle(0, n, n2, n2));
    }

    public void setFunctionBrowserButtonEnabledForTesting(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FunctionBrowserRowHeader.this.fFunctionBrowserBtn != null) {
                    FunctionBrowserRowHeader.this.fFunctionBrowserBtn.setEnabled(bl);
                }
            }
        });
    }
}

