/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class EditorPrefsTabPanel
extends MJPanel {
    private static EditorPrefsTabPanel sPrefsPanel = null;
    private final MJTextField fSpacesPerTabInputField;
    private final MJTextField fSpacesPerIndentInputField;
    private final MJCheckBox fChangeTabsToSpaces;
    private final MJCheckBox fEmacsStyleTab;

    public EditorPrefsTabPanel() {
        this.setLayout((LayoutManager)new MGridLayout(1, 1, 6, 5, 131072));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.key.GroupIndents")));
        mJPanel.setName("Indents");
        MJLabel mJLabel = new MJLabel(EditorUtils.lookup("pref.key.TabSize"));
        mJLabel.setName("TabSizeLabel");
        this.fSpacesPerTabInputField = new MJTextField(String.valueOf(EditorOptions.getSpacesPerTab()), 3);
        this.fSpacesPerTabInputField.setName("TabSizeInputField");
        this.fSpacesPerTabInputField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.key.acc.TabSize"));
        this.fChangeTabsToSpaces = new MJCheckBox(EditorUtils.lookup("pref.key.Spaces"), EditorOptions.isTabChangedToSpaces());
        this.fChangeTabsToSpaces.setName("TabSpaceCheckbox");
        MJLabel mJLabel2 = new MJLabel(EditorUtils.lookup("pref.key.IndentSize"));
        mJLabel2.setName("IndentSizeLabel");
        this.fSpacesPerIndentInputField = new MJTextField(String.valueOf(EditorOptions.getSpacesPerIndent()), 3);
        this.fSpacesPerIndentInputField.setName("IndentSizeInputField");
        this.fSpacesPerIndentInputField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.key.acc.IndentSize"));
        this.fEmacsStyleTab = new MJCheckBox(EditorUtils.lookup("pref.key.EmacsStyle"), EditorOptions.isEmacsStyleTab());
        this.fEmacsStyleTab.setName("EmacsStyleTabCheckbox");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.fSpacesPerTabInputField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        mJPanel.add((Component)this.fChangeTabsToSpaces, (Object)gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        mJPanel.add((Component)mJLabel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.fSpacesPerIndentInputField, (Object)gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        mJPanel.add((Component)this.fEmacsStyleTab, (Object)gridBagConstraints);
        this.add((Component)mJPanel);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(MessageFormat.format(EditorUtils.lookup("pref.key.view.message"), EditorUtils.lookup("pref.key.link.tabcompletion")), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)EditorUtils.lookupInPrefsBundle("area.keyboard"));
            }
        }, false, "TabCompPrefLink", "Link to tab completion preferences.");
        HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel(MessageFormat.format(EditorUtils.lookup("pref.key.view.message"), EditorUtils.lookup("pref.key.link.indent")), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)(EditorUtils.lookupInPrefsBundle("area.editordebugger") + "." + EditorUtils.lookupInPrefsBundle("area.editordebugger.language")));
            }
        }, false, "EditorLangPrefLink", "Link to Editor language preferences.");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        mJPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)gridBagConstraints);
        gridBagConstraints.gridy = 3;
        mJPanel.add((Component)hyperlinkTextLabel2.getComponent(), (Object)gridBagConstraints);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsTabPanel();
        sPrefsPanel.setName("EditorPrefsTabPanel");
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        EditorOptions.setSpacesPerTab(Math.max(1, new Integer(this.fSpacesPerTabInputField.getText())));
        EditorOptions.setSpacesPerIndent(Math.max(1, new Integer(this.fSpacesPerIndentInputField.getText())));
        EditorOptions.setTabChangedToSpaces(this.fChangeTabsToSpaces.isSelected());
        EditorOptions.setEmacsStyleTab(this.fEmacsStyleTab.isSelected());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_editorkeyboard_prefs"};
    }
}

