/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.matlab.api.debug.BreakpointMarginPopUpMenu;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointMargin;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.debug.DebuggerManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.Validate;

public class MatlabBreakpointViewPopupBuilder
implements BreakpointMarginPopUpMenu<MatlabBreakpoint> {
    private MJPopupMenu fBreakpointContextMenu = new MJPopupMenu();
    private int fActionedLineNumber = -1;
    private final MatlabBreakpointMargin fBreakpointMargin;
    private static final String ELLIPSIS = "...";

    public MatlabBreakpointViewPopupBuilder(MatlabBreakpointMargin matlabBreakpointMargin) {
        Validate.notNull((Object)matlabBreakpointMargin, (String)"The given BreakpointMargin cannot be null.");
        this.fBreakpointMargin = matlabBreakpointMargin;
    }

    public JPopupMenu buildPopupMenu(int n, Collection<MatlabBreakpoint> collection, int n2) {
        boolean bl;
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"The given line number must be greater than or equal to zero.");
        Validate.notNull(collection, (String)"The given list of breakpoints cannot be null.");
        Validate.isTrue((n2 >= 0 ? 1 : 0) != 0, (String)"The number of possible in line breakpoints must be greater than or equal to zero.");
        MatlabBreakpointViewPopupBuilder.validateBreakpointsAreAllOnGivenLine(n, collection);
        if (!DebuggerManager.getInstance().supportsConditionalBreakpoints()) {
            return null;
        }
        this.fActionedLineNumber = n;
        this.fBreakpointContextMenu = new MJPopupMenu();
        int n3 = n2 + 1;
        boolean bl2 = n2 > 0;
        boolean bl3 = bl = collection.size() == n3;
        if (collection.isEmpty()) {
            this.buildPopupMenuForLineWithoutBreakpoints(bl2);
        } else if (collection.size() == 1) {
            this.buildPopupForSingleBreakpoint(bl2, collection.iterator().next());
        } else {
            this.buildPopupForMultipleBreakpoints(bl);
        }
        return this.fBreakpointContextMenu;
    }

    private void buildPopupForSingleBreakpoint(boolean bl, MatlabBreakpoint matlabBreakpoint) {
        if (bl) {
            this.buildPopupMenuForLineWithSingleBreakpointAndMultipleBreakpointsPossible(matlabBreakpoint);
        } else {
            this.buildPopupMenuForLineWithSingleBreakpointAndSingleBreakpointPossible(matlabBreakpoint);
        }
    }

    private void buildPopupForMultipleBreakpoints(boolean bl) {
        if (bl) {
            this.buildPopupMenuForLineWithMultipleBreakpointsAndNoMorePossible();
        } else {
            this.buildPopupMenuForLineWithMultipleBreakpointsAndMorePossible();
        }
    }

    private void buildPopupMenuForLineWithoutBreakpoints(boolean bl) {
        this.fBreakpointContextMenu.add((Action)this.createSetBreakpointAction(bl));
        this.fBreakpointContextMenu.add((Action)this.createSetConditionalBreakpointAction());
    }

    private void buildPopupMenuForLineWithSingleBreakpointAndSingleBreakpointPossible(MatlabBreakpoint matlabBreakpoint) {
        this.fBreakpointContextMenu.add((Action)this.createModifyConditionAction(matlabBreakpoint));
        this.fBreakpointContextMenu.add((Action)this.createToggleEnabledStateAction(matlabBreakpoint));
        this.fBreakpointContextMenu.add((Action)this.createRemoveBreakpointAction(matlabBreakpoint));
    }

    private void buildPopupMenuForLineWithSingleBreakpointAndMultipleBreakpointsPossible(MatlabBreakpoint matlabBreakpoint) {
        this.fBreakpointContextMenu.add((Action)this.createModifyConditionAction(matlabBreakpoint));
        this.fBreakpointContextMenu.add((Action)this.createToggleEnabledStateAction(matlabBreakpoint));
        this.fBreakpointContextMenu.add((Action)this.createRemoveBreakpointAction(matlabBreakpoint));
        this.fBreakpointContextMenu.addSeparator();
        this.fBreakpointContextMenu.add((Action)this.createAddBreakpointAction());
    }

    private void buildPopupMenuForLineWithMultipleBreakpointsAndNoMorePossible() {
        this.fBreakpointContextMenu.add((Action)this.createEditExistingBreakpointsAction());
    }

    private void buildPopupMenuForLineWithMultipleBreakpointsAndMorePossible() {
        this.fBreakpointContextMenu.add((Action)this.createEditExistingBreakpointsAction());
        this.fBreakpointContextMenu.addSeparator();
        this.fBreakpointContextMenu.add((Action)this.createAddBreakpointAction());
    }

    private MJAbstractAction createSetConditionalBreakpointAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("contextMenu.SetConditional")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.setConditionalBreakpoint(MatlabBreakpointViewPopupBuilder.this.fActionedLineNumber);
            }
        };
    }

    private MJAbstractAction createModifyConditionAction(final MatlabBreakpoint matlabBreakpoint) {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("contextMenu.SetModifyCondition")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.modifyBreakpointsExpression(matlabBreakpoint);
            }
        };
    }

    private MJAbstractAction createEditExistingBreakpointsAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("contextMenu.EditExisting")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.editAllBreakpointsOnLine(MatlabBreakpointViewPopupBuilder.this.fActionedLineNumber);
            }
        };
    }

    private MJAbstractAction createToggleEnabledStateAction(final MatlabBreakpoint matlabBreakpoint) {
        String string = matlabBreakpoint.isEnabled() ? MatlabBreakpointUtils.lookup("contextMenu.DisableBreakpoint") : MatlabBreakpointUtils.lookup("contextMenu.EnableBreakpoint");
        return new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.toggleEnablement(matlabBreakpoint);
            }
        };
    }

    private MJAbstractAction createRemoveBreakpointAction(final MatlabBreakpoint matlabBreakpoint) {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("contextMenu.RemoveBreakpoint")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.clearBreakpoint(matlabBreakpoint);
            }
        };
    }

    private MJAbstractAction createSetBreakpointAction(boolean bl) {
        String string = bl ? MatlabBreakpointUtils.lookup("contextMenu.SetBreakpoint") + ELLIPSIS : MatlabBreakpointUtils.lookup("contextMenu.SetBreakpoint");
        return new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.setBreakpoint(MatlabBreakpointViewPopupBuilder.this.fActionedLineNumber);
            }
        };
    }

    private MJAbstractAction createAddBreakpointAction() {
        String string = MatlabBreakpointUtils.lookup("contextMenu.AddBreakpoint");
        return new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpointViewPopupBuilder.this.fBreakpointMargin.setBreakpoint(MatlabBreakpointViewPopupBuilder.this.fActionedLineNumber);
            }
        };
    }

    private static void validateBreakpointsAreAllOnGivenLine(int n, Collection<MatlabBreakpoint> collection) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            if (matlabBreakpoint.getZeroBasedLineNumber() == n) continue;
            throw new IllegalArgumentException("The given breakpoints is not on the given line.");
        }
    }
}

