/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.codepad;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.LightweightWindow;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import com.mathworks.widgets.menus.DefaultMenuGroupID;
import com.mathworks.widgets.menus.DefaultMenuID;
import com.mathworks.widgets.text.STPInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.text.JTextComponent;

public class CodepadMenuContributor
implements MenuContributor<Editor> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(CodepadMenuContributor.class.getPackage().getName() + ".resources.RES_Codepad_Toolstrip");
    public static final String CODEPAD_MENU_NAME = "CodepadMenu";

    public Class<Editor> getContributionTarget() {
        return Editor.class;
    }

    public void contribute(Editor editor, MenuContext menuContext) {
        if (!editor.isMCode()) {
            return;
        }
        DefaultMenuID defaultMenuID = new DefaultMenuID("codepad");
        menuContext.addNewMenu((MenuID)defaultMenuID, EditorUtils.lookup("menu.Codepad"), CODEPAD_MENU_NAME);
        MenuBuilder menuBuilder = menuContext.getBuilder((MenuID)defaultMenuID);
        CodepadActionManager codepadActionManager = CodepadActionManager.getCodepadActionManager(editor);
        DefaultMenuGroupID defaultMenuGroupID = new DefaultMenuGroupID("ModeGroup");
        menuBuilder.insertNextGroup((MenuGroupID)defaultMenuGroupID);
        menuBuilder.add((MenuGroupID)defaultMenuGroupID, CodepadActionManager.getModeAction());
        DefaultMenuGroupID defaultMenuGroupID2 = new DefaultMenuGroupID("EvaluateGroup");
        menuBuilder.insertNextGroup((MenuGroupID)defaultMenuGroupID2);
        menuBuilder.add((MenuGroupID)defaultMenuGroupID2, codepadActionManager.getEvaluateCellAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID2, codepadActionManager.getEvaluateCellAdvanceAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID2, codepadActionManager.getEvaluateFileAction());
        DefaultMenuGroupID defaultMenuGroupID3 = new DefaultMenuGroupID("InsertGroup");
        menuBuilder.insertNextGroup((MenuGroupID)defaultMenuGroupID3);
        menuBuilder.add((MenuGroupID)defaultMenuGroupID3, codepadActionManager.getAddDividerAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID3, codepadActionManager.getCreateCellAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID3, (Component)codepadActionManager.createCodepadInsertMenu());
        DefaultMenuGroupID defaultMenuGroupID4 = new DefaultMenuGroupID("NavigateGroup");
        menuBuilder.insertNextGroup((MenuGroupID)defaultMenuGroupID4);
        menuBuilder.add((MenuGroupID)defaultMenuGroupID4, codepadActionManager.getNextAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID4, codepadActionManager.getPreviousAction());
    }

    public void contributeToContextMenu(final Editor editor, MenuBuilder menuBuilder) {
        if (!editor.isMCode() || !Codepad.isCodepadEnabled()) {
            return;
        }
        CodepadActionManager codepadActionManager = CodepadActionManager.getCodepadActionManager(editor);
        DefaultMenuGroupID defaultMenuGroupID = new DefaultMenuGroupID("CellGroup");
        menuBuilder.insertGroupAfter((MenuGroupID)EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, (MenuGroupID)defaultMenuGroupID);
        menuBuilder.add((MenuGroupID)defaultMenuGroupID, codepadActionManager.getEvaluateCellAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID, codepadActionManager.getAddDividerAction().isEnabled() ? codepadActionManager.getAddDividerAction() : codepadActionManager.getCreateCellAction());
        menuBuilder.add((MenuGroupID)defaultMenuGroupID, (Component)codepadActionManager.createCodepadInsertMenu());
        Codepad codepad = (Codepad)editor.getProperty((Object)"Codepad");
        STPInterface sTPInterface = codepad.getSyntaxTextPane();
        if (Codepad.atNumericValue(sTPInterface)) {
            DefaultMenuGroupID defaultMenuGroupID2 = new DefaultMenuGroupID("CellIncrement");
            menuBuilder.insertGroupBefore((MenuGroupID)EditorMenuGroupID.CONTEXT_SELECTION_GROUP, (MenuGroupID)defaultMenuGroupID2);
            menuBuilder.add((MenuGroupID)defaultMenuGroupID2, (Action)new MJAbstractAction(BUNDLE.getString("Tool.increment_and_run.Label")){

                public void actionPerformed(ActionEvent actionEvent) {
                    new CodepadPopup(editor).show();
                }
            });
        }
    }

    private static final class CodepadPopup {
        private final LightweightWindow fPopup;

        private CodepadPopup(Editor editor) {
            MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("pref, 1dlu, pref, 1dlu, pref", "pref, 3dlu, pref"));
            CodepadActionManager codepadActionManager = CodepadActionManager.getCodepadActionManager(editor);
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel.add((Component)CodepadPopup.createButton(codepadActionManager.getMinusAction()), (Object)cellConstraints.xy(1, 1));
            mJPanel.add((Component)codepadActionManager.getIncrementField(), (Object)cellConstraints.xy(3, 1));
            mJPanel.add((Component)CodepadPopup.createButton(codepadActionManager.getPlusAction()), (Object)cellConstraints.xy(5, 1));
            mJPanel.add((Component)CodepadPopup.createButton(codepadActionManager.getDivideAction()), (Object)cellConstraints.xy(1, 3));
            mJPanel.add((Component)codepadActionManager.getMultiplyField(), (Object)cellConstraints.xy(3, 3));
            mJPanel.add((Component)CodepadPopup.createButton(codepadActionManager.getMultiplyAction()), (Object)cellConstraints.xy(5, 3));
            this.fPopup = new LightweightWindow((Frame)MJFrame.getFrame((Component)editor.getComponent()), BUNDLE.getString("Tool.increment_and_run.Label"), (Component)mJPanel, null, false);
            this.fPopup.getWindow().pack();
            Rectangle rectangle = WindowUtils.computeTextPopupBounds((Dimension)this.fPopup.getWindow().getPreferredSize(), (Dimension)this.fPopup.getWindow().getMinimumSize(), (JTextComponent)editor.getTextComponent(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
            this.fPopup.getWindow().setBounds(rectangle);
            new SelfRemovingEditorEventListener(editor){

                public void cleanup() {
                    CodepadPopup.this.fPopup.getWindow().dispose();
                }
            };
        }

        private static MJButton createButton(Action action) {
            MJButton mJButton = new MJButton(action);
            MJToolBar.configureButton((MJButton)mJButton);
            return mJButton;
        }

        public void show() {
            this.fPopup.getWindow().setVisible(true);
        }
    }
}

