/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.mde.editor.plugins.matlab.RunMenuUtils;
import com.mathworks.mwswing.MJPanel;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class RunMenuItemSelectionManager {
    private int fSelectedIndex = -1;
    private final MJPanel fSelectionManagerPanel;

    public RunMenuItemSelectionManager(MJPanel mJPanel) {
        this.fSelectionManagerPanel = mJPanel;
        this.fSelectionManagerPanel.getActionMap().put("down", new AbstractAction("down"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunMenuItemSelectionManager.this.adjustSelectedPosition(RunMenuItemSelectionManager.this.fSelectionManagerPanel, SelectionDirection.DOWN);
                RunMenuUtils.adjustPaintedSelection(RunMenuItemSelectionManager.this.fSelectionManagerPanel, RunMenuItemSelectionManager.this.fSelectedIndex);
            }
        });
        this.fSelectionManagerPanel.getActionMap().put("up", new AbstractAction("up"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunMenuItemSelectionManager.this.adjustSelectedPosition(RunMenuItemSelectionManager.this.fSelectionManagerPanel, SelectionDirection.UP);
                RunMenuUtils.adjustPaintedSelection(RunMenuItemSelectionManager.this.fSelectionManagerPanel, RunMenuItemSelectionManager.this.fSelectedIndex);
            }
        });
        this.fSelectionManagerPanel.getActionMap().put("enter", new AbstractAction("enter"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RunMenuItemSelectionManager.this.fSelectedIndex >= 0) {
                    JComponent jComponent = ((SelectableMenuItem)((Object)RunMenuItemSelectionManager.this.fSelectionManagerPanel.getComponent(RunMenuItemSelectionManager.this.fSelectedIndex))).getFocusableComponent();
                    jComponent.dispatchEvent(new KeyEvent(jComponent, 401, 0L, 0, 10, '\n'));
                }
            }
        });
        InputMap inputMap = this.fSelectionManagerPanel.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "up");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "down");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "enter");
    }

    public int getSelectedIndex() {
        return this.fSelectedIndex;
    }

    void setSelectedPosition(int n) {
        this.fSelectedIndex = n;
    }

    private void adjustSelectedPosition(MJPanel mJPanel, SelectionDirection selectionDirection) {
        if (SelectionDirection.DOWN == selectionDirection) {
            ++this.fSelectedIndex;
        } else if (SelectionDirection.UP == selectionDirection) {
            --this.fSelectedIndex;
        }
        if (this.fSelectedIndex >= mJPanel.getComponentCount()) {
            this.fSelectedIndex = 0;
        } else if (this.fSelectedIndex < 0) {
            this.fSelectedIndex = this.fSelectionManagerPanel.getComponentCount() - 1;
        }
    }

    public static interface SelectableMenuItem {
        public JComponent getFocusableComponent();
    }

    private static enum SelectionDirection {
        UP,
        DOWN;

    }
}

