/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.mlint;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import java.io.File;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class CodeAnalyzerReportUtils {
    private CodeAnalyzerReportUtils() {
    }

    public static void showCodeAnalyzerReport(@NotNull Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        if (editor.negotiateSave()) {
            String string = MLintPrefsUtils.getActiveConfiguration().getFile().getAbsolutePath();
            StorageLocation storageLocation = editor.getStorageLocation();
            assert (storageLocation instanceof FileStorageLocation) : "The Editor is not backed by a File.";
            File file = ((FileStorageLocation)storageLocation).getFile();
            EditorUtils.getMatlab().eval("mlintrpt ('" + StringUtils.quoteSingleQuotes((String)FileUtils.normalizePathname((String)file.getAbsolutePath())) + "','file','" + StringUtils.quoteSingleQuotes((String)string) + "')", EditorUtils.createErrorListener(editor.getComponent()));
        }
    }
}

