/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;

public class TargetDialog
extends MJDialog {
    private String fFunctionName;
    private MJComboBox fEditorCombo;
    private MJRadioButton fCmdLineRadio;
    private static final String FILESEP = System.getProperty("file.separator");
    private static final String resStr = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    private static final String key = "TargetDialog.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");

    TargetDialog(Dialog dialog, String string) {
        super(dialog, "MATLAB", true);
        this.setName("TargetDialog");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        MJLabel mJLabel = new MJLabel((Icon)DialogIcon.WARNING_48x48.getIcon());
        mJPanel.add((Component)mJLabel, (Object)"North");
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.getContentPane().add((Component)mJPanel, "West");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        this.getContentPane().add((Component)mJPanel2, "Center");
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        String string2 = resources.getString("TargetDialog.Question");
        MJLabel mJLabel2 = new MJLabel(string2);
        mJPanel2.add((Component)mJLabel2, (Object)"North");
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setLayout((LayoutManager)new BoxLayout((Container)mJPanel3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fCmdLineRadio = new MJRadioButton(resources.getString("TargetDialog.CmdLineOption"));
        this.fCmdLineRadio.setAlignmentX(0.0f);
        this.fCmdLineRadio.setSelected(true);
        this.fCmdLineRadio.setName("TargetDialog.CmdLineRadio");
        MJRadioButton mJRadioButton = new MJRadioButton(resources.getString("TargetDialog.EditorOption"));
        mJRadioButton.setAlignmentX(0.0f);
        mJRadioButton.setSelected(false);
        mJRadioButton.setName("TargetDialog.EditorRadio");
        buttonGroup.add((AbstractButton)this.fCmdLineRadio);
        buttonGroup.add((AbstractButton)mJRadioButton);
        mJPanel3.add((Component)this.fCmdLineRadio);
        mJPanel3.add((Component)mJRadioButton);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new FlowLayout(0));
        mJPanel4.setAlignmentX(0.0f);
        this.fEditorCombo = new MJComboBox();
        this.build(string);
        this.fEditorCombo.setRenderer((ListCellRenderer)new EditorComboRenderer());
        this.fEditorCombo.setEnabled(false);
        this.fEditorCombo.setName("TargetDialog.EditorCombo");
        mJPanel4.add(Box.createHorizontalStrut(10));
        mJPanel4.add((Component)this.fEditorCombo);
        this.fEditorCombo.setPreferredSize(new Dimension(mJRadioButton.getPreferredSize().width, this.fEditorCombo.getPreferredSize().height));
        mJPanel3.add((Component)mJPanel4);
        mJPanel2.add((Component)mJPanel3, (Object)"Center");
        this.fCmdLineRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetDialog.this.fEditorCombo.setEnabled(!TargetDialog.this.fCmdLineRadio.isSelected());
            }
        });
        mJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetDialog.this.fEditorCombo.setEnabled(!TargetDialog.this.fCmdLineRadio.isSelected());
            }
        });
        this.setFilePathToolTip();
        MJPanel mJPanel5 = new MJPanel();
        MJButton mJButton = new MJButton(resources.getString("TargetDialog.OK"));
        mJButton.setName("TargetDialog.OK");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TargetDialog.this.fCmdLineRadio.isSelected()) {
                    TargetDialog.insertToCommandWindow(TargetDialog.this.fFunctionName);
                } else {
                    String string = TargetDialog.this.fEditorCombo.getSelectedItem().toString();
                    Editor editor = (Editor)TargetDialog.this.fEditorCombo.getSelectedItem();
                    editor.insertAndFormatTextAtCaret(TargetDialog.this.fFunctionName);
                    Desktop desktop = MatlabDesktopServices.getDesktop();
                    Component[] componentArray = desktop.getGroupMembers("Editor");
                    boolean bl = false;
                    for (Component component : componentArray) {
                        String string2 = desktop.getTitle(component);
                        if (string2.indexOf(string) != 0) continue;
                        desktop.showClient(string2, "Editor");
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        desktop.showClient(TargetDialog.stripPath(string), "Editor");
                    }
                }
                TargetDialog.this.setVisible(false);
            }
        });
        mJPanel5.add((Component)mJButton);
        MJButton mJButton2 = new MJButton(resources.getString("TargetDialog.Cancel"));
        mJButton2.setName("TargetDialog.Cancel");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetDialog.this.setVisible(false);
            }
        });
        mJPanel5.add((Component)mJButton2);
        this.getContentPane().add((Component)mJPanel5, "South");
        this.pack();
    }

    public static void insertToCommandWindow(String string) {
        CmdWinDocument cmdWinDocument = CmdWinDocument.getInstance();
        try {
            cmdWinDocument.insertString(cmdWinDocument.getLength(), string, null);
            MatlabDesktopServices.showCommandWindow();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    static boolean isTargetAmbiguous() {
        return !MLEditorServices.getEditorApplication().getOpenEditors().isEmpty();
    }

    void build(String string) {
        this.fFunctionName = string;
        this.fEditorCombo.removeAllItems();
        if (MLEditorServices.getEditorApplication().getOpenEditors().isEmpty()) {
            this.fCmdLineRadio.setSelected(true);
            this.fEditorCombo.setEnabled(false);
            return;
        }
        Editor editor = MLEditorServices.getEditorApplication().getActiveEditor();
        for (Editor editor2 : MLEditorServices.getEditorApplication().getOpenEditors()) {
            this.fEditorCombo.addItem((Object)editor2);
        }
        this.fEditorCombo.setSelectedItem((Object)(editor == null ? null : editor.getLongName()));
    }

    private void setFilePathToolTip() {
        this.fEditorCombo.setToolTipText(this.fEditorCombo.getSelectedItem().toString());
    }

    private static String stripPath(String string) {
        int n = string.lastIndexOf(FILESEP);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    class EditorComboRenderer
    extends BasicComboBoxRenderer {
        EditorComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Editor editor = (Editor)object;
            super.getListCellRendererComponent((JList<?>)jList, editor.getShortName(), n, bl, bl2);
            this.setToolTipText(editor.getLongName());
            return this;
        }
    }
}

