/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.ClassicHelpBrowserHandler;
import com.mathworks.mde.help.DocCommandHelpBrowserTask;
import com.mathworks.mde.help.HelpBrowserHandler;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mde.help.MLHelpBrowserTask;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import javax.swing.SwingUtilities;

public class DocCenterBrowserHandler
implements HelpBrowserHandler {
    private HelpBrowserHandler fClassicHelpBrowserHandler = new ClassicHelpBrowserHandler();

    public void doHelpBrowserTask(MLHelpBrowserTask mLHelpBrowserTask, boolean bl) {
        MLHelpBrowserRunnable mLHelpBrowserRunnable = new MLHelpBrowserRunnable(mLHelpBrowserTask, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            mLHelpBrowserRunnable.run();
        } else {
            SwingUtilities.invokeLater(mLHelpBrowserRunnable);
        }
    }

    @Override
    public void invoke() {
        this.doHelpBrowserTask(null, true);
    }

    @Override
    public void setCurrentLocation(String string) {
        this.doHelpBrowserTask(new UrlOnlyTask(string), false);
    }

    @Override
    public void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray) {
        this.setCurrentLocation(string);
    }

    @Override
    public void openInNewBrowser(String string) {
        this.doHelpBrowserTask(new UrlOnlyTask(string), true);
    }

    @Override
    public void showHelpPage(String string, String string2) {
        this.fClassicHelpBrowserHandler.showHelpPage(string, string2);
    }

    @Override
    public void showHelpPageAndHighlightKeywords(String string, String string2, String[] stringArray) {
        this.fClassicHelpBrowserHandler.showHelpPageAndHighlightKeywords(string, string2, stringArray);
    }

    @Override
    public boolean showProductPage(String string) {
        return this.showHelpPageIfAvailable(string, "index.html");
    }

    private boolean showHelpPageIfAvailable(String string, String string2) {
        DocProduct docProduct;
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
        if (documentationSet != null && (docProduct = documentationSet.getProductByIndexString(string)) != null) {
            String string3 = HelpPrefs.getDocCenterRoot();
            String string4 = HelpBrowserUtils.buildDocumentationPath((String)string3, (DocProduct)docProduct, (String)string2);
            this.setCurrentLocation(string4);
            return true;
        }
        return false;
    }

    @Override
    public boolean showReferencePage(String string, boolean bl) {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        DocCommandHelpBrowserTask docCommandHelpBrowserTask = new DocCommandHelpBrowserTask((SearchHelper)docCenterSearchHelper, HelpPrefs.getDocCenterRoot());
        if (docCommandHelpBrowserTask.findReferencePages(string, bl)) {
            this.doHelpBrowserTask(docCommandHelpBrowserTask, false);
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentLocation() {
        MLHelpBrowser mLHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
        return mLHelpBrowser != null ? mLHelpBrowser.getCurrentLocation() : null;
    }

    @Override
    public void setHtmlText(String string) {
        this.fClassicHelpBrowserHandler.setHtmlText(string);
    }

    @Override
    public void setHtmlTextAndHighlightKeywords(String string, String[] stringArray) {
        this.fClassicHelpBrowserHandler.setHtmlTextAndHighlightKeywords(string, stringArray);
    }

    @Override
    public String getHtmlText() {
        return this.fClassicHelpBrowserHandler.getHtmlText();
    }

    @Override
    public void setDemoText(String string) {
        this.fClassicHelpBrowserHandler.setDemoText(string);
    }

    @Override
    public void docSearch(String string) {
        this.docSearch(string, null);
    }

    @Override
    public void docSearch(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            this.invoke();
            return;
        }
        String string2 = DocCenterUtils.buildDocCenterSearchUrl((String)string, (String[])stringArray);
        this.setCurrentLocation(string2);
    }

    @Override
    public void showDemos() {
        this.showDemos("", "");
    }

    @Override
    public void showDemos(String string) {
        this.showDemos(string, "");
    }

    @Override
    public void showDemos(String string, String string2) {
        String string3 = DocCenterUtils.getExamplesUrlForDemoCommand((String)string, (String)string2);
        if (string3 == null) {
            this.showClassicOrShowError(string, string2);
        } else {
            this.setCurrentLocation(string3);
        }
    }

    private void showClassicOrShowError(final String string, final String string2) {
        DemosDataListener demosDataListener = new DemosDataListener(){

            public void demosCleared() {
            }

            public void demosPopulated() {
                DemoTreeItem demoTreeItem = DemosData.findProduct((String)string, (String)string2);
                if (demoTreeItem != null) {
                    DocCenterBrowserHandler.this.fClassicHelpBrowserHandler.showDemos(string, string2);
                } else {
                    String string3 = Matlab.matlabRoot() + "/toolbox/matlab/demos/html/nodemo.html";
                    String string22 = DemoInfoUtils.getLocalizedDemoFilename((String)string3);
                    DocCenterBrowserHandler.this.setCurrentLocation(string22);
                }
                DemosData.removeDemosDataListener((DemosDataListener)this);
            }
        };
        DemosData.addDemosDataListener((DemosDataListener)demosDataListener, (boolean)true);
    }

    @Override
    public void displayTopic(String string, String string2) {
        CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
        if (cSHelpTopicMap.exists()) {
            String string3 = cSHelpTopicMap.mapID(string2);
            if (string3 != null) {
                this.setCurrentLocation(string3);
            } else {
                this.setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
            }
        } else {
            this.setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
        }
    }

    static class UrlOnlyTask
    implements MLHelpBrowserTask {
        private final String iUrl;

        private UrlOnlyTask(String string) {
            this.iUrl = string;
        }

        @Override
        public String getUrlToDisplay() {
            return this.iUrl;
        }

        @Override
        public void updateHelpBrowser(MLHelpBrowser mLHelpBrowser) {
        }

        @Override
        public void cleanup() {
        }
    }

    private class MLHelpBrowserRunnable
    implements Runnable {
        private final MLHelpBrowserTask iTask;
        private final boolean iCreateNewBrowser;

        private MLHelpBrowserRunnable(MLHelpBrowserTask mLHelpBrowserTask, boolean bl) {
            this.iTask = mLHelpBrowserTask;
            this.iCreateNewBrowser = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MLHelpBrowser mLHelpBrowser = this.createHelpBrowser();
            if (this.iTask != null) {
                try {
                    this.iTask.updateHelpBrowser(mLHelpBrowser);
                }
                finally {
                    this.iTask.cleanup();
                }
            }
        }

        private MLHelpBrowser createHelpBrowser() {
            String string;
            MLHelpBrowser mLHelpBrowser = null;
            boolean bl = this.iCreateNewBrowser;
            String string2 = string = this.iTask == null ? null : this.iTask.getUrlToDisplay();
            if (string != null) {
                string = DocCenterUtils.buildDocCenterUrl((String)string);
            }
            if (!bl) {
                String string3;
                mLHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
                if (mLHelpBrowser == null) {
                    bl = true;
                } else if (!(string == null || (string3 = mLHelpBrowser.getCurrentLocation()) != null && HelpBrowserUtils.compareUrlDocLocation((String)string, (String)string3))) {
                    bl = true;
                }
            }
            if (bl) {
                mLHelpBrowser = new MLHelpBrowser();
                if (string != null) {
                    mLHelpBrowser.showClient(string);
                } else {
                    mLHelpBrowser.showClient();
                }
            } else if (string != null) {
                mLHelpBrowser.setCurrentLocation(string);
            }
            return mLHelpBrowser;
        }
    }
}

