/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.ResultsGroup;
import com.mathworks.mde.help.search.SearchPanelActionFactory;
import com.mathworks.mde.help.search.SearchResultsContainer;
import com.mathworks.mde.help.search.SearchResultsDisplay;
import com.mathworks.mde.help.search.SingleGroupDisplay;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mwswing.MJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class SearchResultsGroupDisplay
implements SearchResultsDisplay {
    private MJPanel fPanel;
    private final SearchResultsContainer fContainer;
    private final SearchCriteria fCriteria;
    private final HelpPageDisplayHandler fHandler;
    private List<SingleGroupDisplay> fAllLists = new ArrayList<SingleGroupDisplay>();
    private SingleGroupDisplay fSelectedGroup;

    public SearchResultsGroupDisplay(SearchCriteria searchCriteria, SearchResultsContainer searchResultsContainer, HelpPageDisplayHandler helpPageDisplayHandler) {
        this.fPanel = new MJPanel();
        this.fPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fPanel, 1));
        this.fPanel.setFocusable(true);
        this.fContainer = searchResultsContainer;
        this.fCriteria = searchCriteria;
        this.fHandler = helpPageDisplayHandler;
        this.fPanel.setName("SearchResultsGroupedList");
        this.addGroupDisplays();
        this.addListeners();
    }

    private void addListeners() {
        this.fPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SingleGroupDisplay singleGroupDisplay = SearchResultsGroupDisplay.this.getSelectedGroup();
                if (singleGroupDisplay != null) {
                    singleGroupDisplay.handleFocusGained();
                }
                SearchResultsGroupDisplay.this.fPanel.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SingleGroupDisplay singleGroupDisplay = SearchResultsGroupDisplay.this.getSelectedGroup();
                if (singleGroupDisplay != null) {
                    singleGroupDisplay.handleFocusLost();
                }
                SearchResultsGroupDisplay.this.fPanel.repaint();
            }
        });
        this.fPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.handleKeyEvent(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.handleKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.handleKeyEvent(keyEvent);
            }

            private void handleKeyEvent(KeyEvent keyEvent) {
                SingleGroupDisplay singleGroupDisplay = SearchResultsGroupDisplay.this.getSelectedGroup();
                if (singleGroupDisplay != null) {
                    singleGroupDisplay.handleKeyEvent(keyEvent);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchResultsGroupDisplay.this.fPanel.requestFocusInWindow();
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    @Override
    public int getNumResults() {
        return this.fContainer.getSize();
    }

    @Override
    public void afterReversal() {
        this.fPanel.setFocusCycleRoot(true);
        this.fPanel.removeAll();
        this.reverseGroups();
    }

    private void reverseGroups() {
        this.fPanel.invalidate();
        Collections.reverse(this.fAllLists);
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            this.fPanel.add((Component)singleGroupDisplay.getComponent());
        }
        this.fPanel.add(Box.createVerticalGlue());
        this.fPanel.setFocusCycleRoot(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchResultsGroupDisplay.this.fPanel.revalidate();
                SearchResultsGroupDisplay.this.fPanel.repaint();
            }
        });
    }

    @Override
    public SearchPanelActionFactory getActionFactory() {
        return new GroupDisplayActionFactory();
    }

    private boolean isAnyPanelExpanded() {
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            if (!singleGroupDisplay.isExpanded()) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyPanelCollapsed() {
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            if (singleGroupDisplay.isExpanded()) continue;
            return true;
        }
        return false;
    }

    private void addGroupDisplays() {
        for (ResultsGroup resultsGroup : this.fContainer.getGroups()) {
            SingleGroupDisplay singleGroupDisplay = new SingleGroupDisplay(this.fCriteria, resultsGroup, this.fHandler, this);
            JComponent jComponent = singleGroupDisplay.getComponent();
            this.fPanel.add((Component)jComponent);
            this.addList(singleGroupDisplay);
        }
        this.setBackground(this.fPanel.getBackground());
        this.setForeground(this.fPanel.getForeground());
        this.setFont(this.fPanel.getFont());
        this.fPanel.add(Box.createVerticalGlue());
    }

    @Override
    public void scrollToSelectedResult() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SingleGroupDisplay singleGroupDisplay = SearchResultsGroupDisplay.this.getSelectedGroup();
                if (singleGroupDisplay == null) {
                    return;
                }
                int n = SearchResultsGroupDisplay.this.getHeightAboveGroup(SearchResultsGroupDisplay.this.getSelectedGroup());
                Rectangle rectangle = singleGroupDisplay.getSelectedResultRectangle();
                if (rectangle != null) {
                    int n2 = n + rectangle.y;
                    int n3 = n2 + rectangle.height;
                    SearchResultsGroupDisplay.this.scrollToPosition(n2, n3);
                }
            }
        });
    }

    void scrollToGroupHeader(SingleGroupDisplay singleGroupDisplay) {
        int n = this.getHeightAboveGroup(singleGroupDisplay);
        Rectangle rectangle = singleGroupDisplay.getHeaderRectangle();
        if (rectangle != null) {
            int n2 = n + rectangle.height;
            this.scrollToPosition(n, n2);
        }
    }

    void scrollToGroup(SingleGroupDisplay singleGroupDisplay) {
        int n = this.getHeightAboveGroup(singleGroupDisplay);
        int n2 = singleGroupDisplay.getComponent().getPreferredSize().height;
        this.scrollToPosition(n, n + n2);
    }

    private int getHeightAboveGroup(SingleGroupDisplay singleGroupDisplay) {
        List<SingleGroupDisplay> list = this.getDisplays();
        int n = 0;
        for (SingleGroupDisplay singleGroupDisplay2 : list) {
            if (singleGroupDisplay2.equals(singleGroupDisplay)) break;
            n += singleGroupDisplay2.getPreferredHeight();
        }
        return n;
    }

    private void scrollToPosition(int n, int n2) {
        JViewport jViewport = this.getViewportAncestor();
        if (jViewport != null) {
            Rectangle rectangle = jViewport.getViewRect();
            if (n < rectangle.y) {
                jViewport.setViewPosition(new Point(0, n));
            } else if (n2 > rectangle.y + rectangle.height) {
                if (n2 - n > rectangle.height) {
                    jViewport.setViewPosition(new Point(0, n));
                } else {
                    jViewport.setViewPosition(new Point(0, n2 - rectangle.height));
                }
            }
        }
    }

    private JViewport getViewportAncestor() {
        Container container;
        for (container = this.fPanel.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        return (JViewport)container;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.fPanel.requestFocusInWindow();
    }

    void addList(SingleGroupDisplay singleGroupDisplay) {
        this.fAllLists.add(singleGroupDisplay);
    }

    @Override
    public HelpBrowserSearchResult getSelectedResult() {
        SingleGroupDisplay singleGroupDisplay = this.getSelectedGroup();
        if (singleGroupDisplay != null) {
            return singleGroupDisplay.getSelectedValue();
        }
        return null;
    }

    @Override
    public void selectResult(int n) {
        int n2 = 0;
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            if (n < n2 + singleGroupDisplay.getNumResults()) {
                singleGroupDisplay.setSelectedIndex(n - n2);
                return;
            }
            n2 += singleGroupDisplay.getNumResults();
        }
    }

    void clearSelection() {
        SingleGroupDisplay singleGroupDisplay = this.getSelectedGroup();
        if (singleGroupDisplay != null) {
            singleGroupDisplay.clearSelection();
        }
    }

    void jumpToNextGroup() {
        SingleGroupDisplay singleGroupDisplay = this.getSelectedGroup();
        int n = this.fAllLists.indexOf(singleGroupDisplay);
        if (n > -1 && n + 1 < this.fAllLists.size()) {
            SingleGroupDisplay singleGroupDisplay2 = this.fAllLists.get(n + 1);
            singleGroupDisplay.clearSelection();
            singleGroupDisplay2.selectHeader();
        }
    }

    void jumpToPreviousGroup() {
        SingleGroupDisplay singleGroupDisplay = this.getSelectedGroup();
        int n = this.fAllLists.indexOf(singleGroupDisplay);
        if (n > 0) {
            SingleGroupDisplay singleGroupDisplay2 = this.fAllLists.get(n - 1);
            singleGroupDisplay.clearSelection();
            if (singleGroupDisplay2.isExpanded()) {
                singleGroupDisplay2.selectResult(singleGroupDisplay2.getNumResults() - 1);
            } else {
                singleGroupDisplay2.selectHeader();
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        this.fPanel.setForeground(color);
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            singleGroupDisplay.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        this.fPanel.setBackground(color);
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            singleGroupDisplay.setBackground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        this.fPanel.setFont(font);
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            singleGroupDisplay.setFont(font);
        }
    }

    void collapseAll() {
        for (int i = this.fAllLists.size(); i > 0; --i) {
            this.fAllLists.get(i - 1).collapse();
        }
    }

    void expandAll() {
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            singleGroupDisplay.expand(false);
        }
        SingleGroupDisplay singleGroupDisplay = this.getSelectedGroup();
        if (singleGroupDisplay != null) {
            this.scrollToGroup(singleGroupDisplay);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.fPanel.addMouseListener(mouseListener);
        for (SingleGroupDisplay singleGroupDisplay : this.fAllLists) {
            singleGroupDisplay.addGlobalMouseListener(mouseListener);
        }
    }

    SingleGroupDisplay getSelectedGroup() {
        return this.fSelectedGroup;
    }

    void setSelectedGroup(SingleGroupDisplay singleGroupDisplay) {
        if (this.fSelectedGroup != null && !this.fSelectedGroup.equals(singleGroupDisplay)) {
            this.fSelectedGroup.clearSelection();
        }
        this.fSelectedGroup = singleGroupDisplay;
    }

    SingleGroupDisplay getDisplay(int n) {
        return this.fAllLists.get(n);
    }

    List<SingleGroupDisplay> getDisplays() {
        return new ArrayList<SingleGroupDisplay>(this.fAllLists);
    }

    private class GroupDisplayActionFactory
    extends SearchPanelActionFactory {
        private GroupDisplayActionFactory() {
            super(SearchResultsGroupDisplay.this);
        }

        @Override
        protected Action getExpandAllAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SearchResultsGroupDisplay.this.expandAll();
                }

                @Override
                public boolean isEnabled() {
                    return SearchResultsGroupDisplay.this.isAnyPanelCollapsed() && super.isEnabled();
                }
            };
        }

        @Override
        protected Action getCollapseAllAction() {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SearchResultsGroupDisplay.this.collapseAll();
                }

                @Override
                public boolean isEnabled() {
                    return SearchResultsGroupDisplay.this.isAnyPanelExpanded() && super.isEnabled();
                }
            };
        }
    }
}

