/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.inspector;

import com.mathworks.common.icons.ControlIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.PropertyViewUtils;
import com.mathworks.mwswing.MJLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SelectedBeanDisplay
extends MJLabel {
    private static final String NO_OBJECTS = PropertyViewUtils.getResource((String)"status.NoObjects");
    private static final int UIC_PUSHB = 0;
    private static final int UIC_SLIDER = 1;
    private static final int UIC_RADIOB = 2;
    private static final int UIC_CHECKB = 3;
    private static final int UIC_EDIT = 4;
    private static final int UIC_STATIC = 5;
    private static final int UIC_FRAME = 6;
    private static final int UIC_POPUP = 7;
    private static final int UIC_LISTB = 8;
    private static final int UIC_TOGGLEB = 9;
    private static final int UIC_CONTAINER = 10;
    private static final int UIC_PANEL = 11;
    private static final int UIC_BUTTONGROUP = 12;
    private static final int UNKNOWN = 13;
    private static final int MULTIPLE = 14;
    private static final int NUM_ICONS = 15;
    private static Icon[] sIcons;

    public SelectedBeanDisplay(JComponent jComponent) {
        this.initIcons();
        this.setLayout(new FlowLayout());
        this.setText(NO_OBJECTS);
        this.setIcon(null);
        this.setName("ObjectLabel");
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        Font font = jComponent.getFont();
        Font font2 = font.deriveFont((float)InspectorUIResources.getMenuBarFontSize());
        this.setFont(font2);
    }

    void updateNameAndLabel_AnyThread(final Object[] objectArray) {
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                SelectedBeanDisplay.this.updateNameAndLabel_MatlabThread(objectArray);
            }
        });
    }

    void updateNameAndLabel_MatlabThread(Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        Icon icon = null;
        String string = null;
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray.length == 1) {
                if (objectArray[0] == null) {
                    string = PropertyViewUtils.getResource((String)"status.Null");
                    icon = null;
                } else {
                    string = SelectedBeanDisplay.getBeanName_MatlabThread(objectArray[0]);
                    icon = this.getIcon_MatlabThread(objectArray[0]);
                }
            } else {
                string = PropertyViewUtils.getResource((String)"status.MultipleObjects");
                icon = sIcons[14];
            }
        } else {
            string = PropertyViewUtils.getResource((String)"status.NoObjects");
            icon = null;
        }
        final String string2 = string;
        final Icon icon2 = icon;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectedBeanDisplay.this.updateNameAndIconMenuBar_EventThread(string2, icon2);
            }
        });
    }

    private void updateNameAndIconMenuBar_EventThread(String string, Icon icon) {
        assert (SwingUtilities.isEventDispatchThread());
        this.setIcon(icon);
        if (string != null) {
            this.setText(string);
        }
    }

    private static Object getPropertyValue(UDDObject uDDObject, String string) {
        String string2 = null;
        try {
            string2 = (String)uDDObject.getPropertyValue(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return string2;
    }

    public static String getLabel_MatlabThread(Object[] objectArray) {
        String string = objectArray != null && objectArray.length > 0 ? (objectArray.length == 1 ? (objectArray[0] == null ? PropertyViewUtils.getResource((String)"status.Null") : SelectedBeanDisplay.getBeanName_MatlabThread(objectArray[0])) : PropertyViewUtils.getResource((String)"status.MultipleObjects")) : PropertyViewUtils.getResource((String)"status.NoObjects");
        return string;
    }

    public static String getBeanName_MatlabThread(Object object) {
        UDDObject uDDObject;
        BeanInfo beanInfo = null;
        String string = null;
        String string2 = null;
        assert (NativeMatlab.nativeIsMatlabThread());
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanInfo != null) {
            uDDObject = beanInfo.getMethodDescriptors();
            for (int i = 0; i < ((MethodDescriptor[])uDDObject).length; ++i) {
                if (!uDDObject[i].getMethod().getName().equals("getInspectorToolbarObjectName")) continue;
                Method method = uDDObject[i].getMethod();
                Object[] objectArray = new Object[]{};
                try {
                    string = (String)method.invoke(object, objectArray);
                }
                catch (Exception exception) {}
                break;
            }
            if (string == null) {
                string = beanInfo.getBeanDescriptor().getDisplayName();
            }
        } else {
            string = object.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if (object instanceof Component) {
            string2 = ((Component)object).getName();
        } else if (object instanceof UDDObject) {
            uDDObject = (UDDObject)object;
            if (string.equals("uicontrol")) {
                String[] stringArray;
                try {
                    stringArray = (String[])uDDObject.getPropertyValue("String");
                }
                catch (RuntimeException runtimeException) {
                    return NO_OBJECTS;
                }
                string2 = stringArray != null && stringArray.length > 0 ? stringArray[0] : "";
                try {
                    string2 = (String)uDDObject.getPropertyValue("Tag") + " \"" + string2 + "\"";
                }
                catch (RuntimeException runtimeException) {
                    return NO_OBJECTS;
                }
            }
            if (string.equals("uipanel") || string.equals("uitools.uibuttongroup")) {
                String[] stringArray;
                try {
                    stringArray = (String[])uDDObject.getPropertyValue("Title");
                }
                catch (RuntimeException runtimeException) {
                    return NO_OBJECTS;
                }
                string2 = stringArray != null && stringArray.length > 0 ? stringArray[0] : "";
                try {
                    string2 = (String)uDDObject.getPropertyValue("Tag") + " \"" + string2 + "\"";
                }
                catch (RuntimeException runtimeException) {
                    string2 = NO_OBJECTS;
                }
            } else if (string.equals("uicontainer")) {
                string2 = (String)SelectedBeanDisplay.getPropertyValue(uDDObject, "Tag");
            } else if (string.equals("uimenu")) {
                string2 = (String)SelectedBeanDisplay.getPropertyValue(uDDObject, "Label");
            } else if (string.equals("uicontextmenu")) {
                string2 = (String)SelectedBeanDisplay.getPropertyValue(uDDObject, "Tag");
            } else if (string.equals("axes")) {
                string2 = (String)SelectedBeanDisplay.getPropertyValue(uDDObject, "Tag");
            } else if (string.equals("figure")) {
                string2 = (String)SelectedBeanDisplay.getPropertyValue(uDDObject, "Name");
            } else if (string.equals("uitoolbar")) {
                string2 = (String)uDDObject.getPropertyValue("Tag");
            } else if (string.equals("uipushtool") || string.equals("uitoggletool")) {
                string2 = (String)uDDObject.getPropertyValue("Tag") + " \"" + (String)uDDObject.getPropertyValue("TooltipString") + "\"";
            }
        }
        if (string2 != null && string2.length() > 0) {
            string = string + " (" + string2 + ")";
        }
        return string;
    }

    private Icon getIcon_MatlabThread(Object object) {
        BeanInfo beanInfo = null;
        Icon icon = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanInfo != null) {
            Object object2;
            if (object instanceof UDDObject) {
                object2 = (UDDObject)object;
                String string = beanInfo.getBeanDescriptor().getDisplayName();
                if (string.equals("uicontrol")) {
                    try {
                        int n = (Integer)object2.getPropertyValue("Style");
                        icon = sIcons[n];
                    }
                    catch (RuntimeException runtimeException) {}
                } else if (string.equals("uipanel")) {
                    icon = sIcons[11];
                } else if (string.equals("uitools.uibuttongroup")) {
                    icon = sIcons[12];
                } else if (string.equals("uicontainer")) {
                    icon = sIcons[10];
                }
            }
            if (icon == null && (object2 = beanInfo.getIcon(1)) != null) {
                icon = new ImageIcon((Image)object2);
            }
        }
        if (icon == null) {
            icon = sIcons[13];
        }
        assert (icon != null);
        return icon;
    }

    private Icon makeIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = ((Object)((Object)this)).getClass().getResource(string);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        assert (imageIcon != null);
        return imageIcon;
    }

    public void initIcons() {
        if (sIcons == null) {
            sIcons = new Icon[15];
            SelectedBeanDisplay.sIcons[13] = ControlIcon.UNKNOWN.getIcon();
            SelectedBeanDisplay.sIcons[14] = ControlIcon.MULTIPLE_CONTROLS.getIcon();
            SelectedBeanDisplay.sIcons[0] = ControlIcon.PUSHBUTTON.getIcon();
            SelectedBeanDisplay.sIcons[1] = ControlIcon.SCROLLBAR.getIcon();
            SelectedBeanDisplay.sIcons[2] = ControlIcon.RADIOBUTTON.getIcon();
            SelectedBeanDisplay.sIcons[3] = ControlIcon.CHECKBOX.getIcon();
            SelectedBeanDisplay.sIcons[4] = ControlIcon.TEXTEDIT.getIcon();
            SelectedBeanDisplay.sIcons[5] = ControlIcon.LABEL.getIcon();
            SelectedBeanDisplay.sIcons[6] = ControlIcon.FRAME.getIcon();
            SelectedBeanDisplay.sIcons[7] = ControlIcon.COMBOBOX.getIcon();
            SelectedBeanDisplay.sIcons[8] = ControlIcon.LISTBOX.getIcon();
            SelectedBeanDisplay.sIcons[9] = ControlIcon.TOGGLEBUTTON.getIcon();
            SelectedBeanDisplay.sIcons[10] = ControlIcon.CONTAINER.getIcon();
            SelectedBeanDisplay.sIcons[11] = ControlIcon.PANEL.getIcon();
            SelectedBeanDisplay.sIcons[12] = ControlIcon.BUTTONGROUP.getIcon();
        }
    }
}

