/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.mathworks.install.AvailableProduct;
import com.mathworks.install.AvailableProductImpl;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentContainerImpl;
import com.mathworks.install.ComponentSizeAggregator;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallableProductComparator;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.Installer;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.install.Product;
import com.mathworks.install.ProductComparator;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductContainerImpl;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class InstallerImpl
implements Installer {
    private static final String WIN32 = "win32";
    private static final String WIN64 = "win64";
    private final String arch;
    private final IO io;
    private final AppLogger appLogger;
    private final Map<AvailableProduct, InstallableProduct> availableProductMap = new LinkedHashMap<AvailableProduct, InstallableProduct>();
    private final Map<File, ProductContainer> productContainerMap = new HashMap<File, ProductContainer>();
    private final Map<File, ComponentContainer> componentContainerMap = new HashMap<File, ComponentContainer>();
    private final ProductInstaller[] productInstallers;
    private final InstallOptionProvider installOptionProvider;
    private final InstalledProductData fileList;
    private final InstalledProductDataFactory fileListFactory;
    private final ProductContainer theProductContainer;
    private InstallOption[] installOptions;
    private final Collection<InstallableProduct> nonCustomerFacingProducts = new ArrayList<InstallableProduct>();

    @Inject
    InstallerImpl(String string, InstallableProduct[] installableProductArray, InstallOptionProvider installOptionProvider, InstalledProductData installedProductData, InstalledProductDataFactory installedProductDataFactory, ProductContainer productContainer, IO iO, AppLogger appLogger, ProductInstaller ... productInstallerArray) {
        InstallableProduct[] installableProductArray2;
        this.arch = string;
        this.fileListFactory = installedProductDataFactory;
        this.theProductContainer = productContainer;
        this.io = iO;
        this.appLogger = appLogger;
        for (InstallableProduct installableProduct : installableProductArray2 = (InstallableProduct[])installableProductArray.clone()) {
            this.addProduct(installableProduct.getProductData());
        }
        this.installOptionProvider = installOptionProvider;
        this.fileList = installedProductData;
        this.productInstallers = (ProductInstaller[])productInstallerArray.clone();
        this.installOptions = this.getInstallOptionsForCurrentProductSelection(new Product[0]);
    }

    @Override
    public void addProduct(Product product) {
        InstallableProduct installableProduct = this.theProductContainer.getInstallableProduct(product);
        if (installableProduct.getReleaseFamily().equalsIgnoreCase(InstutilResourceKeys.RELEASE.getString(new Object[0]))) {
            if (installableProduct.isCustomerFacing()) {
                this.availableProductMap.put(new AvailableProductImpl(installableProduct), installableProduct);
            } else {
                this.nonCustomerFacingProducts.add(installableProduct);
            }
        } else {
            this.appLogger.logMsg("Found unsupported release " + installableProduct.getReleaseFamily() + " for product: " + installableProduct.getProductData().getNameAndVersion());
        }
    }

    @Override
    public void install(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallableProduct[] installableProductArray = this.getAllProductsToBeOverwritten(file);
        this.uninstallProducts(file, installFlowControlHandler, installableProductArray, this.getOptionsToBeUninstalled(file), installStatusObserverArray);
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeInstalled();
        for (ProductInstaller object : this.productInstallers) {
            object.installProducts(this.arch, file, installableProductArray2, this.installOptions, installFlowControlHandler, this.getComponentContainer(file), installStatusObserverArray);
        }
        this.fileList.writeContentsData(file, this.getAvailableProducts());
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.finished();
        }
    }

    private void uninstallProducts(File file, InstallFlowControlHandler installFlowControlHandler, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (InstallerImpl.productsToBeUninstalled(installableProductArray)) {
            for (ProductInstaller productInstaller : this.productInstallers) {
                productInstaller.uninstallProducts(this.arch, file, installableProductArray, installOptionArray, installFlowControlHandler, this.getInstalledProductContainer(file), this.getComponentContainer(file), installStatusObserverArray);
            }
            this.fileList.writeContentsData(file, this.getAvailableProducts());
        }
    }

    @Override
    public void uninstall(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        List<InstallableProduct> list = Arrays.asList(this.getSelectedCustomerFacingProducts());
        Collections.reverse(list);
        this.uninstallProducts(file, installFlowControlHandler, list.toArray(new InstallableProduct[list.size()]), this.installOptions, installStatusObserverArray);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.finished();
        }
    }

    @Override
    public Product[] getDependencies() {
        HashSet<Product> hashSet = new HashSet<Product>();
        for (InstallableProduct installableProduct : this.getSelectedCustomerFacingProducts()) {
            hashSet.addAll(Arrays.asList(installableProduct.getRequiredProducts()));
        }
        return hashSet.toArray(new Product[hashSet.size()]);
    }

    @Override
    public Product[] getDependencySatisfiers(File file) {
        HashSet<Product> hashSet = new HashSet<Product>();
        hashSet.addAll(Arrays.asList(InstallerImpl.getProducts(this.getInstalledCustomerFacingProducts(file))));
        hashSet.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        return hashSet.toArray(new Product[hashSet.size()]);
    }

    @Override
    public Product[] getProductsThatDependOnProductsToBeUninstalled(File file) {
        HashSet<Product> hashSet = new HashSet<Product>();
        InstallableProduct[] installableProductArray = this.getInstalledCustomerFacingProducts(file);
        Map<Product, InstallableProduct> map = InstallerImpl.getProductToInstallableProductMap(installableProductArray);
        List<InstallableProduct> list = Arrays.asList(this.getCustomerFacingProductsToBeRemoved(file));
        for (InstallableProduct installableProduct : installableProductArray) {
            if (list.contains(installableProduct)) continue;
            for (Product product : installableProduct.getRequiredProducts()) {
                if (!list.contains(map.get(product))) continue;
                hashSet.add(installableProduct.getProductData());
            }
        }
        Object[] objectArray = hashSet.toArray(new Product[hashSet.size()]);
        Arrays.sort(objectArray, new ProductComparator());
        return objectArray;
    }

    @Override
    public long getBytesRequired(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        ComponentSizeAggregator componentSizeAggregator = this.calculateSpaceRequired(this.getAllProductsToBeInstalled(), file);
        return componentSizeAggregator.getTotalSize();
    }

    private ComponentSizeAggregator calculateSpaceRequired(InstallableProduct[] installableProductArray, File file) {
        ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeOverwritten(file);
        for (ProductInstaller productInstaller : this.productInstallers) {
            productInstaller.calculateSpaceRequired(this.arch, file, installableProductArray, installableProductArray2, this.getInstalledProductContainer(file), this.getComponentContainer(file), componentSizeAggregator);
        }
        return componentSizeAggregator;
    }

    @Override
    public long getDownloadSize(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        return this.calculateSpaceRequired(this.getAllProductsToBeInstalled(), file).getTotalDownloadSize();
    }

    @Override
    public long getUninstallTotalUnits(File file) {
        return this.getUninstallTotalUnits(file, this.getCustomerFacingProductsToBeRemoved(file), this.installOptions);
    }

    private long getUninstallTotalUnits(File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray) {
        long l = 0L;
        if (InstallerImpl.productsToBeUninstalled(installableProductArray)) {
            for (ProductInstaller productInstaller : this.productInstallers) {
                l += productInstaller.getUninstallUnits(this.arch, file, installableProductArray, installOptionArray, this.getInstalledProductContainer(file), this.getComponentContainer(file));
            }
        }
        return l;
    }

    private static boolean productsToBeUninstalled(InstallableProduct[] installableProductArray) {
        return installableProductArray.length > 0;
    }

    @Override
    public long getInstallTotalUnits(File file) {
        long l = 0L;
        InstallableProduct[] installableProductArray = this.getAllProductsToBeInstalled();
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeOverwritten(file);
        for (ProductInstaller productInstaller : this.productInstallers) {
            l += productInstaller.getInstallUnits(this.arch, file, installableProductArray, installableProductArray2, this.installOptions, this.getInstalledProductContainer(file), this.getComponentContainer(file));
        }
        return l + this.getUninstallTotalUnits(file, installableProductArray2, this.getOptionsToBeUninstalled(file));
    }

    private InstallOption[] getOptionsToBeUninstalled(File file) {
        return this.installOptionProvider.getUninstallOptions(InstallerImpl.getProducts(this.getCustomerFacingProductsToBeRemoved(file)));
    }

    @Override
    public InstallOption getDefaultPreferencesOption() {
        return this.installOptionProvider.getDefaultPreferencesOption();
    }

    @Override
    public void setUninstallOptions(InstallOption ... installOptionArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        ArrayList<InstallOption> arrayList2 = new ArrayList<InstallOption>();
        arrayList.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        arrayList2.addAll(Arrays.asList(this.installOptionProvider.getUninstallOptions(arrayList.toArray(new Product[arrayList.size()]))));
        for (InstallOption installOption : installOptionArray) {
            if (!this.isAnyControllingProductSelected() || !installOption.isSelected()) continue;
            arrayList2.add(installOption);
        }
        this.installOptions = arrayList2.toArray(new InstallOption[arrayList2.size()]);
    }

    @Override
    public AvailableProduct[] getAvailableProducts() {
        AvailableProduct[] availableProductArray = this.availableProductMap.keySet().toArray(new AvailableProduct[this.availableProductMap.size()]);
        Arrays.sort(availableProductArray, new ProductComparator());
        return availableProductArray;
    }

    private synchronized ProductContainer getInstalledProductContainer(File file) {
        if (this.productContainerMap.containsKey(file)) {
            return this.productContainerMap.get(file);
        }
        this.populateContainers(file);
        return this.productContainerMap.get(file);
    }

    private synchronized ComponentContainer getComponentContainer(File file) {
        if (this.componentContainerMap.containsKey(file)) {
            return this.componentContainerMap.get(file);
        }
        this.populateContainers(file);
        return this.componentContainerMap.get(file);
    }

    private synchronized void populateContainers(File file) {
        ComponentContainerImpl componentContainerImpl = new ComponentContainerImpl();
        ProductContainerImpl productContainerImpl = new ProductContainerImpl(componentContainerImpl);
        try {
            this.fileListFactory.createInstalledProductData(file, productContainerImpl, componentContainerImpl);
        }
        catch (Exception exception) {
            componentContainerImpl = new ComponentContainerImpl();
            productContainerImpl = new ProductContainerImpl(componentContainerImpl);
        }
        this.componentContainerMap.put(file, componentContainerImpl);
        this.productContainerMap.put(file, productContainerImpl);
    }

    @Override
    public void checkIfOverwritePossible(File file) throws InvalidInstallationFolderException {
        File file2 = new File(new File(file, "bin"), this.arch);
        if (this.appdataExists(file)) {
            this.validateFileList(file);
            if (this.fileListEmptyForThisArchitecture(file)) {
                this.checkWin32OnWin64(file);
                this.checkWin64OnWin32(file);
            }
        } else if (this.io.isDirectory(file2)) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_NO_FILE_LIST.getString(new Object[0]));
        }
    }

    private void validateFileList(File file) throws InvalidInstallationFolderException {
        this.fileListFactory.createInstalledProductDataVersion().validate(file, this.getAvailableProducts());
    }

    private boolean appdataExists(File file) {
        return this.io.isDirectory(new File(file, "appdata"));
    }

    private void checkWin64OnWin32(File file) throws InvalidInstallationFolderException {
        if (this.arch.equalsIgnoreCase(WIN64) && this.getAllInstalledProducts(file, WIN32).length > 0) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_WIN64_ON_WIN32.getString(new Object[0]));
        }
    }

    private void checkWin32OnWin64(File file) throws InvalidInstallationFolderException {
        if (this.arch.equalsIgnoreCase(WIN32) && this.getAllInstalledProducts(file, WIN64).length > 0) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_WIN32_ON_WIN64.getString(new Object[0]));
        }
    }

    private boolean fileListEmptyForThisArchitecture(File file) {
        return this.getAllInstalledProducts(file).length == 0;
    }

    @Override
    public AvailableProduct[] getSelectedProductsAlreadyInstalled(File file) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (InstallableProduct installableProduct : this.getInstalledCustomerFacingProducts(file)) {
            for (AvailableProduct availableProduct : this.getSelectedAvailableProducts()) {
                if (!InstallerImpl.productsMatch(installableProduct.getProductData(), availableProduct)) continue;
                arrayList.add(availableProduct);
            }
        }
        return arrayList.toArray(new AvailableProduct[arrayList.size()]);
    }

    private static boolean productsMatch(Product product, AvailableProduct availableProduct) {
        return InstallerImpl.matchesInstalledProduct(product, availableProduct.getProductNumber(), availableProduct.getVersion(), availableProduct.getArchitecture());
    }

    private static boolean matchesInstalledProduct(Product product, int n, String string, String string2) {
        return n == product.getProductNumber() && (VersionUtils.compareVersionNumbers((String)string, (String)product.getVersion()) != 0 || string2.equalsIgnoreCase(product.getArchitecture()));
    }

    private InstallableProduct[] getCustomerFacingProductsToBeRemoved(File file) {
        if (this.getIncompatibleProducts(file).length > 0) {
            return this.getInstalledCustomerFacingProducts(file);
        }
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getInstalledCustomerFacingProducts(file)) {
            for (AvailableProduct availableProduct : this.getSelectedAvailableProducts()) {
                if (!InstallerImpl.productsMatch(installableProduct.getProductData(), availableProduct)) continue;
                arrayList.add(installableProduct);
            }
        }
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    private InstallableProduct[] getAllProductsToBeOverwritten(File file) {
        if (this.getIncompatibleProducts(file).length > 0) {
            return this.getAllInstalledProducts(file);
        }
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            for (InstallableProduct installableProduct2 : this.getAllProductsToBeInstalled()) {
                if (!InstallerImpl.productsMatch(installableProduct.getProductData(), installableProduct2.getProductData())) continue;
                arrayList.add(installableProduct);
            }
        }
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    private static boolean productsMatch(Product product, Product product2) {
        return InstallerImpl.matchesInstalledProduct(product, product2.getProductNumber(), product2.getVersion(), product2.getArchitecture());
    }

    private InstallableProduct[] toInstallableProducts(AvailableProduct[] availableProductArray) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (AvailableProduct availableProduct : availableProductArray) {
            arrayList.add(this.availableProductMap.get(availableProduct));
        }
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    @Override
    public AvailableProduct[] getIncompatibleProducts(File file) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        AvailableProduct[] availableProductArray = this.getSelectedAvailableProducts();
        InstallableProduct[] installableProductArray = this.getAllInstalledProducts(file);
        for (AvailableProduct availableProduct : availableProductArray) {
            InstallableProduct installableProduct = this.availableProductMap.get(availableProduct);
            if (!installableProduct.getProductData().isControlling()) continue;
            for (InstallableProduct installableProduct2 : installableProductArray) {
                if (installableProduct.getReleaseFamily().equalsIgnoreCase(installableProduct2.getReleaseFamily())) continue;
                arrayList.add(availableProduct);
            }
        }
        return arrayList.toArray(new AvailableProduct[arrayList.size()]);
    }

    @Override
    public boolean folderContainsNewerVersion(AvailableProduct availableProduct, File file) {
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            Product product = installableProduct.getProductData();
            Product product2 = this.availableProductMap.get(availableProduct).getProductData();
            if (product.getProductNumber() != product2.getProductNumber() || VersionUtils.compareVersionNumbers((String)product.getVersion(), (String)product2.getVersion()) <= 0) continue;
            return true;
        }
        return false;
    }

    private InstallableProduct[] getInstalledCustomerFacingProducts(File file) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            if (!installableProduct.isCustomerFacing()) continue;
            arrayList.add(installableProduct);
        }
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    private InstallableProduct[] getAllInstalledProducts(File file) {
        InstallableProduct[] installableProductArray = this.getInstalledProductContainer(file).getInstallableProducts(this.arch);
        Arrays.sort(installableProductArray, new InstallableProductComparator());
        return installableProductArray;
    }

    private InstallableProduct[] getAllInstalledProducts(File file, String string) {
        InstallableProduct[] installableProductArray = this.getInstalledProductContainer(file).getInstallableProducts(string);
        Arrays.sort(installableProductArray, new InstallableProductComparator());
        return installableProductArray;
    }

    @Override
    public InstallOption[] getInstallOptionsForCurrentProductSelection(Product ... productArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        arrayList.addAll(Arrays.asList(productArray));
        arrayList.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        return this.getInstallOptions(arrayList.toArray(new Product[arrayList.size()]));
    }

    private static Product[] getProducts(InstallableProduct[] installableProductArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (InstallableProduct installableProduct : installableProductArray) {
            arrayList.add(installableProduct.getProductData());
        }
        return arrayList.toArray(new Product[arrayList.size()]);
    }

    private InstallOption[] getInstallOptions(Product[] productArray) {
        return this.installOptionProvider.getDefaultInstallOptions(productArray);
    }

    @Override
    public boolean isAnyControllingProductSelected() {
        for (InstallableProduct installableProduct : this.getSelectedCustomerFacingProducts()) {
            if (!installableProduct.getProductData().isControlling()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setInstallOptions(InstallOption[] installOptionArray) {
        this.installOptions = (InstallOption[])installOptionArray.clone();
    }

    private InstallableProduct[] getAllProductsToBeInstalled() {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        arrayList.addAll(Arrays.asList(this.getSelectedCustomerFacingProducts()));
        arrayList.addAll(this.nonCustomerFacingProducts);
        return arrayList.toArray(new InstallableProduct[arrayList.size()]);
    }

    private InstallableProduct[] getSelectedCustomerFacingProducts() {
        return this.toInstallableProducts(this.getSelectedAvailableProducts());
    }

    @Override
    public AvailableProduct[] getSelectedAvailableProducts() {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (AvailableProduct availableProduct : this.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            arrayList.add(availableProduct);
        }
        return arrayList.toArray(new AvailableProduct[arrayList.size()]);
    }

    private static Map<Product, InstallableProduct> getProductToInstallableProductMap(InstallableProduct[] installableProductArray) {
        HashMap<Product, InstallableProduct> hashMap = new HashMap<Product, InstallableProduct>();
        for (InstallableProduct installableProduct : installableProductArray) {
            hashMap.put(installableProduct.getProductData(), installableProduct);
        }
        return hashMap;
    }

    @Override
    public boolean canActivate(InstallConfiguration installConfiguration) {
        for (InstallableProduct installableProduct : this.getAllProductsToBeInstalled()) {
            if (!installableProduct.canActivate(installConfiguration)) continue;
            return true;
        }
        return false;
    }
}

