/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.google.inject.Inject;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.AbstractCommandFactory;
import com.mathworks.install.command.AssemblyFileInstaller;
import com.mathworks.install.command.AssemblyFileRegisterer;
import com.mathworks.install.command.AssemblyFrameworkCommand;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.DeletePreferencesCommand;
import com.mathworks.install.command.DesktopShortcutCreator;
import com.mathworks.install.command.DesktopShortcuts;
import com.mathworks.install.command.DirectoryResolver;
import com.mathworks.install.command.DllRegisterer;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.FileCopier;
import com.mathworks.install.command.InsertPathIntoSystemPathCommand;
import com.mathworks.install.command.InstallLicenseFileCommand;
import com.mathworks.install.command.InstallServiceProcessor;
import com.mathworks.install.command.InstallServiceProcessorWindows;
import com.mathworks.install.command.InstallationRootDirectoryResolver;
import com.mathworks.install.command.NoOpCommand;
import com.mathworks.install.command.OLERegisterCommand;
import com.mathworks.install.command.ProcessFilesCommand;
import com.mathworks.install.command.ProcessServicesCommand;
import com.mathworks.install.command.RegisterApplicationCommand;
import com.mathworks.install.command.RegisterAssemblyFolderCommand;
import com.mathworks.install.command.RegisterUninstallerCommand;
import com.mathworks.install.command.RemoveServiceProcessor;
import com.mathworks.install.command.StartMenuShortcutCreator;
import com.mathworks.install.command.StartMenuShortcuts;
import com.mathworks.install.command.StopServiceProcessor;
import com.mathworks.install.command.SystemDirectoryProvider;
import com.mathworks.install.command.SystemFileInstaller;
import com.mathworks.install.command.WriteInstallConfiguration;
import com.mathworks.install.service.Service;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

final class CommandFactoryWindows
extends AbstractCommandFactory {
    private final ProcessExecutor processExecutor;
    private final ExecutorService executorService;
    private final IO io;
    private final Registry registry;
    private final DotNetFramework dotNetFramework;
    private final AppLogger appLogger;
    private final FilePermissions filePermissions;
    private final Machine machine;
    private Platform platform;

    @Inject
    CommandFactoryWindows(ProcessExecutor processExecutor, ExecutorService executorService, IO iO, Registry registry, DotNetFramework dotNetFramework, AppLogger appLogger, FilePermissions filePermissions, Machine machine, Platform platform) {
        super(iO);
        this.processExecutor = processExecutor;
        this.executorService = executorService;
        this.io = iO;
        this.registry = registry;
        this.dotNetFramework = dotNetFramework;
        this.appLogger = appLogger;
        this.filePermissions = filePermissions;
        this.machine = machine;
        this.platform = platform;
    }

    @Override
    public Command createRegisterDllsCommand(String string, String ... stringArray) {
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystemDirectoryProvider(), this.appLogger);
        return new ProcessFilesCommand(dllRegisterer, string, stringArray);
    }

    private native String nativeGetSystemDirectory();

    @Override
    public Command createRegister32BitDllsCommand(String string, String ... stringArray) {
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystem32BitDirectoryProvider(), this.appLogger);
        return new ProcessFilesCommand(dllRegisterer, string, stringArray);
    }

    private native String nativeGet32BitSystemDirectory();

    @Override
    public Command createRegisterSystemDllsCommand(String ... stringArray) {
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystemDirectoryProvider(), this.appLogger);
        return new ProcessFilesCommand(new SystemDirectoryResolver(), dllRegisterer, stringArray);
    }

    @Override
    public Command createRemoveServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new RemoveServiceProcessor(), serviceArray);
    }

    @Override
    public Command createStopServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new StopServiceProcessor(), serviceArray);
    }

    @Override
    public Command createInstallServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new InstallServiceProcessor(), serviceArray);
    }

    @Override
    public Command createRegisterAssemblyFilesCommand(String string, String string2, String ... stringArray) {
        AssemblyFileRegisterer assemblyFileRegisterer = new AssemblyFileRegisterer(this.dotNetFramework, string2, this.appLogger);
        return new ProcessFilesCommand(assemblyFileRegisterer, string, stringArray);
    }

    @Override
    public Command createInstallAssemblyFilesCommand(String string, String ... stringArray) {
        AssemblyFileInstaller assemblyFileInstaller = new AssemblyFileInstaller(this.dotNetFramework, this.appLogger);
        return new ProcessFilesCommand(assemblyFileInstaller, string, stringArray);
    }

    @Override
    public Command createRegisterAssemblyFolderCommand(String string, String string2) {
        return new RegisterAssemblyFolderCommand(this.registry, string, string2, this.appLogger);
    }

    @Override
    public Command createAssemblyFrameworkCommand(String string, CommandErrorHandler commandErrorHandler, Command ... commandArray) {
        return new AssemblyFrameworkCommand(this.dotNetFramework, string, commandErrorHandler, commandArray);
    }

    @Override
    public Command createRegisterUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6) {
        return new RegisterUninstallerCommand(this.registry, string, string2, string3, string4, string5, string6, this.appLogger);
    }

    @Override
    public Command createRegisterApplicationCommand(RegisterAppPath registerAppPath) {
        return new RegisterApplicationCommand(this.registry, this.appLogger, registerAppPath);
    }

    @Override
    public Command createOLEAutomationCommand(String string, String string2, String string3) {
        return new OLERegisterCommand(string, string2, string3, this.appLogger);
    }

    @Override
    public Command createInsertPathIntoSystemPathCommand(String string, String string2) {
        return new InsertPathIntoSystemPathCommand(string, string2, this.registry, this.appLogger, this.platform);
    }

    @Override
    public Command createInstallFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        SystemFileInstaller systemFileInstaller = new SystemFileInstaller(this.appLogger);
        return new ProcessFilesCommand(systemFileInstaller, string, stringArray);
    }

    @Override
    public Command createCopyFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        FileCopier fileCopier = new FileCopier(this.io, new SystemDirectoryResolver(), this.appLogger);
        return new ProcessFilesCommand(fileCopier, string, stringArray);
    }

    @Override
    public Command createCopyFilesToInstallationCommand(String string, String string2, FilenameFilter filenameFilter) {
        FileCopier fileCopier = new FileCopier(this.io, new InstallationRootDirectoryResolver(string2), filenameFilter, this.appLogger);
        return new ProcessFilesCommand(fileCopier, string, new String[0]);
    }

    @Override
    public Command createFileAssociationsCommand(final String[] stringArray) {
        return new Command(){

            @Override
            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
                for (String string2 : stringArray) {
                    CommandFactoryWindows.this.doFileAssociation(string2, file.getAbsolutePath());
                }
            }

            @Override
            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
                for (String string2 : stringArray) {
                    CommandFactoryWindows.this.undoFileAssociation(string2, file.getAbsolutePath());
                }
            }
        };
    }

    @Override
    public Command createWriteLicenseFileCommand(InstallOption installOption) {
        return new InstallLicenseFileCommand(installOption, this.filePermissions, this.machine, this.io);
    }

    @Override
    public Command createInstallLicenseManagerServiceCommand(InstallOption installOption, Service service) {
        return new ProcessServicesCommand(new InstallServiceProcessorWindows(installOption), service);
    }

    @Override
    public Command createSymbolicLinkCommand(InstallOption installOption, String string) {
        return new NoOpCommand();
    }

    @Override
    public Command createDeletePreferencesCommand(InstallOption installOption) {
        return new DeletePreferencesCommand(this.io, this.appLogger);
    }

    @Override
    public Command createWriteInstallConfigurationCommand(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration) {
        return new WriteInstallConfiguration(installConfigurationPersistence, installConfiguration);
    }

    @Override
    public Command createDesktopShortcutCommand(String string, String string2, String string3, String string4) {
        DesktopShortcutCreator desktopShortcutCreator = new DesktopShortcutCreator(CommandFactoryWindows.getShortcutFileName(string3), string4, this.appLogger, new MyDesktopShortcuts());
        return new ProcessFilesCommand(desktopShortcutCreator, string, string2);
    }

    @Override
    public Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5) {
        StartMenuShortcutCreator startMenuShortcutCreator = new StartMenuShortcutCreator(CommandFactoryWindows.getShortcutFileName(string3), string4, string5, this.appLogger, this.io, new MyStartMenuShortcuts());
        return new ProcessFilesCommand(startMenuShortcutCreator, string, string2);
    }

    private static String getShortcutFileName(String string) {
        return string + ".lnk";
    }

    private native void createStartMenuShortcut(String var1, String var2, String var3, String var4, boolean var5);

    private static native void getSpecialFolderPath(String var0, StringBuffer var1);

    private native void createDesktopShortcut(String var1, String var2, String var3);

    private static native String getShortcutTarget(String var0);

    private static native boolean setMWFileAssociation(String var0, String var1);

    private static native void NotifyShellofAssociationChange();

    private void doFileAssociation(String string, String string2) {
        this.appLogger.logMsg("Updating " + string + " file association at " + string2);
        if (!CommandFactoryWindows.setMWFileAssociation(string, string2)) {
            this.appLogger.logMsg("Failed to install file association " + string + " at " + string2);
        } else {
            CommandFactoryWindows.NotifyShellofAssociationChange();
        }
    }

    private static native boolean deleteMWFileAssociation(String var0, String var1);

    private void undoFileAssociation(String string, String string2) {
        this.appLogger.logMsg("Deleting " + string + " file association at " + string2);
        if (!CommandFactoryWindows.deleteMWFileAssociation(string, string2)) {
            this.appLogger.logMsg("Failed to remove file association " + string + " at " + string2);
        }
    }

    private class MyDesktopShortcuts
    implements DesktopShortcuts {
        private MyDesktopShortcuts() {
        }

        @Override
        public void createShortcutOnDesktop(File file, String string, String string2) {
            CommandFactoryWindows.this.createDesktopShortcut(file.getAbsolutePath(), string, string2);
        }

        @Override
        public File getDesktopFolder() {
            StringBuffer stringBuffer = new StringBuffer();
            CommandFactoryWindows.getSpecialFolderPath("desktop", stringBuffer);
            return new File(stringBuffer.toString());
        }

        @Override
        public String getShortcutTargetPath(File file) {
            return CommandFactoryWindows.getShortcutTarget(file.getAbsolutePath());
        }
    }

    private class MyStartMenuShortcuts
    implements StartMenuShortcuts {
        private MyStartMenuShortcuts() {
        }

        @Override
        public void createShortcutInStartMenuFolder(File file, String string, String string2, String string3) {
            CommandFactoryWindows.this.createStartMenuShortcut(file.getAbsolutePath(), string, string2, string3, true);
        }

        @Override
        public File getStartMenuFolder() {
            StringBuffer stringBuffer = new StringBuffer();
            CommandFactoryWindows.getSpecialFolderPath("startmenu", stringBuffer);
            return new File(stringBuffer.toString());
        }

        @Override
        public String getShortcutTargetPath(File file) {
            return CommandFactoryWindows.getShortcutTarget(file.getAbsolutePath());
        }
    }

    private class SystemDirectoryResolver
    implements DirectoryResolver {
        private SystemDirectoryResolver() {
        }

        @Override
        public File resolveDirectory(File file) {
            return new File(CommandFactoryWindows.this.nativeGetSystemDirectory());
        }
    }

    private class MySystem32BitDirectoryProvider
    implements SystemDirectoryProvider {
        private MySystem32BitDirectoryProvider() {
        }

        @Override
        public File getSystemDirectory() {
            return new File(CommandFactoryWindows.this.nativeGet32BitSystemDirectory());
        }
    }

    private class MySystemDirectoryProvider
    implements SystemDirectoryProvider {
        private MySystemDirectoryProvider() {
        }

        @Override
        public File getSystemDirectory() {
            return new File(CommandFactoryWindows.this.nativeGetSystemDirectory());
        }
    }
}

