/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.command.CommandFactoryBat;
import com.mathworks.install.command.CommandFactoryWindows;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.DotNetFrameworkImpl;
import com.mathworks.install.command.NonWindowsCommandFactoryLinux;
import com.mathworks.install.command.NonWindowsCommandFactoryMac;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.MWNativeLibraryLoader;
import com.mathworks.instutil.MWNativeLibraryLoaderImpl;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.RegistryImpl;
import com.mathworks.instutil.logging.AppLogger;
import java.util.Properties;

public final class CommandModule
extends AbstractModule {
    private static final String FALSE = "false";

    protected void configure() {
        this.bind(ProcessExecutor.class).to(ProcessExecutorImpl.class);
        this.bind(Registry.class).to(RegistryImpl.class);
        this.bind(DotNetFramework.class).to(DotNetFrameworkImpl.class).in(Scopes.SINGLETON);
    }

    @Provides
    static MWNativeLibraryLoader provideMWNativeLibraryLoader(Properties properties, Platform platform) {
        return new MWNativeLibraryLoaderImpl(properties, platform);
    }

    @Provides
    static CommandFactory provideCommandFactory(Platform platform, ProcessExecutor processExecutor, ExecutorServiceManager executorServiceManager, IO iO, Registry registry, DotNetFramework dotNetFramework, AppLogger appLogger, Properties properties, FilePermissions filePermissions, Machine machine) {
        if (Boolean.valueOf(properties.getProperty("bat", FALSE)).booleanValue()) {
            return new CommandFactoryBat(filePermissions, machine, iO);
        }
        if (platform.isWindows()) {
            return new CommandFactoryWindows(processExecutor, executorServiceManager.getMultiThreadedExecutorService(), iO, registry, dotNetFramework, appLogger, filePermissions, machine, platform);
        }
        if (platform.isMac()) {
            return new NonWindowsCommandFactoryMac(filePermissions, machine, iO);
        }
        return new NonWindowsCommandFactoryLinux(filePermissions, machine, iO, appLogger);
    }
}

