/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CategoricalVariable<T> {
    private final Map<T, String> categories;
    private final ICategoriesUpdater catUpdater;
    private final Comparator<T> categoryComparator;
    private volatile T value;
    private volatile String name;

    public CategoricalVariable(Map<T, String> map, Comparator<T> comparator) {
        this(map, null, comparator);
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Category set must not be empty");
        }
    }

    public CategoricalVariable(ICategoriesUpdater<T> iCategoriesUpdater, Comparator<T> comparator) {
        this(null, iCategoriesUpdater, comparator);
        if (iCategoriesUpdater == null) {
            throw new IllegalArgumentException("Category updater must not be null");
        }
    }

    private CategoricalVariable(Map<T, String> map, ICategoriesUpdater<T> iCategoriesUpdater, Comparator<T> comparator) {
        this.catUpdater = iCategoriesUpdater;
        this.categoryComparator = comparator;
        this.categories = comparator != null ? Collections.synchronizedSortedMap(new TreeMap(comparator)) : Collections.synchronizedMap(new HashMap());
        this.setCategories(map);
        this.assignFirstElement();
    }

    private static CategoricalVariable<Integer> newInstance(int n, int[] nArray, String[] stringArray) {
        int n2;
        assert (nArray != null);
        assert (stringArray != null);
        assert (nArray.length == stringArray.length);
        final ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        Object object = nArray;
        int n3 = ((int[])object).length;
        for (n2 = 0; n2 < n3; ++n2) {
            Integer n4 = object[n2];
            arrayList.add(n4);
        }
        object = new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                Integer n3 = arrayList.indexOf(n);
                assert (n3 != -1) : "" + n + " is not a valid category.";
                Integer n4 = arrayList.indexOf(n2);
                assert (n4 != -1) : "" + n2 + " is not a valid category.";
                return n3.compareTo(n4);
            }
        };
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(nArray.length);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            hashMap.put(nArray[n2], stringArray[n2]);
        }
        CategoricalVariable<Integer> categoricalVariable = new CategoricalVariable<Integer>((Map<Integer, String>)hashMap, (Comparator<Integer>)object);
        categoricalVariable.setValue(n);
        return categoricalVariable;
    }

    public CategoricalVariable(CategoricalVariable<T> categoricalVariable) {
        if (categoricalVariable == null) {
            throw new IllegalArgumentException("Input argument must not be null");
        }
        this.name = categoricalVariable.name;
        this.catUpdater = categoricalVariable.catUpdater;
        this.categoryComparator = categoricalVariable.categoryComparator;
        this.categories = this.categoryComparator != null ? Collections.synchronizedSortedMap(new TreeMap(this.categoryComparator)) : Collections.synchronizedMap(new HashMap());
        this.categories.putAll(categoricalVariable.categories);
        this.value = categoricalVariable.value;
    }

    public final synchronized T getValue() {
        return this.value;
    }

    public synchronized void setValue(T t) {
        assert (this.isValidValue(t)) : "Value is not a valid category: " + t;
        this.value = t;
    }

    public final synchronized boolean isValidValue(T t) {
        for (T t2 : this.categories.keySet()) {
            if (!t2.equals(t)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean equals(Object object) {
        if (!(object instanceof CategoricalVariable)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        CategoricalVariable categoricalVariable = (CategoricalVariable)object;
        if (categoricalVariable.value == this.value) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return categoricalVariable.value.equals(this.value) && ((Object)categoricalVariable.categories.keySet()).equals(this.categories.keySet());
    }

    public static boolean equals(CategoricalVariable categoricalVariable, CategoricalVariable categoricalVariable2) {
        if (categoricalVariable == categoricalVariable2) {
            return true;
        }
        if (categoricalVariable != null && categoricalVariable2 != null) {
            return categoricalVariable.equals(categoricalVariable2);
        }
        return false;
    }

    public synchronized int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.value).append(this.categories.keySet()).toHashCode();
    }

    public final Map<T, String> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    private void setCategories(Map<T, String> map) {
        if ((map == null || map.isEmpty()) && this.catUpdater != null && ((map = this.catUpdater.updateCategories(this.categories)) == null || map.isEmpty())) {
            return;
        }
        this.categories.clear();
        this.categories.putAll(map);
        this.setCategoryLabels(this.categories);
    }

    private void assignFirstElement() {
        block0: {
            Iterator<T> iterator = this.categories.keySet().iterator();
            if (!iterator.hasNext()) break block0;
            T t = iterator.next();
            this.setValue(t);
        }
    }

    private final void setCategoryLabels(Map<T, String> map) {
        if (map == null) {
            return;
        }
        for (T t : this.categories.keySet()) {
            assert (t != null);
            String string = map.get(t);
            if (string != null) {
                this.categories.put(t, string);
                continue;
            }
            this.categories.put(t, t.toString());
        }
    }

    public final String getLabel() {
        return this.categories.get(this.getValue());
    }

    public synchronized boolean updateCategories() {
        if (this.catUpdater == null) {
            return false;
        }
        Map<T, String> map = this.catUpdater.updateCategories(Collections.unmodifiableMap(this.categories));
        if (map == null || map.isEmpty()) {
            return false;
        }
        this.setCategories(map);
        if (!this.categories.containsKey(this.getValue())) {
            this.assignFirstElement();
        }
        return true;
    }

    public synchronized T findValueByLabel(String string) {
        for (Map.Entry<T, String> entry : this.categories.entrySet()) {
            if (!StringUtils.equals((String)string, (String)entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", this.value).append("categories", this.categories).append("catUpdater", (Object)this.catUpdater).append("categoryComparator", this.categoryComparator).toString();
    }

    public static interface ICategoriesUpdater<T> {
        public Map<T, String> updateCategories(Map<T, String> var1);
    }
}

