/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class StyledColor
extends Color {
    private final String styleName;
    private final List<String> allowedStyles;
    private final boolean isColor;

    public StyledColor(double d, double d2, double d3, double d4, List<String> list) {
        super((float)d, (float)d2, (float)d3, (float)d4);
        if (list == null) {
            throw new IllegalArgumentException("Argument allowedStyles must not be null.");
        }
        this.styleName = null;
        this.isColor = true;
        this.allowedStyles = new ArrayList<String>(list);
    }

    public StyledColor(double d, double d2, double d3, List<String> list) {
        this(d, d2, d3, 1.0, list);
    }

    public StyledColor(String string, List<String> list) {
        super(0.0f, 0.0f, 0.0f);
        if (list == null) {
            throw new IllegalArgumentException("Argument allowedStyles must not be null.");
        }
        assert (list.contains(string)) : "styleName is not an allowed style: " + string;
        this.styleName = string;
        this.isColor = false;
        this.allowedStyles = new ArrayList<String>(list);
    }

    private static StyledColor newInstance(double d, double d2, double d3, double d4, String[] stringArray) {
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        StyledColor styledColor = new StyledColor(d, d2, d3, d4, arrayList);
        return styledColor;
    }

    private static StyledColor newInstance(String string, String[] stringArray) {
        assert (string != null) : "Argument style must not be null";
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        StyledColor styledColor = new StyledColor(string, arrayList);
        return styledColor;
    }

    private double[] getComponents() {
        float[] fArray = this.getComponents(null);
        return new double[]{fArray[0], fArray[1], fArray[2], fArray[3]};
    }

    public boolean isStyle() {
        return !this.isColor;
    }

    public boolean isColor() {
        return this.isColor;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyledColor)) {
            return false;
        }
        StyledColor styledColor = (StyledColor)object;
        if (this.isColor != styledColor.isColor) {
            return false;
        }
        if (this.isColor) {
            return super.equals(styledColor);
        }
        return StringUtils.equalsIgnoreCase((String)this.styleName, (String)styledColor.styleName);
    }

    public String getStyleName() {
        return this.styleName;
    }

    public List<String> getAllowedStyles() {
        return Collections.unmodifiableList(this.allowedStyles);
    }

    public boolean isStyleAllowed(String string) {
        return this.getFullStyleName(string) != null;
    }

    public String getFullStyleName(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (String string2 : this.allowedStyles) {
            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("isColor", this.isColor);
        toStringBuilder.append("styleName", (Object)this.styleName);
        toStringBuilder.append("allowedStyles", (Object)this.allowedStyles.toString());
        double[] dArray = this.getComponents();
        toStringBuilder.append("r", dArray[0]).append("g", dArray[1]).append("b", dArray[2]).append("a", dArray[3]);
        toStringBuilder.append("color", (Object)super.toString());
        return toStringBuilder.toString();
    }
}

