/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.QueueEvent;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer {
    public static final int NO_REPEAT = 0;
    public static final int AUTO_REPEAT = 1;
    public static final int MANUAL_REPEAT = 2;
    private String fThreadName;
    private int fDelay;
    private int fPriority;
    private boolean fIsRepeating;
    private boolean fAutoHold;
    private int fAutoDelay;
    private ActionListener fActionListener;
    private Integer fActionObject = new Integer(0);
    private TimerThread fThread;

    public Timer(int n, String string) {
        this(n, null, string);
    }

    public Timer(int n, ActionListener actionListener, String string) {
        this(n, actionListener, 1, string);
    }

    public Timer(int n, ActionListener actionListener, int n2, String string) {
        this(n, actionListener, n2, 1, string);
    }

    public Timer(int n, ActionListener actionListener, int n2, int n3, String string) {
        this.fThreadName = string;
        this.setDelay(n);
        if (n2 == 1) {
            this.fIsRepeating = true;
        } else if (n2 == 2) {
            this.fAutoHold = true;
        }
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
        this.setPriority(n3);
    }

    public int getDelay() {
        return this.fDelay;
    }

    public synchronized void setDelay(int n) {
        if (n < 0) {
            n = 0;
        }
        this.fAutoDelay = this.fDelay;
        this.fDelay = n;
    }

    public int getPriority() {
        return this.fPriority;
    }

    public void setPriority(int n) {
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        this.fPriority = n;
        if (this.fThread != null) {
            this.fThread.setPriority(this.fPriority);
        }
    }

    public boolean isRepeating() {
        return this.fIsRepeating;
    }

    public void setIsRepeating(boolean bl) {
        this.fIsRepeating = bl;
    }

    public synchronized void start() {
        if (this.fAutoHold && this.fThread != null) {
            this.fThread.reset();
            if (this.fDelay != this.fAutoDelay) {
                this.fAutoDelay = this.fDelay;
                this.fThread.interrupt();
            }
        } else {
            if (!this.fAutoHold) {
                this.stop();
            }
            if (this.fThread == null) {
                this.fThread = new TimerThread("Timer-" + this.fThreadName);
                this.fThread.setPriority(this.fPriority);
            }
            this.fThread.reset();
            this.fThread.start();
        }
    }

    public synchronized void stop() {
        if (this.fThread != null) {
            this.fAutoHold = false;
            this.fThread.requestStop();
            this.fThread = null;
        }
    }

    public void interrupt() {
        if (this.fThread != null) {
            this.fThread.interrupt();
        }
    }

    public synchronized void hold() {
        if (this.fThread != null) {
            this.fThread.hold();
        }
    }

    public synchronized void reset() {
        if (this.fThread != null) {
            this.fThread.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener actionListener) {
        Integer n = this.fActionObject;
        synchronized (n) {
            this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener actionListener) {
        Integer n = this.fActionObject;
        synchronized (n) {
            this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(ActionEvent actionEvent) {
        Integer n = this.fActionObject;
        synchronized (n) {
            if (this.fActionListener != null) {
                this.fActionListener.actionPerformed(actionEvent);
            }
        }
    }

    private static class TimerEvent
    extends QueueEvent {
        private ActionEvent fEvent;
        private Timer fTimer;

        public TimerEvent(Timer timer) {
            this.fTimer = timer;
            this.fEvent = new ActionEvent(timer, 1001, "");
        }

        void cancel() {
            this.fTimer = null;
        }

        @Override
        public void dispatch() {
            Timer timer = this.fTimer;
            if (timer != null) {
                timer.notifyListeners(this.fEvent);
            }
        }
    }

    private class TimerThread
    extends Thread {
        private long fStart;
        private boolean fFirstTime;
        private boolean fStopRequested;
        private boolean fHold;
        private boolean fReset;
        private TimerEvent fTimerEvent;

        public TimerThread(String string) {
            super(string);
            this.fFirstTime = true;
        }

        public void hold() {
            this.fHold = true;
        }

        public void requestStop() {
            this.fStopRequested = true;
            if (this.fTimerEvent != null) {
                this.fTimerEvent.cancel();
                this.fTimerEvent = null;
            }
        }

        public void reset() {
            this.fStart = System.nanoTime();
            this.fHold = false;
            this.fReset = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.fTimerEvent == null) {
                this.fTimerEvent = new TimerEvent(Timer.this);
            }
            TimerEvent timerEvent = this.fTimerEvent;
            long l = Timer.this.getDelay();
            while ((this.fFirstTime || Timer.this.isRepeating()) && !this.fStopRequested) {
                boolean bl = false;
                boolean bl2 = false;
                try {
                    this.fStart = System.nanoTime();
                    TimerThread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                this.fFirstTime = false;
                Timer timer = Timer.this;
                synchronized (timer) {
                    if (!bl2) {
                        long l2 = (System.nanoTime() - this.fStart) / 10L ^ 6L;
                        if (l2 >= l) {
                            if (!this.fStopRequested && !this.fHold) {
                                if (Timer.this.fAutoHold) {
                                    this.fHold = true;
                                }
                                bl = true;
                            }
                            l = Timer.this.getDelay();
                        } else {
                            l -= l2;
                        }
                    } else {
                        l = Timer.this.getDelay();
                        if (Timer.this.fAutoHold && !this.fReset) {
                            this.fHold = true;
                        }
                    }
                    if (Timer.this.fAutoHold) {
                        this.fFirstTime = true;
                        this.fReset = false;
                    }
                }
                if (!bl) continue;
                QueueEvent.postQueueEvent(timerEvent);
            }
        }
    }
}

