/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetScrollPane;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTable;

public abstract class AbstractTypedViewer
extends MJPanel
implements UpdatableData {
    protected final JComponent fComponent;
    private UpdatableData fUpdatableData = null;
    protected MJScrollPane fScrollPane;
    private FocusListener fFListener;

    public AbstractTypedViewer(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("Specified component cannot be null.");
        }
        this.fComponent = jComponent;
        this.setLayout(new BorderLayout());
        if (jComponent instanceof UpdatableData) {
            this.fUpdatableData = (UpdatableData)((Object)jComponent);
        }
        this.fScrollPane = this.fComponent instanceof SpreadsheetTable ? new SpreadsheetScrollPane((JTable)jComponent) : new MJScrollPane((Component)jComponent);
        this.add((Component)this.fScrollPane, "Center");
        this.fFListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AbstractTypedViewer.this.fComponent.requestFocus();
            }
        };
        this.addFocusListener(this.fFListener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fComponent != null) {
            this.fComponent.setFont(font);
        }
    }

    public final void setForeground(Color color) {
        super.setForeground(color);
        if (this.fComponent != null) {
            this.fComponent.setForeground(color);
            this.fScrollPane.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fComponent != null) {
            this.fComponent.setBackground(color);
            this.fScrollPane.getViewport().setBackground(color);
        }
    }

    @Override
    public final void updateData() {
        if (this.fUpdatableData != null) {
            this.fUpdatableData.updateData();
        }
    }

    public void cleanup() {
        this.removeFocusListener(this.fFListener);
        this.fFListener = null;
        this.removeAll();
        if (this.fScrollPane instanceof SpreadsheetScrollPane) {
            ((SpreadsheetScrollPane)this.fScrollPane).cleanup();
        }
        this.fScrollPane.removeAll();
        this.fScrollPane = null;
    }
}

