/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.SummaryBar;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.spreadsheet.data.ValueSummary;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;

class ValueSummaryBar
extends SummaryBar {
    private WorkspaceVariable fWorkspaceVariable;
    private HyperlinkTextLabel fLabel;
    private String fClassName = null;
    private boolean fCleanedUp = false;

    ValueSummaryBar(WorkspaceVariable workspaceVariable) {
        super("", null);
        this.fWorkspaceVariable = workspaceVariable;
        this.fLabel = new HyperlinkTextLabel("", (HyperlinkTextLabel.HyperlinkHandler)new MyHyperlinkHandler(), false, "summaryLabel_0", "");
    }

    void setWorkspaceVariable(WorkspaceVariable workspaceVariable) {
        this.fWorkspaceVariable = workspaceVariable;
    }

    void update() {
        if (Matlab.isMatlabAvailable()) {
            if (this.fWorkspaceVariable.isDefaultWorkspace()) {
                WorkspaceCommands.getVariableAbstractSummaries(new String[]{this.fWorkspaceVariable.getVariableName()}, (MatlabListener)new SACO(this));
            } else {
                WorkspaceCommands.getVariableAbstractSummaries(this.fWorkspaceVariable, (MatlabListener)new SACO(this));
            }
        }
    }

    private void update(ValueSummary valueSummary) {
        String string;
        String string2;
        ImageIcon imageIcon;
        if (valueSummary == null) {
            imageIcon = WorkspaceIcon.getNonexistentIcon();
            string2 = ArrayUtils.getResource("valueSummary.doesNotExist");
            this.fClassName = null;
            string2 = this.fWorkspaceVariable.getVariableName() + ' ' + string2;
            string = "";
        } else {
            imageIcon = WorkspaceIcon.getIcon(valueSummary.getMatlabClass());
            string2 = valueSummary.toString(false);
            String[] stringArray = ValueSummaryBar.splitSummary(string2);
            this.fClassName = stringArray[1];
            StringBuilder stringBuilder = new StringBuilder(this.fWorkspaceVariable.getVariableName());
            if (!WorkspaceCommands.isBuiltinNumericType(this.fClassName)) {
                stringBuilder.append(' ').append(stringArray[0]).append("<a href=").append(this.fClassName).append(">").append(this.fClassName).append("</a>").append(stringArray[2]);
            } else {
                stringBuilder.append(' ').append(stringArray[0]).append(this.fClassName).append(stringArray[2]);
            }
            string2 = stringBuilder.toString();
            string = "Documentation";
        }
        this.fLabel.setText(string2);
        this.fLabel.setAccessibleName(string);
        this.fLabel.getComponent().invalidate();
        if (this.fLabel.getComponent().getParent() != null) {
            this.fLabel.getComponent().getParent().validate();
        }
        this.setMessageComponentAndIcon(this.fLabel.getComponent(), imageIcon);
    }

    boolean cleanedUp() {
        return this.fCleanedUp;
    }

    void cleanup() {
        this.fCleanedUp = true;
        if (this.fLabel != null) {
            this.fLabel.cleanup();
            this.fLabel = null;
        }
    }

    private static String[] splitSummary(String string) {
        String[] stringArray = string.split("\\S+[>]");
        String string2 = stringArray[0];
        return new String[]{string2.replaceAll("<", "&lt;"), string.substring(string2.length(), string.length() - 1), "&gt;"};
    }

    private class MyHyperlinkHandler
    implements HyperlinkTextLabel.HyperlinkHandler {
        private MyHyperlinkHandler() {
        }

        public void processHyperlink(String string) {
            if (ValueSummaryBar.this.fClassName != null) {
                WorkspaceMCRProvider.getMCRForUserActions().evalNoOutput("doc " + ValueSummaryBar.this.fClassName);
            }
        }
    }

    private static class SACO
    implements MatlabListener {
        private WeakReference<ValueSummaryBar> fValueSummaryBarWeakReference;

        SACO(ValueSummaryBar valueSummaryBar) {
            this.fValueSummaryBarWeakReference = new WeakReference<ValueSummaryBar>(valueSummaryBar);
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object[] objectArray;
            Object object;
            ValueSummary valueSummary = null;
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0 && (object = matlabEvent.getResult()) instanceof Object[] && (objectArray = (Object[])matlabEvent.getResult())[0] instanceof ValueSummary) {
                valueSummary = (ValueSummary)objectArray[0];
            }
            if ((object = (ValueSummaryBar)((Object)this.fValueSummaryBarWeakReference.get())) != null && !((ValueSummaryBar)((Object)object)).cleanedUp()) {
                ((ValueSummaryBar)((Object)object)).update(valueSummary);
            }
        }
    }
}

