/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupByFileDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.UiSupport;
import java.awt.Font;
import java.io.File;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;

public class ConfigurationGroupByFile
extends AbstractConfigurationGroup {
    @Override
    public AbstractConfigurationGroup.ConfigurationGroupTreeFormat createTreeFormat() {
        return new FileGroupTreeFormat();
    }

    public UiSupport<FileGroupingConfiguration> createUiSupport() {
        return new FileGroupUiSupport();
    }

    public static class FileNameComparator
    implements Comparator<AbstractFileConfiguration> {
        @Override
        public int compare(AbstractFileConfiguration abstractFileConfiguration, AbstractFileConfiguration abstractFileConfiguration2) {
            int n = abstractFileConfiguration.getAssociatedFileName().compareTo(abstractFileConfiguration2.getAssociatedFileName());
            int n2 = abstractFileConfiguration.getAssociatedFile().compareTo(abstractFileConfiguration2.getAssociatedFile());
            return n == 0 ? n2 : n;
        }
    }

    private static class FileGroupUiSupport
    implements UiSupport<FileGroupingConfiguration> {
        private FileGroupUiSupport() {
        }

        @Override
        public String getDisplayName(FileGroupingConfiguration fileGroupingConfiguration) {
            return fileGroupingConfiguration.getAssociatedFileName();
        }

        @Override
        public Icon getIcon(FileGroupingConfiguration fileGroupingConfiguration) {
            return fileGroupingConfiguration.isFileValid() ? null : DialogIcon.ERROR_12x12.getIcon();
        }

        @Override
        public Font getFont(Font font, FileGroupingConfiguration fileGroupingConfiguration) {
            return font.deriveFont(1);
        }

        @Override
        public String getActionString() {
            return null;
        }

        @Override
        public String getActionName() {
            return null;
        }

        @Override
        public String getIncorrectExtensionErrorMessage() {
            return null;
        }

        @Override
        public String getTooltip(FileGroupingConfiguration fileGroupingConfiguration) {
            String string = fileGroupingConfiguration.getAssociatedFile().getName().length() == 0 ? ConfigurationUtils.lookup("group.settings.noFileSpecified.tooltip") : (fileGroupingConfiguration.isFileValid() ? fileGroupingConfiguration.getAssociatedPathAndFileName() : MessageFormat.format(ConfigurationUtils.lookup("group.settings.fileNotFound.shortMessage"), fileGroupingConfiguration.getAssociatedFileName()));
            return string;
        }

        @Override
        public ComponentDetailsEditor<FileGroupingConfiguration> createEditorComponent() {
            return new ConfigurationGroupByFileDetailsEditor();
        }

        @Override
        public String getHelpKey() {
            return "desktop_config_assoc_mfile";
        }
    }

    private static class FileGroupTreeFormat
    extends AbstractConfigurationGroup.ConfigurationGroupTreeFormat {
        private FileGroupTreeFormat() {
        }

        public void getPath(List<AbstractFileConfiguration> list, AbstractFileConfiguration abstractFileConfiguration) {
            list.add(new FileGroupingConfiguration(abstractFileConfiguration.getAssociatedFile()));
            list.add(abstractFileConfiguration);
        }
    }

    public static class FileGroupingConfiguration
    extends AbstractConfigurationGroup.GroupingConfiguration {
        public static AbstractFileConfiguration.Type<AbstractConfigurationGroup.GroupingConfiguration> TYPE = new AbstractFileConfiguration.Type<AbstractConfigurationGroup.GroupingConfiguration>(){

            @Override
            public String getName() {
                return "file_grouping_configuration";
            }

            @Override
            public AbstractConfigurationGroup.GroupingConfiguration create(File file) {
                return new FileGroupingConfiguration(file);
            }
        };

        public FileGroupingConfiguration(File file) {
            super(file);
        }

        @Override
        public AbstractFileConfiguration.Type getType() {
            return TYPE;
        }
    }
}

