/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFileChooser;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.tree.TreeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupDialog {
    private static final Color BACKGROUND_COLOR = ColorUtils.convertToCurrentColorScheme((Color)new Color(242, 241, 246), (Color)UIManager.getColor("control"));
    private final GridBagConstraints fConstraints;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.dialog.resources.RES_dialog");
    private final MJPanel fComponent;
    private final MJPopupMenu fMenu = new MJPopupMenu(){

        public void setVisible(boolean bl) {
            if (!PopupDialog.this.fLocked) {
                super.setVisible(bl);
            }
        }
    };
    private MJButton fOkButton;
    private boolean fAdded;
    private boolean fCancelRan;
    private boolean fOkRan;
    private boolean fLocked;

    public PopupDialog() {
        this.fComponent = new MJPanel((LayoutManager)new GridBagLayout());
        this.fComponent.setBackground(BACKGROUND_COLOR);
        this.fConstraints = new GridBagConstraints();
        this.fConstraints.gridx = 0;
        this.fConstraints.gridy = 0;
        this.fConstraints.anchor = 17;
        this.fConstraints.insets = new Insets(4, 4, 4, 4);
        this.fConstraints.weightx = 1.0;
        this.fConstraints.weighty = 0.0;
        this.fConstraints.fill = 2;
    }

    public void addSection(String string, MJPanel mJPanel) {
        mJPanel.setBackground(BACKGROUND_COLOR);
        this.fComponent.add((Component)((Object)new SectionLabel(string, mJPanel)), (Object)this.fConstraints);
        ++this.fConstraints.gridy;
        this.fConstraints.insets = new Insets(4, 21, 4, 4);
        this.fComponent.add((Component)mJPanel, (Object)this.fConstraints);
        this.fConstraints.insets = new Insets(4, 4, 4, 4);
        ++this.fConstraints.gridy;
    }

    public void showWithoutClosing(MJDialog mJDialog) {
        this.fLocked = true;
        mJDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PopupDialog.this.fLocked = false;
            }
        });
        mJDialog.show();
    }

    public MJFileChooser createFileChooser() {
        return new MJFileChooser(){

            public int showDialog(Component component, String string) {
                PopupDialog.this.fLocked = true;
                int n = super.showDialog(component, string);
                PopupDialog.this.fLocked = false;
                return n;
            }
        };
    }

    protected void lock() {
        this.fLocked = true;
    }

    protected void unlock() {
        this.fLocked = false;
    }

    public void addOkCancelButtons(final Runnable runnable, final Runnable runnable2) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("button.ok")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!PopupDialog.this.fOkRan && !PopupDialog.this.fCancelRan) {
                    PopupDialog.this.fOkRan = true;
                    PopupDialog.this.fLocked = false;
                    runnable.run();
                }
            }
        };
        this.fOkButton = new MJButton((Action)mJAbstractAction);
        MJButton mJButton = new MJButton(sRes.getString("button.cancel"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!PopupDialog.this.fCancelRan && !PopupDialog.this.fOkRan) {
                    PopupDialog.this.fCancelRan = true;
                    PopupDialog.this.fLocked = false;
                    runnable2.run();
                }
            }
        });
        JPanel jPanel = ButtonBarFactory.buildOKCancelBar((JButton)this.fOkButton, (JButton)mJButton);
        jPanel.setOpaque(false);
        this.fComponent.add((Component)jPanel, (Object)this.fConstraints);
        ++this.fConstraints.gridy;
        this.fMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (!PopupDialog.this.fCancelRan && !PopupDialog.this.fOkRan) {
                    PopupDialog.this.fCancelRan = true;
                    PopupDialog.this.fLocked = false;
                    runnable2.run();
                }
            }
        });
        for (JComponent jComponent : TreeUtils.findComponents((Component)this.fComponent, JComponent.class)) {
            jComponent.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ok");
            jComponent.getActionMap().put("ok", (Action)mJAbstractAction);
        }
    }

    public void show(Component component, int n, int n2) {
        if (!this.fAdded) {
            this.fMenu.add((Component)this.fComponent);
            this.fAdded = true;
        }
        this.fMenu.show(component, n, n2);
    }

    public JComponent getComponent() {
        return this.fMenu;
    }

    public void hide() {
        this.fMenu.setVisible(false);
    }

    public void setOkEnabled(boolean bl) {
        if (this.fOkButton == null) {
            throw new IllegalStateException("You must add ok/cancel buttons before enabling or disabling the OK button");
        }
        this.fOkButton.setEnabled(bl);
    }

    private class SectionLabel
    extends MJLabel {
        SectionLabel(String string, final MJPanel mJPanel) {
            this.setFont(this.getFont().deriveFont(1, 12.0f));
            this.setText(string);
            this.setIcon(DocumentIcon.BLACK_DOWN_ARROW.getIcon());
            mJPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    SectionLabel.this.setIcon(DocumentIcon.BLACK_DOWN_ARROW.getIcon());
                    PopupDialog.this.fMenu.setPopupSize(new Dimension((int)(PopupDialog.this.fComponent.getPreferredSize().getWidth() + 6.0), (int)(PopupDialog.this.fComponent.getPreferredSize().getHeight() + 4.0)));
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    SectionLabel.this.setIcon(DocumentIcon.BLACK_RIGHT_ARROW.getIcon());
                    PopupDialog.this.fMenu.setPopupSize(new Dimension((int)(PopupDialog.this.fComponent.getPreferredSize().getWidth() + 6.0), (int)(PopupDialog.this.fComponent.getPreferredSize().getHeight() + 4.0)));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mJPanel.isVisible()) {
                        mJPanel.setVisible(false);
                    } else {
                        mJPanel.setVisible(true);
                    }
                }
            });
        }
    }
}

