/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.ExplorerSplitPanePrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public final class DetailViewer {
    private final MJSplitPane fSplitPane;
    private final FileTable fTable;
    private final ExplorerSplitPanePrefs fPrefs;
    private FileSystemEntry fFile;
    private UiFileList fList;
    private JComponent fCurrentPanel;
    private JComponent fCurrentFocusablePanel;
    private final MJPanel fComponent;
    private final BusyAffordance fAffordance;
    private final MJPanel fBusyPanel;
    private final MJPanel fNoSelectionPanel;
    private final MJPanel fNoDetailsPanel;
    private final MJLabel fLeftLabel;
    private final ExpansionChangeListener<FileSystemEntry> fChangeListener;
    private Status fLoadStatus;
    private Timer fBusyTimer;
    private boolean fLoadOnExpand;
    private final Header fHeader;
    private static final double HEADER_DRAGGABLE_AREA = 0.5;
    private static final int BUSY_DELAY = 700;
    private static final int HEADER_SIZE = 21;
    public static final String PREVIEW_PANEL_COMPONENT_NAME = "preview-panel-component-name";
    public static final String PREVIEW_PANEL_BUTTON_NAME = "preview-panel-button-name";

    public DetailViewer(MJSplitPane mJSplitPane, FileTable fileTable, ExplorerSplitPanePrefs explorerSplitPanePrefs) {
        this.fPrefs = explorerSplitPanePrefs;
        this.fTable = fileTable;
        this.fLeftLabel = new HeaderLabel();
        this.fSplitPane = mJSplitPane;
        this.fComponent = new MJPanel(){

            public Dimension getMinimumSize() {
                return new Dimension((int)super.getPreferredSize().getWidth(), 21);
            }

            public Dimension getPreferredSize() {
                return new Dimension((int)super.getPreferredSize().getWidth(), 21 + (int)(DetailViewer.this.fCurrentPanel == null || DetailViewer.this.fCurrentPanel.getPreferredSize().getHeight() < 58.0 ? 150.0 : DetailViewer.this.fCurrentPanel.getPreferredSize().getHeight()));
            }
        };
        this.fComponent.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DetailViewer.this.fCurrentFocusablePanel != null) {
                    DetailViewer.this.fCurrentFocusablePanel.requestFocus();
                }
            }
        });
        this.fHeader = new Header();
        this.fComponent.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.fCurrentPanel = new MJPanel();
        this.fComponent.add((Component)((Object)this.fHeader), (Object)"North");
        this.fComponent.add((Component)this.fCurrentPanel, (Object)"Center");
        this.fNoDetailsPanel = DetailViewer.createMessagePanel(ExplorerResources.getString("detailviewer.nodetails"));
        this.fNoSelectionPanel = DetailViewer.createMessagePanel(ExplorerResources.getString("detailviewer.noselection"));
        this.fComponent.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DetailViewer.this.fHeader.updateIcon();
                if (DetailViewer.this.fLoadOnExpand) {
                    DetailViewer.this.setFile(DetailViewer.this.fFile);
                }
            }
        });
        this.fChangeListener = new ExpansionChangeListener<FileSystemEntry>(){

            public void childrenChanged(GroupingTableTransaction<FileSystemEntry> groupingTableTransaction) {
                FileSystemEntry fileSystemEntry = DetailViewer.this.fFile;
                if (fileSystemEntry != null) {
                    for (GroupingTableTransaction.Element element : groupingTableTransaction) {
                        if (!((FileSystemEntry)element.getData()).equals((Object)fileSystemEntry)) continue;
                        if (element.getType().equals((Object)GroupingTableTransaction.Type.REMOVE)) {
                            DetailViewer.this.setFile(null);
                            continue;
                        }
                        DetailViewer.this.setFile(DetailViewer.this.fFile);
                    }
                }
            }

            public void hasChildrenChanged() {
            }
        };
        this.fAffordance = new BusyAffordance();
        this.fBusyPanel = new MJPanel((LayoutManager)new FlowLayout());
        this.fBusyPanel.add((Component)this.fAffordance.getComponent());
        this.setFile(null);
    }

    private static MJPanel createMessagePanel(String string) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setVerticalAlignment(0);
        mJLabel.setHorizontalAlignment(0);
        mJPanel.setBackground(Color.WHITE);
        mJPanel.add((Component)mJLabel);
        return mJPanel;
    }

    public FileSystemEntry getFile() {
        return this.fFile;
    }

    public void setFile(final FileSystemEntry fileSystemEntry) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DetailViewer.this.fList != null) {
                    DetailViewer.this.fList.removeListener((ExpansionChangeListener<FileSystemEntry>)DetailViewer.this.fChangeListener);
                }
                if (fileSystemEntry != null) {
                    DetailViewer.this.fList = DetailViewer.this.fTable.getList(fileSystemEntry);
                    if (DetailViewer.this.fList != null) {
                        DetailViewer.this.fList.addListener((ExpansionChangeListener<FileSystemEntry>)DetailViewer.this.fChangeListener);
                    }
                }
                DetailViewer.this.fLoadOnExpand = false;
                if (DetailViewer.this.fBusyTimer != null) {
                    DetailViewer.this.fBusyTimer.stop();
                }
                DetailViewer.this.fFile = fileSystemEntry;
                if (DetailViewer.this.fFile != null) {
                    String string = (Boolean)DetailViewer.this.fTable.getDecoration(DetailViewer.this.fFile, CoreFileDecoration.IS_DIRTY_FLAG) != false ? "*" : " ";
                    String string2 = (String)DetailViewer.this.fTable.getDecoration(DetailViewer.this.fFile, false, CoreFileDecoration.TYPE_NAME);
                    DetailViewer.this.fLeftLabel.setText("<html><nobr><b>" + DetailViewer.this.fFile.getLocation().getName() + string + "</b> (" + string2 + ")" + "</nobr></html>");
                } else {
                    DetailViewer.this.fLeftLabel.setText("<html><nobr><b>" + ExplorerResources.getString("detailviewer.header.default") + "</b></nobr></html>");
                }
                if (DetailViewer.this.fComponent.getSize().getHeight() <= 21.0) {
                    DetailViewer.this.fLoadOnExpand = true;
                    DetailViewer.this.fComponent.revalidate();
                    DetailViewer.this.fComponent.repaint();
                    return;
                }
                if (DetailViewer.this.fFile == null) {
                    DetailViewer.this.switchPanel(null, null, Status.COMPLETED, true);
                } else {
                    DetailViewer.this.fBusyTimer = new Timer(700, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DetailViewer.this.switchPanel((JComponent)DetailViewer.this.fBusyPanel, null, Status.COMPLETED, true);
                        }
                    });
                    DetailViewer.this.fBusyTimer.setRepeats(false);
                    DetailViewer.this.fBusyTimer.start();
                    DetailViewer.this.fTable.getDecorationAsynchronously(fileSystemEntry, CoreFileDecoration.DETAIL_PANEL, new ParameterRunnable<DetailPanel>(){

                        public void run(DetailPanel detailPanel) {
                            if (DetailViewer.this.fFile == fileSystemEntry) {
                                if (DetailViewer.this.fBusyTimer != null) {
                                    DetailViewer.this.fBusyTimer.stop();
                                }
                                String string = (String)DetailViewer.this.fTable.getDecoration(fileSystemEntry, CoreFileDecoration.DESCRIPTION);
                                DetailViewer.this.switchPanel(detailPanel == null ? null : detailPanel.getComponent(), string, detailPanel == null ? Status.COMPLETED : detailPanel.getLoadStatus(), detailPanel != null && detailPanel.isScrollBarNeeded());
                            }
                        }
                    });
                }
            }
        });
    }

    private void switchPanel(final JComponent jComponent, final String string, final Status status, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DetailViewer.this.fLoadStatus != null && DetailViewer.this.fLoadStatus != status) {
                    DetailViewer.this.fLoadStatus.requestCancellation();
                }
                if (DetailViewer.this.fCurrentPanel != null) {
                    DetailViewer.this.fComponent.remove((Component)DetailViewer.this.fCurrentPanel);
                    DetailViewer.this.fComponent.revalidate();
                    DetailViewer.this.fComponent.repaint();
                    if (DetailViewer.this.fCurrentPanel == DetailViewer.this.fBusyPanel) {
                        DetailViewer.this.fAffordance.stop();
                    }
                }
                DetailViewer.this.fCurrentPanel = jComponent;
                if (DetailViewer.this.fCurrentPanel == DetailViewer.this.fBusyPanel) {
                    DetailViewer.this.fAffordance.start();
                }
                if (DetailViewer.this.fCurrentPanel == null && DetailViewer.this.fFile == null) {
                    DetailViewer.this.fCurrentPanel = (JComponent)DetailViewer.this.fNoSelectionPanel;
                } else if (DetailViewer.this.fCurrentPanel == null) {
                    if (string != null && string.length() > 0) {
                        MJTextArea mJTextArea = new MJTextArea();
                        mJTextArea.setFont(new MJLabel().getFont());
                        mJTextArea.setEditable(false);
                        mJTextArea.setLineWrap(true);
                        mJTextArea.setWrapStyleWord(true);
                        mJTextArea.setText(string);
                        mJTextArea.setCaretPosition(0);
                        DetailViewer.this.fCurrentPanel = (JComponent)mJTextArea;
                    } else {
                        DetailViewer.this.fCurrentPanel = (JComponent)DetailViewer.this.fNoDetailsPanel;
                    }
                }
                DetailViewer.this.fLoadStatus = status;
                if (!DetailViewer.this.fLoadStatus.isCompleted() && !DetailViewer.this.fLoadStatus.isSuccessfullyCanceled()) {
                    DetailViewer.this.fComponent.setCursor(Cursor.getPredefinedCursor(3));
                    DetailViewer.this.fLoadStatus.addCompletionOrCancellationRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (DetailViewer.this.fLoadStatus == status) {
                                DetailViewer.this.fComponent.setCursor(Cursor.getDefaultCursor());
                            }
                        }
                    });
                } else {
                    DetailViewer.this.fComponent.setCursor(Cursor.getDefaultCursor());
                }
                DetailViewer.this.fCurrentFocusablePanel = DetailViewer.this.fCurrentPanel;
                DetailViewer.this.fCurrentPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                if (DetailViewer.this.fCurrentPanel.getName() == null) {
                    DetailViewer.this.fCurrentPanel.setName(DetailViewer.PREVIEW_PANEL_COMPONENT_NAME);
                }
                if (bl) {
                    DetailViewer.this.fCurrentPanel = (JComponent)new MJScrollPane((Component)DetailViewer.this.fCurrentPanel);
                    DetailViewer.this.fCurrentPanel.setBorder(null);
                }
                DetailViewer.this.fComponent.add((Component)DetailViewer.this.fCurrentPanel, (Object)"Center");
                DetailViewer.this.fComponent.revalidate();
                DetailViewer.this.fComponent.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public MJButton getButton() {
        return this.fHeader.getButton();
    }

    public boolean isExpanded() {
        return !this.fPrefs.isCollapsed();
    }

    public void expand(boolean bl) {
        this.fPrefs.setCollapsed(false);
        if (bl && this.fPrefs.getRatio() > 0.0) {
            this.fSplitPane.setDividerLocation((int)Math.max((double)this.fTable.getTableHeader().getHeight(), this.fPrefs.getRatio() / 100.0 * (double)this.fSplitPane.getMaximumDividerLocation()));
        } else if (this.fPrefs.getSize() > 0) {
            this.fSplitPane.setDividerLocation(Math.max(this.fTable.getTableHeader().getHeight(), this.fSplitPane.getMaximumDividerLocation() - this.fPrefs.getSize()));
        } else {
            int n = this.getDefaultExpandedSize();
            if (!bl && n > (int)(0.35 * (double)this.fSplitPane.getMaximumDividerLocation())) {
                this.collapse();
                return;
            }
            this.fSplitPane.setDividerLocation(this.fSplitPane.getMaximumDividerLocation() - n);
        }
    }

    public void collapse() {
        this.fSplitPane.setDividerLocation(this.getCollapsedLocation());
    }

    public void resizeViewer(int n) {
        this.fSplitPane.setDividerLocation(Math.min(this.getCollapsedLocation(), Math.max(this.fTable.getTableHeader().getHeight(), this.fSplitPane.getDividerLocation() - n)));
    }

    public int getDefaultExpandedSize() {
        return (int)this.getComponent().getPreferredSize().getHeight();
    }

    public int getCollapsedLocation() {
        return this.fSplitPane.getMaximumDividerLocation();
    }

    private Icon createArrowIcon() {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(UIManager.getColor("ScrollBar.thumbDarkShadow"));
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.fComponent.getHeight() > 21) {
            graphics2D.draw(new Line2D.Double(4.0, 4.0, 8.0, 8.0));
            graphics2D.draw(new Line2D.Double(8.0, 8.0, 12.0, 4.0));
        } else {
            graphics2D.draw(new Line2D.Double(4.0, 8.0, 8.0, 4.0));
            graphics2D.draw(new Line2D.Double(8.0, 4.0, 12.0, 8.0));
        }
        return new ImageIcon(bufferedImage);
    }

    private static class HeaderLabel
    extends MJLabel {
        private final Color fColor = MJUtilities.isHighContrast() ? Color.WHITE : ColorUtils.convertToCurrentColorScheme((Color)new Color(103, 103, 127), (Color)UIManager.getColor("control"));
        private final Font fFont = new Font("SansSerif", 0, 11);

        HeaderLabel() {
            this.setForeground(this.fColor);
            this.setFont(this.fFont);
            this.setOpaque(false);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, (int)super.getMinimumSize().getHeight());
        }

        public void setForeground(Color color) {
            super.setForeground(this.fColor != null ? this.fColor : color);
        }

        public void setFont(Font font) {
            super.setFont(this.fFont != null ? this.fFont : font);
        }
    }

    private class Header
    extends MJPanel {
        private final MJButton fButton;

        Header() {
            this.setLayout(new GridBagLayout());
            this.fButton = new MJButton(DetailViewer.this.createArrowIcon());
            this.fButton.setName(DetailViewer.PREVIEW_PANEL_BUTTON_NAME);
            this.fButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DetailViewer.this.fComponent.getHeight() > 21) {
                        DetailViewer.this.collapse();
                    } else {
                        DetailViewer.this.expand(true);
                    }
                    Header.this.fButton.setIcon(DetailViewer.this.createArrowIcon());
                    Header.this.revalidate();
                    Header.this.repaint();
                }
            });
            this.fButton.setOpaque(false);
            MJToolBar.configureButton((MJButton)this.fButton);
            this.fButton.setFocusTraversable(true);
            this.add((Component)DetailViewer.this.fLeftLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
            this.add((Component)this.fButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
                private Point fSourcePoint;

                private boolean inDraggableArea(Point point) {
                    Point point2 = SwingUtilities.convertPoint(Header.this.fButton.getParent(), Header.this.fButton.getLocation(), (Component)((Object)Header.this));
                    return point.getY() / (double)Header.this.getHeight() <= 0.5 && point.getX() < point2.getX();
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), (Component)((Object)Header.this));
                    if (this.inDraggableArea(point)) {
                        ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(9));
                    } else {
                        ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
                        Header.this.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.fSourcePoint = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), (Component)((Object)Header.this));
                    if (!this.inDraggableArea(this.fSourcePoint)) {
                        this.fSourcePoint = null;
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (this.fSourcePoint != null) {
                        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), (Component)((Object)Header.this));
                        int n = (int)(this.fSourcePoint.getY() - point.getY());
                        DetailViewer.this.resizeViewer(n);
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
            this.fButton.addMouseListener((MouseListener)mouseInputAdapter);
            this.fButton.addMouseMotionListener((MouseMotionListener)mouseInputAdapter);
        }

        public void updateIcon() {
            this.fButton.setIcon(DetailViewer.this.createArrowIcon());
            this.revalidate();
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Color color;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Paint paint = graphics2D.getPaint();
            Color color2 = color = UIManager.getColor("control");
            Color color3 = color;
            if (!MJUtilities.isHighContrast()) {
                color3 = Color.WHITE;
                color2 = ColorUtils.convertToCurrentColorScheme((Color)new Color(240, 240, 242), (Color)color);
            }
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color3, 0.0f, (int)((double)this.getHeight() * 1.5), color2));
            graphics2D.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            if (MJUtilities.isHighContrast()) {
                graphics2D.setColor(Color.WHITE);
            } else {
                graphics2D.setColor(ColorUtils.convertToCurrentColorScheme((Color)new Color(103, 103, 127), (Color)color));
            }
            graphics2D.setPaint(paint);
            graphics2D.setColor(ColorUtils.convertToCurrentColorScheme((Color)new Color(190, 190, 192), (Color)color));
            graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            graphics2D.dispose();
        }

        public MJButton getButton() {
            return this.fButton;
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 21);
        }
    }
}

