/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemFilter;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.mlwidgets.explorer.util.UiFileTransfer;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.util.AsyncReceiver;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ZipFileActionProvider
implements ActionProvider {
    private static final ActionDefinition CREATE_ZIP = new ActionDefinition("createZip", CoreMenuSection.NEW_RENAME_DELETE.getSection(), ExplorerResources.getString("context.zip"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        if (fileSystemEntry == null) {
            return true;
        }
        FileSystemEntry fileSystemEntry2 = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry);
        return fileSystemEntry2.isReal();
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(CREATE_ZIP).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return ZipFileActionProvider.createArchive(actionInput, ".zip");
            }
        });
        actionRegistry.setActionPosition(CREATE_ZIP, actionRegistry.getAction(CoreActionID.RENAME).getDefinition());
    }

    private static Status createArchive(final ActionInput actionInput, String string) {
        final Status status = new Status(ExplorerResources.getString("progress.archive.creating"), true);
        final FileSystem fileSystem = actionInput.getLocation().getSystem();
        final FileLocation fileLocation = ZipFileActionProvider.getDefaultArchive(actionInput, string);
        try {
            FileSystemUtils.withTransaction(fileSystem, new TransactionLogic(){

                @Override
                public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                    fileSystemTransaction.getOutputStream(fileLocation).close();
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UiFileTransfer uiFileTransfer = new UiFileTransfer(actionInput.getComponent(), UiFileTransferType.COPY, fileSystem, fileLocation, ZipFileActionProvider.getRoot(actionInput), ZipFileActionProvider.getSourceFileList(actionInput), new AsyncReceiver<FileLocation>(){

            public boolean receive(FileLocation fileLocation2) {
                return true;
            }

            public void finished() {
                ZipFileActionProvider.finish(actionInput, fileSystem, fileLocation);
                status.markCompleted();
            }
        });
        new Thread(uiFileTransfer).start();
        return status;
    }

    private static void finish(ActionInput actionInput, final FileSystem fileSystem, final FileLocation fileLocation) {
        final FileTable fileTable = ((TableActionInput)actionInput).getTable();
        fileTable.getGroupingModel().waitForPendingTransactions();
        fileTable.continueAfterPendingTransactions(new Runnable(){

            @Override
            public void run() {
                try {
                    fileTable.rename(fileSystem.getEntry(fileLocation));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static List<FileSystemEntry> getSourceFileList(ActionInput actionInput) {
        if (actionInput.getSelection().isEmpty()) {
            return Arrays.asList(actionInput.getLocation());
        }
        return actionInput.getSelection();
    }

    private static FileLocation getRoot(ActionInput actionInput) {
        FileLocation fileLocation = actionInput.getLocation().getLocation();
        return actionInput.getSelection().isEmpty() ? fileLocation.getParent() : fileLocation;
    }

    private static FileLocation getDefaultArchive(ActionInput actionInput, String string) {
        FileLocation fileLocation = actionInput.getLocation().getLocation();
        if (actionInput.getSelection().isEmpty()) {
            FileSystem fileSystem = actionInput.getLocation().getSystem();
            return FileSystemUtils.getNextNamedFile(fileSystem, fileLocation, actionInput.getLocation().getName(), string, false, "", new FileSystemFilter[0]);
        }
        if (actionInput.getSelection().size() == 1) {
            int n;
            String string2 = ((FileSystemEntry)actionInput.getSelection().get(0)).getName();
            if (!((FileSystemEntry)actionInput.getSelection().get(0)).isFolder() && (n = string2.lastIndexOf(46)) >= 0) {
                string2 = string2.substring(0, n);
            }
            FileSystem fileSystem = ((FileSystemEntry)actionInput.getSelection().get(0)).getSystem();
            return FileSystemUtils.getNextNamedFile(fileSystem, fileLocation, string2, string, false, "", new FileSystemFilter[0]);
        }
        return FileSystemUtils.getNextUntitledFile(actionInput.getLocation().getSystem(), fileLocation, string, new FileSystemFilter[0]);
    }
}

