/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.CoreMenuSectionID;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileDetailPanel;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.IOException;

public final class MATFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    private static final ActionDefinition sLoadMatFile = new ActionDefinition("loadMatFile", CoreMenuSection.OPEN.getSection(), ExplorerResources.getString("matmenu.load.simple"));
    private static final ActionDefinition sSaveMatFile = new ActionDefinition("saveMatFile", CoreMenuSection.OPEN.getSection(), ExplorerResources.getString("matmenu.save.simple"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && MLFileUtils.isMatFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, (Object)ExplorerResources.getString("matprovider.typeName"));
        fileDecorators.set(CoreFileDecoration.ICON, (Object)WorkspaceIcon.getDefaultIcon());
        fileDecorators.set(CoreFileDecoration.DETAIL_PANEL, MATFileDetailPanel.class, new Object[]{fileSystemEntry});
    }

    public void configureActions(ActionRegistry actionRegistry) {
        StatusRunnable<ActionInput> statusRunnable = new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    try {
                        FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                        MATFileUtils.load(new File(fileSystemEntry2.getLocation().toString()));
                    }
                    catch (IOException iOException) {}
                }
                return Status.COMPLETED;
            }
        };
        actionRegistry.getAction(CoreActionID.OPEN).setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)statusRunnable);
        actionRegistry.defineAction(sLoadMatFile).setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)statusRunnable);
        ActionConfiguration actionConfiguration = actionRegistry.defineAction(sSaveMatFile);
        actionConfiguration.setEnabled((Predicate)ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS);
        actionConfiguration.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                MATFileUtils.save(actionInput.getComponent(), new File(((FileSystemEntry)actionInput.getSelection().get(0)).getLocation().toString()));
                return Status.COMPLETED;
            }
        });
        actionRegistry.setActionPosition(sLoadMatFile, actionRegistry.getAction(CoreActionID.OPEN).getDefinition());
        actionRegistry.getAction(CoreActionID.OPEN).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.IMPORT_DATA).setSection(actionRegistry.getMenuSection(CoreMenuSectionID.OPEN));
        actionRegistry.setActionPosition(sLoadMatFile, actionRegistry.getAction(CoreActionID.IMPORT_DATA).getDefinition());
        actionRegistry.setActionPosition(actionRegistry.getAction(CoreActionID.IMPORT_DATA).getDefinition(), sSaveMatFile);
    }
}

