/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.PathModel;
import com.mathworks.mlwidgets.explorer.model.actions.DocumentActionUtils;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.util.MLPathUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;

public enum ActionPredicates implements Predicate<ActionInput>
{
    NONEMPTY_SELECTION{

        @Override
        public boolean accept(ActionInput actionInput) {
            return !actionInput.getSelection().isEmpty();
        }
    }
    ,
    EMPTY_SELECTION{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput.getSelection().isEmpty();
        }
    }
    ,
    SINGLE_SELECTION{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput.getSelection().size() == 1;
        }
    }
    ,
    NOT_X_WINDOWS{

        @Override
        public boolean accept(ActionInput actionInput) {
            return !PlatformInfo.isXWindows();
        }
    }
    ,
    HAS_PREVIOUS_LOCATION{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput instanceof TableActionInput && ((TableActionInput)actionInput).getLastLocation() != null;
        }
    }
    ,
    HAS_NEXT_LOCATION{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput instanceof TableActionInput && ((TableActionInput)actionInput).getNextLocation() != null;
        }
    }
    ,
    CAN_CUT{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput instanceof TableActionInput && ((TableActionInput)actionInput).canCut();
        }
    }
    ,
    CAN_COPY{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput instanceof TableActionInput && ((TableActionInput)actionInput).canCopy();
        }
    }
    ,
    CAN_PASTE{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput instanceof TableActionInput && ((TableActionInput)actionInput).canPaste();
        }
    }
    ,
    FILE_EXCHANGE_AVAILABLE{

        @Override
        public boolean accept(ActionInput actionInput) {
            return DocumentActionUtils.isFileExchangeAvailable();
        }
    }
    ,
    IN_SEARCH_MODE{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput.isSearching();
        }
    }
    ,
    NOT_SEARCH_MODE{

        @Override
        public boolean accept(ActionInput actionInput) {
            return !actionInput.isSearching();
        }
    }
    ,
    ANY_DIRECTORIES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry.isFolder();
        }
    }
    ,
    ALL_DIRECTORIES_SELECTED(PredicateType.IF_ALL){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry.isFolder();
        }
    }
    ,
    NOT_ALL_DIRECTORIES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return !fileSystemEntry.isFolder();
        }
    }
    ,
    NO_DIRECTORIES(PredicateType.IF_NONE){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry.isFolder();
        }
    }
    ,
    ALL_REAL_FILE_SYSTEM_LOCATIONS(PredicateType.IF_NONE){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return !fileSystemEntry.isReal();
        }
    }
    ,
    ANY_NON_PRIVATE_DIRECTORIES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry.isFolder() && fileSystemEntry.getName() != null && !MLPathUtils.isPrivate(fileSystemEntry.getName());
        }
    }
    ,
    ANY_NON_PACKAGEORCLASSORPRIVATE_DIRECTORIES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry.isFolder() && fileSystemEntry.getName() != null && !MLPathUtils.isPackageOrClassDirectory(fileSystemEntry) && !ActionPredicates.isPrivate(fileSystemEntry.getLocation());
        }
    }
    ,
    ANY_NON_PRIVATE_FILES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry != null && fileSystemEntry.getLocation().getParent() != null && fileSystemEntry.getLocation().getParent().getName() != null && !MLPathUtils.isPrivate(fileSystemEntry.getLocation().getParent().getName());
        }
    }
    ,
    ANY_NON_PATH_ITEMS_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry != null && !MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), fileSystemEntry, false);
        }
    }
    ,
    ANY_PATH_ITEMS_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry != null && MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), fileSystemEntry, false);
        }
    }
    ,
    ANY_FOLDER_PATH_ITEMS_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return fileSystemEntry != null && fileSystemEntry.isFolder() && MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), fileSystemEntry, false);
        }
    }
    ,
    ANY_PATH_ADDABLE_DIRECTORIES_SELECTED(PredicateType.IF_ANY){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            if (fileSystemEntry == null || !fileSystemEntry.isFolder() || MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), fileSystemEntry, false)) {
                return false;
            }
            FileLocation fileLocation = MLPathUtils.getAddableFolder(MatlabPathModel.getInstance(), fileSystemEntry);
            return fileLocation != null && fileLocation.equals((Object)fileSystemEntry.getLocation());
        }
    }
    ,
    IN_PATH_ADDABLE_DIRECTORY{

        @Override
        public boolean accept(ActionInput actionInput) {
            if (actionInput.getLocation() == null) {
                return false;
            }
            FileSystemEntry fileSystemEntry = actionInput.getLocation();
            if (MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), fileSystemEntry, false)) {
                return false;
            }
            FileLocation fileLocation = MLPathUtils.getAddableFolder(MatlabPathModel.getInstance(), fileSystemEntry);
            return fileLocation != null && fileLocation.equals((Object)fileSystemEntry.getLocation());
        }
    }
    ,
    NOT_IN_PRIVATE_DIRECTORY{

        @Override
        public boolean accept(ActionInput actionInput) {
            return actionInput.getLocation() != null && !ActionPredicates.isPrivate(actionInput.getLocation().getLocation());
        }
    }
    ,
    ALL_FIGURE_FILES(PredicateType.IF_ALL){

        @Override
        public boolean accept(FileSystemEntry fileSystemEntry) {
            return MLFileUtils.isFigFile((String)fileSystemEntry.getName());
        }
    }
    ,
    HAS_PARENT_LOCATION{

        @Override
        public boolean accept(ActionInput actionInput) {
            if (actionInput.getLocation() == null) {
                return false;
            }
            FileLocation fileLocation = actionInput.getLocation().getLocation();
            return fileLocation.getParent() != null && fileLocation.getParent().getName().length() > 0;
        }
    }
    ,
    ANYTHING_EXPANDED{

        @Override
        public boolean accept(ActionInput actionInput) {
            return ((TableActionInput)actionInput).hasAnythingExpanded();
        }
    }
    ,
    NOT_ALL_IN_CURRENT_DIRECTORY{

        @Override
        public boolean accept(ActionInput actionInput) {
            if (actionInput.getLocation() == null) {
                return false;
            }
            FileLocation fileLocation = actionInput.getLocation().getLocation();
            for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                if (fileSystemEntry.getLocation().getParent() != null && fileSystemEntry.getLocation().getParent().equals((Object)fileLocation)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    IN_PATH_DIRECTORY{

        @Override
        public boolean accept(ActionInput actionInput) {
            return MLPathUtils.isOnPath((PathModel)MatlabPathModel.getInstance(), actionInput.getLocation(), false);
        }
    };

    private final PredicateType fType;

    private ActionPredicates() {
        this(PredicateType.GENERIC);
    }

    private ActionPredicates(PredicateType predicateType) {
        this.fType = predicateType;
    }

    public boolean accept(ActionInput actionInput) {
        switch (this.fType) {
            case GENERIC: {
                throw new IllegalStateException("accept(ActionInput) should be overridden in " + (Object)((Object)this));
            }
            case IF_ANY: 
            case IF_NONE: {
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    if (!this.accept(fileSystemEntry)) continue;
                    return this.fType == PredicateType.IF_ANY;
                }
                return this.fType == PredicateType.IF_NONE;
            }
            case IF_ALL: {
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    if (this.accept(fileSystemEntry)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Unhandled predicate type in " + (Object)((Object)this) + ": " + (Object)((Object)this.fType));
    }

    protected boolean accept(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public static Predicate<ActionInput> either(final Predicate<ActionInput> ... predicateArray) {
        return new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                for (Predicate predicate : predicateArray) {
                    if (!predicate.accept((Object)actionInput)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<ActionInput> and(final Predicate<ActionInput> ... predicateArray) {
        return new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                for (Predicate predicate : predicateArray) {
                    if (predicate.accept((Object)actionInput)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static boolean isPrivate(FileLocation fileLocation) {
        return MLPathUtils.isPrivate(fileLocation.getName());
    }

    static enum PredicateType {
        GENERIC,
        IF_ANY,
        IF_NONE,
        IF_ALL;

    }
}

