/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContext;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContributor;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class DynamicMenuUtils {
    private DynamicMenuUtils() {
    }

    public static <T> void showPopupMenu(final JComponent jComponent, final Point point, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PopupMenu popupMenu = new PopupMenu();
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(popupMenu);
                if (popupMenu.getComponent().getComponentCount() > 0) {
                    popupMenu.getComponent().setCleanupUponClose(true);
                    popupMenu.getComponent().show((Component)jComponent, (int)point.getX(), (int)point.getY());
                }
            }
        });
    }

    public static <T> MJPopupMenu createPopupMenu(List<DynamicMenuContributor<T>> list, T[] TArray, Comparator<MenuSection> comparator, MenuSection ... menuSectionArray) {
        PopupMenu popupMenu = new PopupMenu();
        Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
        context.createMenu(popupMenu);
        return popupMenu.getComponent();
    }

    public static <T> void updateMenu(final MJMenu mJMenu, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                mJMenu.removeAll();
                RegularMenu regularMenu = new RegularMenu(mJMenu);
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(regularMenu);
            }
        });
    }

    public static <T> void updateMenu(final JPopupMenu jPopupMenu, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                jPopupMenu.removeAll();
                PopupMenu popupMenu = new PopupMenu(jPopupMenu);
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(popupMenu);
            }
        });
    }

    public static <T> DynamicMenuContext<T> createMenuContext(List<DynamicMenuContributor<T>> list, T[] TArray, Comparator<MenuSection> comparator, MenuSection ... menuSectionArray) {
        Context<T> context = new Context<T>(TArray, comparator, menuSectionArray);
        for (DynamicMenuContributor<T> dynamicMenuContributor : list) {
            dynamicMenuContributor.contribute(context);
        }
        return context;
    }

    public static <T> DynamicMenuContext<T> updateActionMap(final JComponent jComponent, final DynamicMenuContext<T> dynamicMenuContext, List<DynamicMenuContributor<T>> list, T[] TArray, MenuSection ... menuSectionArray) {
        final DynamicMenuContext<T> dynamicMenuContext2 = DynamicMenuUtils.createMenuContext(list, TArray, null, menuSectionArray);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string;
                KeyStroke keyStroke;
                Action action;
                int n;
                Action[] actionArray;
                if (dynamicMenuContext != null) {
                    actionArray = dynamicMenuContext.getAllActions();
                    for (n = 0; n < actionArray.length; ++n) {
                        action = actionArray[n];
                        keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                        if (keyStroke == null) continue;
                        string = n + ":" + action.getValue("Name");
                        jComponent.getInputMap().remove(keyStroke);
                        jComponent.getActionMap().remove(string);
                    }
                }
                actionArray = dynamicMenuContext2.getAllActions();
                for (n = 0; n < actionArray.length; ++n) {
                    action = actionArray[n];
                    keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                    if (keyStroke == null) continue;
                    string = n + ":" + action.getValue("Name");
                    jComponent.getInputMap().put(keyStroke, string);
                    jComponent.getActionMap().put(string, action);
                }
            }
        });
        return dynamicMenuContext2;
    }

    private static class Context<T>
    implements DynamicMenuContext<T> {
        private final T[] fContext;
        private final Comparator<MenuSection> fComparator;
        private final MenuSection[] fAllowedSections;
        private final Map<MenuSection, List<Object>> fActions;
        private final List<Action> fAllActions;

        Context(T[] TArray, Comparator<MenuSection> comparator, MenuSection[] menuSectionArray) {
            this.fContext = TArray;
            this.fComparator = comparator;
            this.fAllowedSections = menuSectionArray;
            this.fActions = new HashMap<MenuSection, List<Object>>();
            this.fAllActions = new LinkedList<Action>();
        }

        private void add(MenuSection menuSection, Object object) {
            if (!this.allowed(menuSection)) {
                return;
            }
            List<Object> list = this.fActions.get(menuSection);
            if (list == null) {
                list = new LinkedList<Object>();
                this.fActions.put(menuSection, list);
            }
            if (object instanceof Action) {
                this.fAllActions.add((Action)object);
            }
            list.add(object);
        }

        @Override
        public void addAction(MenuSection menuSection, Action action) {
            if (!this.allowed(menuSection)) {
                return;
            }
            this.add(menuSection, action);
        }

        @Override
        public void addSection(MenuSection menuSection) {
            if (!this.allowed(menuSection) || menuSection.getParent() == null) {
                return;
            }
            this.add(menuSection.getParent(), menuSection);
        }

        @Override
        public void addComponent(MenuSection menuSection, Component component) {
            if (!this.allowed(menuSection)) {
                return;
            }
            this.add(menuSection, component);
        }

        @Override
        public void addActionIfEnabled(MenuSection menuSection, Action action) {
            if (this.allowed(menuSection) && action.isEnabled()) {
                this.addAction(menuSection, action);
            }
        }

        @Override
        public T[] getContext() {
            return this.fContext == null ? null : (Object[])this.fContext.clone();
        }

        @Override
        public Action[] getAllActions() {
            return this.fAllActions.toArray(new Action[this.fAllActions.size()]);
        }

        private boolean allowed(MenuSection menuSection) {
            return this.fAllowedSections == null || this.fAllowedSections.length == 0 || Arrays.asList(this.fAllowedSections).contains(menuSection);
        }

        public void createMenu(Menu menu) {
            this.createMenu(null, menu);
        }

        private void createMenu(MenuSection menuSection, Menu menu) {
            List<MenuSection> list = this.getChildrenInOrder(menuSection);
            Iterator<MenuSection> iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = menu.getCount();
                MenuSection menuSection2 = iterator.next();
                for (Object object : this.getAllItems(menuSection2)) {
                    this.add(object, menu);
                }
                if (n == menu.getCount()) {
                    int n2 = menu.getCount() - 1;
                    if (n2 < 0) continue;
                    menu.remove(n2);
                    continue;
                }
                if (!iterator.hasNext()) continue;
                menu.addSeparator();
            }
        }

        private void add(Object object, Menu menu) {
            if (object instanceof MenuSection) {
                List<Object> list;
                MenuSection menuSection = (MenuSection)object;
                if (menuSection.isSubMenuAllowed() && !(list = this.getAllItems(menuSection)).isEmpty()) {
                    if (!menuSection.isSubMenuAllowed() || list.size() == 1 && !menuSection.isSubMenuForced()) {
                        for (Object object2 : list) {
                            this.add(object2, menu);
                        }
                    } else {
                        RegularMenu regularMenu = new RegularMenu(menuSection.getName());
                        for (Object object3 : this.fActions.get(menuSection)) {
                            this.add(object3, regularMenu);
                        }
                        menu.add(regularMenu.getComponent());
                    }
                }
            } else {
                menu.add(object);
            }
        }

        private List<MenuSection> getChildrenInOrder(MenuSection menuSection) {
            Vector<MenuSection> vector = new Vector<MenuSection>();
            for (MenuSection menuSection2 : this.fActions.keySet()) {
                if (menuSection2.getParent() != menuSection) continue;
                vector.add(menuSection2);
            }
            Collections.sort(vector, this.fComparator);
            return vector;
        }

        private List<Object> getAllItems(MenuSection menuSection) {
            Vector<Object> vector = new Vector<Object>();
            List<Object> list = this.fActions.get(menuSection);
            if (list != null) {
                for (Object object : list) {
                    vector.add(object);
                }
            }
            for (MenuSection menuSection2 : this.getChildrenInOrder(menuSection)) {
                if (vector.indexOf(menuSection2) >= 0) continue;
                vector.add(menuSection2);
            }
            return vector;
        }
    }

    private static class PopupMenu
    implements Menu {
        private final JPopupMenu fComponent;

        PopupMenu() {
            this((JPopupMenu)new MJPopupMenu());
        }

        PopupMenu(JPopupMenu jPopupMenu) {
            this.fComponent = jPopupMenu;
        }

        @Override
        public void add(Object object) {
            if (object instanceof Action) {
                this.fComponent.add((Action)object);
            } else if (object instanceof Component) {
                this.fComponent.add((Component)object);
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getCount() {
            return this.fComponent.getComponentCount();
        }

        @Override
        public void addSeparator() {
            this.fComponent.addSeparator();
        }

        @Override
        public void remove(int n) {
            this.fComponent.remove(n);
        }

        public MJPopupMenu getComponent() {
            return (MJPopupMenu)this.fComponent;
        }
    }

    private static class RegularMenu
    implements Menu {
        private final MJMenu fComponent;

        RegularMenu(MJMenu mJMenu) {
            this.fComponent = mJMenu;
        }

        RegularMenu(String string) {
            this.fComponent = new MJMenu(string);
        }

        @Override
        public void add(Object object) {
            if (object instanceof Action) {
                this.fComponent.add((JMenuItem)new MJMenuItem((Action)object));
            } else if (object instanceof Component) {
                this.fComponent.add((Component)object);
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getCount() {
            return this.fComponent.getMenuComponentCount();
        }

        @Override
        public void addSeparator() {
            this.fComponent.addSeparator();
        }

        @Override
        public void remove(int n) {
            this.fComponent.remove(n);
        }

        public MJMenu getComponent() {
            return this.fComponent;
        }
    }

    private static interface Menu {
        public void add(Object var1);

        public void addSeparator();

        public void remove(int var1);

        public JComponent getComponent();

        public int getCount();
    }
}

