/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.Converter;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public final class LocationColumn {
    private final GroupingMode<FileSystemEntry> fGroupingMode = new GroupingMode<FileSystemEntry>(){

        public String getKey() {
            return LocationColumn.KEY;
        }

        public String getName() {
            return NAME;
        }

        public List<Group<FileSystemEntry>> getGroups(List<FileSystemEntry> list) {
            TreeMap<String, Group> treeMap = new TreeMap<String, Group>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
            for (FileSystemEntry fileSystemEntry : list) {
                String string = LocationColumn.getAbsoluteLocation(fileSystemEntry);
                String string2 = LocationColumn.getDisplayLocation(fileSystemEntry);
                Group group = (Group)treeMap.get(string);
                if (group == null) {
                    group = new Group(string, string2);
                    treeMap.put(string, group);
                }
                group.addItem((Object)fileSystemEntry);
            }
            return new ArrayList<Group<FileSystemEntry>>(treeMap.values());
        }
    };
    private final GroupingTableColumn<FileSystemEntry> fColumn = new GroupingTableColumn("location", NAME, true, String.class, null, (Converter)new Converter<FileSystemEntry, String>(){

        public String convert(FileSystemEntry fileSystemEntry) {
            return LocationColumn.getDisplayLocation(fileSystemEntry);
        }
    }, null, UiFileSystemUtils.separateFoldersFromFiles(UiFileSystemUtils.sortByNameTieBreaker(new Comparator<FileSystemEntry>(){

        @Override
        public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
            return LocationColumn.getAbsoluteLocation(fileSystemEntry).compareToIgnoreCase(LocationColumn.getAbsoluteLocation(fileSystemEntry2));
        }
    })), new GroupingMode[]{this.fGroupingMode});
    private static final String KEY = "location";
    private static final String NAME = ExplorerResources.getString("table.location");

    public GroupingTableColumn<FileSystemEntry> getColumn() {
        return this.fColumn;
    }

    public GroupingMode<FileSystemEntry> getGroupingMode() {
        return this.fGroupingMode;
    }

    private static String getAbsoluteLocation(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry.getLocation().getParent().toString();
    }

    private static String getDisplayLocation(FileSystemEntry fileSystemEntry) {
        FileLocation fileLocation = fileSystemEntry.getLocation().getParent();
        StringBuilder stringBuilder = new StringBuilder(fileLocation.getName());
        if (fileLocation.getParent() != null) {
            stringBuilder.append(" (");
            stringBuilder.append(fileLocation.getParent().toString());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

