/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import java.util.Arrays;
import java.util.List;

public final class SizeGroupingMode
implements GroupingMode<FileSystemEntry> {
    public String getKey() {
        return "size";
    }

    public String getName() {
        return ExplorerResources.getString("table.size");
    }

    public List<Group<FileSystemEntry>> getGroups(List<FileSystemEntry> list) {
        Group group = new Group("small", ExplorerResources.getString("table.size.small"));
        Group group2 = new Group("medium", ExplorerResources.getString("table.size.medium"));
        Group group3 = new Group("large", ExplorerResources.getString("table.size.large"));
        for (FileSystemEntry fileSystemEntry : list) {
            FileSystemEntry fileSystemEntry2 = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry);
            if (fileSystemEntry2.getSize() < 8192L) {
                group.addItem((Object)fileSystemEntry);
                continue;
            }
            if (fileSystemEntry2.getSize() < 262144L) {
                group2.addItem((Object)fileSystemEntry);
                continue;
            }
            group3.addItem((Object)fileSystemEntry);
        }
        return GroupingTableUtils.getNonEmptyGroups(Arrays.asList(group, group2, group3));
    }
}

