/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.treefs;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.treefs.TreeModelFileSystem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Converter;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeModelAdapter {
    private final JTree fTree;
    private final TreeModel fModel;
    private final TreeModelFileSystem fSystem;
    private final NavigationContext fContext;
    private final TreeSelectionListener fSelectionListener;
    private final ExtensionRegistry fExtensions;
    private boolean fReactingToSelection;

    public TreeModelAdapter(TreeModel treeModel, JTree jTree, final Converter<TreePath, Icon> converter, final Converter<FileLocation, String> converter2) {
        this.fModel = treeModel;
        this.fTree = jTree;
        this.fSystem = new TreeModelFileSystem(treeModel);
        this.fExtensions = new ExtensionRegistry();
        this.fExtensions.addInfoProvider(new FileInfoProvider(){

            public boolean isApplicable(FileSystemEntry fileSystemEntry) {
                return true;
            }

            public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
                TreePath treePath = TreeModelAdapter.this.fSystem.getTreePath(fileSystemEntry.getLocation());
                if (treePath != null) {
                    fileDecorators.set(CoreFileDecoration.ICON, converter.convert((Object)treePath));
                }
                if (converter2 != null) {
                    fileDecorators.set(CoreFileDecoration.DISPLAY_NAME, converter2.convert((Object)fileSystemEntry.getLocation()));
                }
            }
        });
        FileLocation fileLocation = this.fSystem.getLocationByNode((TreeNode)this.fModel.getRoot());
        if (this.fTree != null && this.fTree.getSelectionPath() != null) {
            fileLocation = this.fSystem.getLocationByPath(this.fTree.getSelectionPath());
        }
        try {
            this.fContext = new NavigationContext(this.fSystem, false, this.fExtensions, fileLocation);
        }
        catch (InvalidLocationException invalidLocationException) {
            throw new IllegalStateException(invalidLocationException);
        }
        if (this.fTree != null) {
            this.fSelectionListener = new SelectionListener();
            this.fTree.addTreeSelectionListener(this.fSelectionListener);
            this.fContext.addNavigationListener(new NavigationListener(){

                @Override
                public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                    TreePath treePath;
                    if (!TreeModelAdapter.this.fReactingToSelection && (treePath = TreeModelAdapter.this.fSystem.getTreePath(fileLocation2)) != null) {
                        if (treePath.getParentPath() != null) {
                            TreeModelAdapter.this.fTree.expandPath(treePath.getParentPath());
                        }
                        TreeModelAdapter.this.fTree.setSelectionPath(treePath);
                    }
                }

                @Override
                public void searchStarted(SearchCriteria searchCriteria) {
                }

                @Override
                public void searchEnded() {
                }
            });
        } else {
            this.fSelectionListener = null;
        }
    }

    public TreePath getCurrentPath() {
        FileLocation fileLocation = this.fContext.getLocation();
        return this.fSystem.getTreePath(fileLocation);
    }

    public NavigationContext getNavigationContext() {
        return this.fContext;
    }

    public TreeModelFileSystem getSystem() {
        return this.fSystem;
    }

    public ExtensionRegistry getExtensions() {
        return this.fExtensions;
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TreeModelAdapter.this.fSelectionListener != null) {
                    TreeModelAdapter.this.fTree.removeTreeSelectionListener(TreeModelAdapter.this.fSelectionListener);
                }
                TreeModelAdapter.this.fContext.getList().close();
            }
        });
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                TreeModelAdapter.this.fReactingToSelection = true;
                if (TreeModelAdapter.this.fTree.getSelectionPath() != null) {
                    TreeModelAdapter.this.fContext.setLocation(TreeModelAdapter.this.fSystem.getLocationByPath(TreeModelAdapter.this.fTree.getSelectionPath()));
                }
                TreeModelAdapter.this.fReactingToSelection = false;
            }
            catch (InvalidLocationException invalidLocationException) {
                throw new IllegalStateException(invalidLocationException);
            }
        }
    }
}

