/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonState;
import com.mathworks.mlwidgets.explorer.widgets.address.PaintingUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

final class AddressBarButton {
    private final AddressBar fAddressBar;
    private final MJPanel fComponent;
    private final MJLabel fMeasureLabel;
    private final Icon fIcon;
    private final String fText;
    private final JComponent fActiveComponent;
    private final JComponent fInactiveComponent;
    private final PropertyChangeSupport fPropertySupport;
    private AddressBarButtonState fState;
    public static final String STATE_PROPERTY = "state";

    AddressBarButton(AddressBar addressBar, Icon icon, Runnable runnable) {
        this(addressBar, null, icon, icon, true, null, runnable, null, null);
    }

    AddressBarButton(AddressBar addressBar, Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        this(addressBar, null, icon, icon, true, null, null, null, popupMenuCustomizer);
    }

    AddressBarButton(AddressBar addressBar, Icon icon, ParameterRunnable<Boolean> parameterRunnable) {
        this(addressBar, null, icon, icon, true, null, null, parameterRunnable, null);
    }

    AddressBarButton(AddressBar addressBar, Icon icon, Component component, boolean bl, PopupMenuCustomizer popupMenuCustomizer) {
        this(addressBar, null, icon, icon, bl, component, null, null, popupMenuCustomizer);
    }

    AddressBarButton(AddressBar addressBar, String string, Icon icon, Icon icon2, boolean bl, Runnable runnable, PopupMenuCustomizer popupMenuCustomizer) {
        this(addressBar, string, icon, icon2, bl, null, runnable, null, popupMenuCustomizer);
    }

    private AddressBarButton(AddressBar addressBar, String string, Icon icon, Icon icon2, boolean bl, Component component, Runnable runnable, ParameterRunnable<Boolean> parameterRunnable, PopupMenuCustomizer popupMenuCustomizer) {
        this.fAddressBar = addressBar;
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fMeasureLabel = new MJLabel();
        this.fIcon = icon2;
        this.fText = string;
        this.fComponent = new MJPanel(new BorderLayout(0, 0)){

            public Dimension getMinimumSize() {
                FontMetrics fontMetrics = this.getFontMetrics(AddressBarButton.this.fMeasureLabel.getFont());
                int n = AddressBarButton.this.fIcon != null && AddressBarButton.this.fText != null ? fontMetrics.stringWidth("M...") + AddressBarButton.this.fIcon.getIconWidth() + 4 : (int)super.getMinimumSize().getWidth();
                return new Dimension(n, (int)super.getMinimumSize().getHeight());
            }
        };
        this.fInactiveComponent = this.buildInactiveComponent();
        this.fActiveComponent = this.buildActiveComponent(icon, icon2, runnable, parameterRunnable, popupMenuCustomizer, bl, this.fInactiveComponent, component);
        for (Component component2 : this.getAllComponents()) {
            component2.setBackground(addressBar.getBackground());
        }
        this.setState(AddressBarButtonState.NORMAL);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public Component[] getAllComponents() {
        Vector<Component> vector = new Vector<Component>();
        AddressBarButton.addAllRecursively(this.fInactiveComponent, vector);
        AddressBarButton.addAllRecursively(this.fActiveComponent, vector);
        return vector.toArray(new Component[vector.size()]);
    }

    private static void addAllRecursively(JComponent jComponent, List<Component> list) {
        for (Component component : jComponent.getComponents()) {
            list.add(component);
            AddressBarButton.addAllRecursively((JComponent)component, list);
        }
    }

    public AddressBarButtonState getState() {
        return this.fState;
    }

    void setState(AddressBarButtonState addressBarButtonState) {
        AddressBarButtonState addressBarButtonState2 = this.fState;
        this.fState = addressBarButtonState;
        if (addressBarButtonState2 == null || !addressBarButtonState2.equals((Object)addressBarButtonState)) {
            this.fComponent.removeAll();
            if (addressBarButtonState.equals((Object)AddressBarButtonState.NORMAL)) {
                this.fComponent.add((Component)this.fInactiveComponent, (Object)"Center");
            } else {
                this.fComponent.add((Component)this.fActiveComponent, (Object)"Center");
            }
        }
        this.fPropertySupport.firePropertyChange(STATE_PROPERTY, (Object)addressBarButtonState2, (Object)this.getState());
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private JComponent buildInactiveComponent() {
        StateComponent stateComponent = new StateComponent();
        if (this.fText != null) {
            MJLabel mJLabel = new MJLabel(this.fText){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth() + 6, (int)super.getPreferredSize().getHeight());
                }
            };
            mJLabel.setText(this.fText);
            mJLabel.setHorizontalAlignment(0);
            mJLabel.setVerticalAlignment(0);
            stateComponent.add((Component)mJLabel, "Center");
            if (this.fIcon != null) {
                MJLabel mJLabel2 = new MJLabel(this.fIcon);
                mJLabel2.setHorizontalAlignment(0);
                stateComponent.add((Component)mJLabel2, "East");
            }
        } else if (this.fIcon != null) {
            MJLabel mJLabel = new MJLabel(this.fIcon);
            mJLabel.setHorizontalAlignment(0);
            stateComponent.add((Component)mJLabel, "Center");
        }
        stateComponent.addMouseListener(new HoverHandler());
        stateComponent.addMouseMotionListener(new HoverHandler());
        return stateComponent;
    }

    private JComponent buildActiveComponent(final Icon icon, final Icon icon2, Runnable runnable, ParameterRunnable<Boolean> parameterRunnable, PopupMenuCustomizer popupMenuCustomizer, final boolean bl, final JComponent jComponent, Component component) {
        StateComponent stateComponent = new StateComponent(){

            @Override
            public Dimension getPreferredSize() {
                return jComponent.getPreferredSize();
            }

            public void paintComponent(Graphics graphics) {
                PaintingUtils.paintHoveredButton(graphics, (JComponent)((Object)this), icon2, icon, AddressBarButton.this.fText, AddressBarButton.this.fMeasureLabel.getFont(), AddressBarButton.this.getState() == AddressBarButtonState.PRESSED || AddressBarButton.this.getState() == AddressBarButtonState.LOCKED_DOWN, bl);
            }
        };
        if (popupMenuCustomizer != null) {
            stateComponent.addMouseListener(new MenuHandler(popupMenuCustomizer, (Component)(component == null ? this.fComponent : component), component == null && this.fIcon != null ? (int)stateComponent.getPreferredSize().getWidth() - this.fIcon.getIconWidth() : 0));
        }
        if (runnable != null) {
            stateComponent.addMouseListener(new ActionHandler(runnable));
        } else if (parameterRunnable != null) {
            stateComponent.addMouseListener(new ToggleHandler(parameterRunnable));
        }
        stateComponent.addMouseListener(new HoverHandler());
        stateComponent.addMouseMotionListener(new HoverHandler());
        return stateComponent;
    }

    private Rectangle getIconRect() {
        return new Rectangle(this.fIcon == null ? 0 : this.fComponent.getWidth() - this.fIcon.getIconWidth(), 0, this.fIcon == null ? 0 : this.fIcon.getIconWidth(), this.fComponent.getHeight());
    }

    private class MenuHandler
    extends MouseAdapter {
        private final PopupMenuCustomizer iCustomizer;
        private final Component iAnchor;
        private final int iAnchorX;
        private MJPopupMenu iMenu;

        MenuHandler(PopupMenuCustomizer popupMenuCustomizer, Component component, int n) {
            this.iCustomizer = popupMenuCustomizer;
            this.iAnchor = component;
            this.iAnchorX = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.iMenu != null) {
                if (AddressBarButton.this.fAddressBar.getCurrentMenu() == this.iMenu) {
                    AddressBarButton.this.fAddressBar.setCurrentMenu(null);
                }
                this.iMenu.setVisible(false);
                this.iMenu = null;
                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
            } else if (AddressBarButton.this.getIconRect().contains(mouseEvent.getPoint())) {
                AddressBarButton.this.setState(AddressBarButtonState.LOCKED_DOWN);
                this.iMenu = new MJPopupMenu();
                AddressBarButton.this.fAddressBar.setCurrentMenu((JPopupMenu)this.iMenu);
                this.iCustomizer.customize((JPopupMenu)this.iMenu);
                this.iMenu.setName("AddressSelectionMenu");
                this.iMenu.show(this.iAnchor, this.iAnchorX, this.iAnchor.getHeight());
                this.iMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MenuHandler.this.iMenu = null;
                                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
                            }
                        });
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }
        }
    }

    private class ToggleHandler
    extends MouseAdapter {
        private final ParameterRunnable<Boolean> fToggleCode;

        ToggleHandler(ParameterRunnable<Boolean> parameterRunnable) {
            this.fToggleCode = parameterRunnable;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.LOCKED_DOWN);
                this.fToggleCode.run((Object)true);
            } else {
                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
                this.fToggleCode.run((Object)false);
            }
        }
    }

    private class ActionHandler
    extends MouseAdapter {
        private final Runnable fActionCode;

        ActionHandler(Runnable runnable) {
            this.fActionCode = runnable;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.PRESSED);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
                if (AddressBarButton.this.fText == null || !AddressBarButton.this.getIconRect().contains(mouseEvent.getPoint())) {
                    this.fActionCode.run();
                }
            }
        }
    }

    private class HoverHandler
    extends MouseAdapter {
        private HoverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.NORMAL);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AddressBarButton.this.getState() != AddressBarButtonState.LOCKED_DOWN) {
                AddressBarButton.this.setState(AddressBarButtonState.HOVERED);
            }
        }
    }

    private class StateComponent
    extends MJPanel {
        private final int fPreferredHeight;

        StateComponent() {
            super((LayoutManager)new BorderLayout(0, 0));
            this.setBackground(AddressBarButton.this.fAddressBar.getBackground());
            int n = 6;
            if (PlatformInfo.isMacintosh()) {
                n = 4;
            } else if (PlatformInfo.isWindows() && !PlatformInfo.isWindowsXP()) {
                n = 4;
            }
            this.fPreferredHeight = (int)(new MJLabel("Aj").getPreferredSize().getHeight() + (double)n);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)super.getPreferredSize().getWidth(), this.fPreferredHeight);
        }
    }
}

