/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoParser;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosDataHolder;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.HelpDataObserver;
import com.mathworks.mlwidgets.help.HelpDataWorker;
import com.mathworks.mlwidgets.help.HelpDataWorkerStrategy;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.FileUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DemosData {
    public static final String ML_IMAGE_PATH = "$toolbox/matlab/icons/matlabicon.gif";
    public static final String SL_IMAGE_PATH = "$toolbox/simulink/simulink/simulinkicon.gif";
    public static final String LINKS_IMAGE_PATH = "$toolbox/matlab/icons/linkproduct.png";
    public static final String INTRO_IMAGE_PATH = "$toolbox/matlab/icons/greencircleicon.gif";
    private static final String MATLAB_NAME = "matlab";
    private static final String SIMULINK_NAME = "simulink";
    private static final String TOOLBOXES_NAME = "toolboxes";
    private static final String BLOCKSETS_NAME = "blocksets";
    private static final String LINKS_NAME = "links and targets";
    private static final String NO_CATEGORY_NAME = "default";
    private static DocumentBuilder sDocBuilder = null;
    private static DemosXmlFileProvider sXmlFileProvider = null;
    private static final HelpDataWorker<DemosDataHolder> sWorker = new HelpDataWorker();
    private static DemosDataHolder sCurrentDemosData = null;
    private static List<DemosDataListener> sListeners = null;

    private DemosData() {
    }

    public static DemoTreeItem findProduct(String string, String string2) {
        DemosDataHolder demosDataHolder;
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
            string2 = MATLAB_NAME;
        }
        if ((demosDataHolder = DemosData.getCurrentDemosData()) != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getDemoTreeItem(string, string2);
        }
        return null;
    }

    public static DemoTreeItem getItemById(String string) {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getDemoTreeItemById(string);
        }
        return null;
    }

    public static synchronized void addDemosDataListener(DemosDataListener demosDataListener) {
        DemosData.addDemosDataListener(demosDataListener, false);
    }

    public static synchronized void addDemosDataListener(DemosDataListener demosDataListener, boolean bl) {
        if (sListeners == null) {
            sListeners = new ArrayList<DemosDataListener>();
        }
        sListeners.add(demosDataListener);
        if (bl) {
            if (DemosData.isPopulated()) {
                demosDataListener.demosPopulated();
            } else {
                demosDataListener.demosCleared();
            }
        }
    }

    public static void reload() {
        DemosData.repopulate(true);
    }

    public static List<DemoTreeItem> getUserDemos() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getUserDemos();
        }
        return null;
    }

    public static List<String> getDemosXmlFiles() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return Collections.unmodifiableList(demosDataHolder.getDemosXmlFiles());
        }
        return null;
    }

    public static synchronized void removeDemosDataListener(DemosDataListener demosDataListener) {
        if (sListeners != null) {
            sListeners.remove(demosDataListener);
        }
    }

    private static synchronized List<DemosDataListener> getDemosDataListeners() {
        return sListeners;
    }

    private static void initialize() {
        List<String> list = DemosData.findDemosXmlFiles();
        if (list != null) {
            DemosData.populate(list);
        }
    }

    private static synchronized void repopulate(boolean bl) {
        List<String> list = DemosData.findDemosXmlFiles();
        if (list != null && (bl || DemosData.needsRefresh(list))) {
            DemosData.populate(list);
        }
    }

    static List<String> findDemosXmlFiles() {
        List<String> list = DemosData.getXmlFileProvider().getDemosXmlFiles();
        if (list != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list);
            return new ArrayList<String>(linkedHashSet);
        }
        return null;
    }

    private static boolean needsRefresh(List<String> list) {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null) {
            List<String> list2 = demosDataHolder.getDemosXmlFiles();
            return DemosData.checkForFileListChanges(list2, list);
        }
        return true;
    }

    private static boolean checkForFileListChanges(List<String> list, List<String> list2) {
        if (list2.size() == list.size()) {
            for (String string : list2) {
                if (list.contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static synchronized void populate(final List<String> list) {
        HelpDataWorkerStrategy<DemosDataHolder> helpDataWorkerStrategy = new HelpDataWorkerStrategy<DemosDataHolder>(){
            private final DemosDataHolder iHolder;
            {
                this.iHolder = new DemosDataHolder(list);
            }

            @Override
            public void beforePopulateEdt() {
                boolean bl = DemosData.isPopulated();
                DemosData.setCurrentDemosData(this.iHolder);
                if (bl) {
                    DemosData.notifyListeners();
                }
            }

            @Override
            public void populate(HelpDataObserver<DemosDataHolder> helpDataObserver) {
                FinishPopulateRunnable finishPopulateRunnable = new FinishPopulateRunnable(helpDataObserver, this.iHolder);
                finishPopulateRunnable.setXmlFileList(list);
                if (DemosData.isActiveHolder(this.iHolder)) {
                    if (Matlab.isMatlabAvailable()) {
                        Matlab.whenMatlabReady((Runnable)new FindDemosRunnable(finishPopulateRunnable, this.iHolder));
                    } else {
                        new Thread(finishPopulateRunnable).start();
                    }
                }
            }

            @Override
            public void afterPopulateEdt(DemosDataHolder demosDataHolder) {
                demosDataHolder.setPopulated(true);
                DemosData.notifyListeners();
            }
        };
        sWorker.populate(helpDataWorkerStrategy);
    }

    private static void notifyListeners() {
        List<DemosDataListener> list = DemosData.getDemosDataListeners();
        if (list != null) {
            ArrayList<DemosDataListener> arrayList = new ArrayList<DemosDataListener>(DemosData.getDemosDataListeners());
            for (DemosDataListener demosDataListener : arrayList) {
                if (DemosData.isPopulated()) {
                    demosDataListener.demosPopulated();
                    continue;
                }
                demosDataListener.demosCleared();
            }
        }
    }

    public static synchronized boolean isPopulated() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        return demosDataHolder != null && demosDataHolder.isPopulated();
    }

    public static DemoTreeItem getItemForXmlFile(String string) {
        DemoTreeItem demoTreeItem = null;
        String string2 = FileUtils.normalizePathname((String)string);
        String string3 = DemoInfoUtils.getLocalizedDemoFilename(string2);
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            demoTreeItem = demosDataHolder.getDemoTreeItemForXmlFile(string3);
        }
        if (demoTreeItem == null) {
            demoTreeItem = DemosData.processXmlFilename(string3, demosDataHolder);
        }
        return demoTreeItem;
    }

    private static void createProductItems(List<String> list, Document[] documentArray, DemosDataHolder demosDataHolder) {
        for (String string : list) {
            DemosData.parseAndAddXmlFile(demosDataHolder, string);
        }
        if (documentArray != null) {
            for (Document document : documentArray) {
                DemosData.parseAndAddDemosMFile(demosDataHolder, document);
            }
        }
    }

    private static void parseAndAddXmlFile(DemosDataHolder demosDataHolder, String string) {
        try {
            String string2 = FileUtils.normalizePathname((String)string);
            DemoTreeItem demoTreeItem = demosDataHolder.getDemoTreeItemForXmlFile(string2);
            if (demoTreeItem == null) {
                demoTreeItem = DemosData.processXmlFilename(string2, demosDataHolder);
            }
            if (demoTreeItem != null) {
                DemosData.addDemosXmlItem(demoTreeItem, demosDataHolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void parseAndAddDemosMFile(DemosDataHolder demosDataHolder, Document document) {
        try {
            DemoTreeItem demoTreeItem = DemoParser.processDocument("", document, demosDataHolder);
            DemosData.addDemosXmlItem(demoTreeItem, demosDataHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addDemosXmlItem(DemoTreeItem demoTreeItem, DemosDataHolder demosDataHolder) {
        String string = demoTreeItem.getProductType();
        String string2 = NO_CATEGORY_NAME;
        if (string == null) {
            string2 = NO_CATEGORY_NAME;
        } else if (string.equalsIgnoreCase(MATLAB_NAME)) {
            string2 = MATLAB_NAME;
        } else if (string.equalsIgnoreCase("toolbox")) {
            string2 = TOOLBOXES_NAME;
        } else if (string.equalsIgnoreCase(SIMULINK_NAME)) {
            string2 = SIMULINK_NAME;
        } else if (string.equalsIgnoreCase("blockset")) {
            string2 = BLOCKSETS_NAME;
        } else if (string.equalsIgnoreCase("links_targets")) {
            string2 = LINKS_NAME;
        }
        demosDataHolder.addProductItem(string2, demoTreeItem);
    }

    private static synchronized DemoTreeItem processXmlFilename(String string, DemosDataHolder demosDataHolder) {
        try {
            return DemosData.parseDemosXmlFile(string, demosDataHolder);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("Warning: In file " + string + ", line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DemoTreeItem parseDemosXmlFile(String string, DemosDataHolder demosDataHolder) throws IOException, SAXException {
        File file = new File(string);
        DocumentBuilder documentBuilder = DemosData.getDocumentBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Document document = documentBuilder.parse(new InputSource(fileInputStream));
            DemoTreeItem demoTreeItem = DemoParser.processDocument(string, document, demosDataHolder);
            return demoTreeItem;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (sDocBuilder == null) {
            block3: {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                try {
                    sDocBuilder = documentBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)("Could not configure parser: " + parserConfigurationException.getMessage()));
                }
            }
            sDocBuilder.setErrorHandler(new DemoErrorHandler());
        }
        return sDocBuilder;
    }

    private static synchronized void setCurrentDemosData(DemosDataHolder demosDataHolder) {
        sCurrentDemosData = demosDataHolder;
    }

    private static synchronized DemosDataHolder getCurrentDemosData() {
        return sCurrentDemosData;
    }

    private static boolean isActiveHolder(DemosDataHolder demosDataHolder) {
        DemosDataHolder demosDataHolder2 = DemosData.getCurrentDemosData();
        return demosDataHolder2 != null && demosDataHolder2.equals(demosDataHolder);
    }

    public static synchronized void setXmlFileProvider(DemosXmlFileProvider demosXmlFileProvider) {
        sXmlFileProvider = demosXmlFileProvider;
        DemosData.initialize();
    }

    private static synchronized DemosXmlFileProvider getXmlFileProvider() {
        if (sXmlFileProvider == null) {
            sXmlFileProvider = new DefaultDemosXmlFileProvider();
        }
        return sXmlFileProvider;
    }

    static {
        DemosData.initialize();
        DemosInfoListener demosInfoListener = new DemosInfoListener();
        MatlabPath.addActionListener((ActionListener)demosInfoListener);
        HelpPrefs.addPrefsListeners(demosInfoListener, "HelpSelectedProducts", "HelpFilterEnabled");
    }

    private static class DefaultDemosXmlFileProvider
    implements DemosXmlFileProvider {
        private DefaultDemosXmlFileProvider() {
        }

        @Override
        public List<String> getDemosXmlFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<File> list = DefaultDemosXmlFileProvider.getSearchPath();
            if (list != null) {
                for (File file : list) {
                    File file2 = new File(file, "demos.xml");
                    if (!FileUtils.fileExists((File)file2)) continue;
                    arrayList.add(DemoInfoUtils.getLocalizedDemoFilename(file2.getAbsolutePath()));
                }
                return arrayList;
            }
            return null;
        }

        private static List<File> getSearchPath() {
            if (Matlab.isMatlabAvailable()) {
                try {
                    List list = MatlabPath.getSearchPathEntries();
                    boolean bl = HelpPrefs.isUsingDocCenterBrowser();
                    ArrayList<File> arrayList = new ArrayList<File>();
                    for (MatlabPath.PathEntry pathEntry : list) {
                        File file = pathEntry.getCurrentlyResolvedPath();
                        if (bl && DefaultDemosXmlFileProvider.isPathUnderToolboxOrHelp(file)) continue;
                        arrayList.add(file);
                    }
                    return arrayList;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }

        private static boolean isPathUnderToolboxOrHelp(File file) {
            String string;
            if (file == null) {
                return false;
            }
            String string2 = string = Matlab.isMatlabAvailable() ? Matlab.matlabRoot() : null;
            if (string == null) {
                return false;
            }
            String string3 = file.getAbsolutePath().toLowerCase().replace('\\', '/');
            String string4 = (string + "/toolbox").toLowerCase().replace('\\', '/');
            String string5 = MLHelpServices.getDocRoot().toLowerCase().replace('\\', '/');
            return string3.startsWith(string4) || string3.startsWith(string5);
        }
    }

    public static interface DemosXmlFileProvider {
        public List<String> getDemosXmlFiles();
    }

    private static class DemoErrorHandler
    implements ErrorHandler {
        private DemoErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }
    }

    private static class DemosInfoListener
    implements ActionListener,
    PrefListener {
        private DemosInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DemosData.repopulate(false);
                }
            }).start();
        }

        public void prefChanged(PrefEvent prefEvent) {
            DemosData.repopulate(true);
        }
    }

    private static class FinishPopulateRunnable
    implements Runnable {
        private final HelpDataObserver<DemosDataHolder> iObserver;
        private final DemosDataHolder iHolder;
        private List<String> iXmlFileList;
        private Document[] iOldDocuments;

        private FinishPopulateRunnable(HelpDataObserver<DemosDataHolder> helpDataObserver, DemosDataHolder demosDataHolder) {
            this.iObserver = helpDataObserver;
            this.iHolder = demosDataHolder;
        }

        private void setXmlFileList(List<String> list) {
            this.iXmlFileList = list;
        }

        private void setDemosMFiles(Document[] documentArray) {
            this.iOldDocuments = documentArray;
        }

        @Override
        public void run() {
            if (DemosData.isActiveHolder(this.iHolder)) {
                DemosData.createProductItems(this.iXmlFileList, this.iOldDocuments, this.iHolder);
            }
            if (DemosData.isActiveHolder(this.iHolder)) {
                this.iObserver.dataPopulated(this.iHolder);
            }
        }
    }

    private static class FindDemosRunnable
    implements Runnable {
        private final FinishPopulateRunnable iFinishRunnable;
        private final DemosDataHolder iHolder;

        private FindDemosRunnable(FinishPopulateRunnable finishPopulateRunnable, DemosDataHolder demosDataHolder) {
            this.iFinishRunnable = finishPopulateRunnable;
            this.iHolder = demosDataHolder;
        }

        @Override
        public void run() {
            Object object = null;
            if (DemosData.isActiveHolder(this.iHolder)) {
                try {
                    Object object2 = Matlab.mtFeval((String)"convertdemostodom", null, (int)1);
                    object = object2 instanceof Document ? new Document[]{(Document)object2} : (object2 instanceof Document[] ? (Document[])object2 : null);
                }
                catch (Exception exception) {
                    object = null;
                }
            }
            if (DemosData.isActiveHolder(this.iHolder)) {
                this.iFinishRunnable.setDemosMFiles(object);
                new Thread(this.iFinishRunnable).start();
            }
        }
    }
}

