/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.DemoSearchEngine;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.SearchField;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDemoIndexer;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDocIndexer;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.xml.sax.SAXException;

public class LuceneIndexServices {
    private LuceneIndexServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void indexDoc(String string) throws Exception {
        DocSearchEngine docSearchEngine = null;
        if (DocSearchEngine.isInitialized() && (docSearchEngine = DocSearchEngine.getInstance()) != null) {
            DocSearchEngine docSearchEngine2 = docSearchEngine;
            synchronized (docSearchEngine2) {
                docSearchEngine.cleanup();
            }
        }
        LuceneDocIndexer.indexDoc(string, HelpUtils.getLocaleString());
        if (docSearchEngine != null) {
            docSearchEngine.refresh(true);
        }
    }

    public static void indexDemos(String string) throws IOException, SAXException {
        LuceneIndexServices.indexDemos(string, HelpUtils.getLocaleString());
    }

    public static void indexDemos(String string, String string2) throws IOException, SAXException {
        LuceneIndexServices.indexDemos(new String[]{string}, string2);
    }

    public static void indexDemos(String[] stringArray) throws IOException, SAXException {
        LuceneIndexServices.indexDemos(stringArray, HelpUtils.getLocaleString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void indexDemos(String[] stringArray, String string) throws IOException, SAXException {
        String[] stringArray2;
        if (DemoSearchEngine.isInitialized() && (stringArray2 = DemoSearchEngine.getInstance()) != null) {
            String[] stringArray3 = stringArray2;
            // MONITORENTER : stringArray2
            stringArray2.cleanup();
            // MONITOREXIT : stringArray3
        }
        stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            LuceneDemoIndexer.indexDemos(string2, string);
            ++n2;
        }
    }

    static Field createField(SearchField searchField, String string) {
        Field.Store store = searchField.isStored() ? Field.Store.YES : Field.Store.NO;
        Field.Index index = Field.Index.NO;
        if (searchField.isIndexed()) {
            index = searchField.isTokenized() ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED;
        }
        return new Field(searchField.getFieldName(), string, store, index);
    }
}

