/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.ExactPhraseSearchExpression;
import com.mathworks.mlwidgets.help.search.PartialWordSearchExpression;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchStringParseException;
import com.mathworks.mlwidgets.help.search.SearchVisitor;
import com.mathworks.mlwidgets.help.search.SimpleSearchExpression;
import com.mathworks.mlwidgets.help.search.UnarySearchExpression;
import com.mathworks.mlwidgets.help.search.WeightedSearchField;
import com.mathworks.mlwidgets.help.search.WildcardSearchExpression;
import com.mathworks.mlwidgets.help.search.lucene.AnalyzerSource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Locale;
import java.util.Stack;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

abstract class LuceneSearchVisitor
implements SearchVisitor {
    private static AnalyzerSource sAnalyzerSource = new AnalyzerSource(HelpUtils.getLanguageLocale());
    private Query fBaseQuery;
    private BooleanSearchOperator fOperator;
    private Stack<Collection<WeightedSearchField>> fSearchFieldsStack = new Stack();

    LuceneSearchVisitor() {
    }

    @Override
    public void visit(SimpleSearchExpression simpleSearchExpression) throws SearchException {
        this.handleSimpleSearchString(simpleSearchExpression.getSearchString(), this.getFields(simpleSearchExpression), simpleSearchExpression.getBooleanOperator());
    }

    private void handleSimpleSearchString(String string, Collection<WeightedSearchField> collection, BooleanSearchOperator booleanSearchOperator) throws SearchStringParseException {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (WeightedSearchField weightedSearchField : collection) {
            TermQuery termQuery;
            if (weightedSearchField.getSearchField().isTokenized()) {
                QueryParser queryParser = new QueryParser(weightedSearchField.getFieldName(), sAnalyzerSource.getSearchAnalyzer());
                try {
                    if (string.contains(":")) {
                        string = string.replaceAll(":", "\\\\:");
                    }
                    termQuery = queryParser.parse(string);
                }
                catch (ParseException parseException) {
                    throw new SearchStringParseException(3, (Throwable)parseException);
                }
            } else {
                termQuery = new TermQuery(new Term(weightedSearchField.getFieldName(), string));
            }
            termQuery.setBoost(weightedSearchField.getWeight());
            booleanQuery.add((Query)termQuery, LuceneSearchVisitor.getOccurrence(weightedSearchField.getBooleanOperator()));
        }
        this.setBaseQuery((Query)booleanQuery);
        this.setBooleanOperator(booleanSearchOperator);
    }

    @Override
    public void visit(PartialWordSearchExpression partialWordSearchExpression) throws SearchStringParseException {
        String string = partialWordSearchExpression.getSearchString();
        BooleanQuery booleanQuery = new BooleanQuery();
        Collection<WeightedSearchField> collection = this.getFields(partialWordSearchExpression);
        if (LuceneSearchVisitor.checkForWildcardSupport(string, collection)) {
            for (WeightedSearchField weightedSearchField : collection) {
                if (weightedSearchField.getSearchField().isTokenized()) {
                    string = string.toLowerCase(Locale.getDefault());
                }
                PrefixQuery prefixQuery = new PrefixQuery(new Term(weightedSearchField.getFieldName(), string));
                prefixQuery.setBoost(weightedSearchField.getWeight());
                booleanQuery.add((Query)prefixQuery, LuceneSearchVisitor.getOccurrence(weightedSearchField.getBooleanOperator()));
            }
            this.setBaseQuery((Query)booleanQuery);
            this.setBooleanOperator(partialWordSearchExpression.getBooleanOperator());
        } else {
            this.handleSimpleSearchString(string, collection, partialWordSearchExpression.getBooleanOperator());
        }
    }

    @Override
    public void visit(WildcardSearchExpression wildcardSearchExpression) throws SearchStringParseException {
        Collection<WeightedSearchField> collection;
        String string = wildcardSearchExpression.getSearchString();
        String string2 = string.replaceAll("\\*", "");
        if (LuceneSearchVisitor.checkForWildcardSupport(string2, collection = this.getFields(wildcardSearchExpression))) {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (WeightedSearchField weightedSearchField : collection) {
                if (weightedSearchField.getSearchField().isTokenized()) {
                    string = string.toLowerCase(Locale.getDefault());
                }
                WildcardQuery wildcardQuery = new WildcardQuery(new Term(weightedSearchField.getFieldName(), string));
                wildcardQuery.setBoost(weightedSearchField.getWeight());
                booleanQuery.add((Query)wildcardQuery, LuceneSearchVisitor.getOccurrence(weightedSearchField.getBooleanOperator()));
            }
            this.setBaseQuery((Query)booleanQuery);
            this.setBooleanOperator(wildcardSearchExpression.getBooleanOperator());
        } else {
            this.handleSimpleSearchString(string2, collection, wildcardSearchExpression.getBooleanOperator());
        }
    }

    private static boolean checkForWildcardSupport(String string, Collection<WeightedSearchField> collection) {
        for (WeightedSearchField weightedSearchField : collection) {
            if (!weightedSearchField.getSearchField().isTokenized()) continue;
            return LuceneSearchVisitor.isWildcardCharacterSupported(string, weightedSearchField.getFieldName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWildcardCharacterSupported(String string, String string2) {
        Analyzer analyzer = sAnalyzerSource.getSearchAnalyzer();
        TokenStream tokenStream = analyzer.tokenStream(string2, (Reader)new StringReader(string));
        try {
            tokenStream.next();
            boolean bl = tokenStream.next() == null;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                tokenStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void visit(ExactPhraseSearchExpression exactPhraseSearchExpression) throws SearchException {
        String string = exactPhraseSearchExpression.getSearchString();
        try {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (WeightedSearchField weightedSearchField : this.getFields(exactPhraseSearchExpression)) {
                QueryParser queryParser = new QueryParser(weightedSearchField.getFieldName(), sAnalyzerSource.getSearchAnalyzer());
                Query query = queryParser.parse("\"" + string + "\"");
                query.setBoost(weightedSearchField.getWeight());
                booleanQuery.add(query, LuceneSearchVisitor.getOccurrence(weightedSearchField.getBooleanOperator()));
            }
            this.setBaseQuery((Query)booleanQuery);
            this.setBooleanOperator(exactPhraseSearchExpression.getBooleanOperator());
        }
        catch (ParseException parseException) {
            throw new SearchStringParseException(3);
        }
    }

    @Override
    public void visit(CompoundSearchExpression compoundSearchExpression) throws SearchException {
        BooleanQuery booleanQuery = new BooleanQuery();
        boolean bl = this.pushSearchFields(compoundSearchExpression);
        for (SearchExpression searchExpression : compoundSearchExpression.getExpressions()) {
            searchExpression.accept(this);
            booleanQuery.add(this.getBaseQuery(), LuceneSearchVisitor.getOccurrence(this.getBooleanOperator()));
        }
        this.setBaseQuery((Query)booleanQuery);
        this.setBooleanOperator(compoundSearchExpression.getBooleanOperator());
        if (bl) {
            this.popSearchFields();
        }
    }

    private Collection<WeightedSearchField> getFields(UnarySearchExpression unarySearchExpression) {
        Collection<WeightedSearchField> collection = unarySearchExpression.getSearchFields();
        if (collection != null) {
            return collection;
        }
        if (!this.fSearchFieldsStack.isEmpty()) {
            return this.fSearchFieldsStack.peek();
        }
        return this.getDefaultFields();
    }

    private boolean pushSearchFields(CompoundSearchExpression compoundSearchExpression) {
        Collection<WeightedSearchField> collection = compoundSearchExpression.getSearchFields();
        if (collection != null) {
            this.fSearchFieldsStack.push(collection);
            return true;
        }
        return false;
    }

    private void popSearchFields() {
        this.fSearchFieldsStack.pop();
    }

    protected abstract Collection<WeightedSearchField> getDefaultFields();

    protected void setBaseQuery(Query query) {
        this.fBaseQuery = query;
    }

    Query getBaseQuery() {
        return this.fBaseQuery;
    }

    private void setBooleanOperator(BooleanSearchOperator booleanSearchOperator) {
        this.fOperator = booleanSearchOperator;
    }

    private BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }

    private static BooleanClause.Occur getOccurrence(BooleanSearchOperator booleanSearchOperator) {
        switch (booleanSearchOperator) {
            case MUST_OCCUR: {
                return BooleanClause.Occur.MUST;
            }
            case MUST_NOT_OCCUR: {
                return BooleanClause.Occur.MUST_NOT;
            }
            case SHOULD_OCCUR: {
                return BooleanClause.Occur.SHOULD;
            }
        }
        return BooleanClause.Occur.SHOULD;
    }
}

