/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.DummyHtmlComponent;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.mlwidgets.html.DummyMatlabHtmlActions;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlComponentFactory {
    private static final HtmlComponentType DEFAULT_TYPE = HtmlComponentType.HTMLRENDERER;
    private static final String TYPE_PREF = "HtmlComponent.DefaultType";
    private static final Pattern RH5_PATTERN = Pattern.compile("\\d+");

    private HtmlComponentFactory() {
    }

    public static HtmlComponent<MatlabHtmlActions> buildHtmlComponent(HtmlComponentType ... htmlComponentTypeArray) {
        HtmlComponentType htmlComponentType;
        List<HtmlComponentType> list = HtmlComponentFactory.getTypesToTry(htmlComponentTypeArray);
        HtmlComponent<MatlabHtmlActions> htmlComponent = null;
        Iterator<HtmlComponentType> iterator = list.iterator();
        while (iterator.hasNext() && (htmlComponent = HtmlComponentFactory.buildHtmlComponentForType(htmlComponentType = iterator.next())) == null) {
        }
        if (htmlComponent == null) {
            throw new RuntimeException("Could not create an HtmlComponent.");
        }
        htmlComponent.getComponent().setName("HtmlComponent");
        return htmlComponent;
    }

    private static List<HtmlComponentType> getTypesToTry(HtmlComponentType ... htmlComponentTypeArray) {
        if (htmlComponentTypeArray.length == 0) {
            htmlComponentTypeArray = new HtmlComponentType[]{HtmlComponentType.FOLLOW_PREFERENCE};
        }
        LinkedList<HtmlComponentType> linkedList = new LinkedList<HtmlComponentType>();
        linkedList.addAll(Arrays.asList(htmlComponentTypeArray));
        linkedList.addAll(Arrays.asList(DEFAULT_TYPE, HtmlComponentType.HTMLRENDERER));
        LinkedList<HtmlComponentType> linkedList2 = new LinkedList<HtmlComponentType>();
        for (HtmlComponentType htmlComponentType : linkedList) {
            HtmlComponentType htmlComponentType2 = HtmlComponentFactory.resolveType(htmlComponentType);
            if (htmlComponentType2 == null || linkedList2.contains((Object)htmlComponentType2)) continue;
            linkedList2.add(htmlComponentType2);
        }
        return linkedList2;
    }

    private static HtmlComponentType resolveType(HtmlComponentType htmlComponentType) {
        if (htmlComponentType == HtmlComponentType.HTMLPANEL && !HtmlComponentFactory.isDocCenterBrowserSupported()) {
            return null;
        }
        if (htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE) {
            return HtmlComponentFactory.getTypeFromPrefs();
        }
        return htmlComponentType;
    }

    private static boolean isDocCenterBrowserSupported() {
        boolean bl = true;
        if (PlatformInfo.isLinux64() && HtmlComponentFactory.isRedHat5()) {
            bl = false;
        }
        return bl;
    }

    private static boolean isRedHat5() {
        boolean bl = false;
        try {
            Matcher matcher;
            String string = HtmlComponentFactory.readFile("/etc/redhat-release");
            string = string.toUpperCase();
            if (string.contains("RED HAT") && (matcher = RH5_PATTERN.matcher(string)).find() && Integer.parseInt(matcher.group()) == 5) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private static String readFile(String string) throws IOException {
        return new Scanner(new File(string)).useDelimiter("\\A").next();
    }

    private static HtmlComponent<MatlabHtmlActions> buildHtmlComponentForType(HtmlComponentType htmlComponentType) {
        if (htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE) {
            assert (false) : "We should resolve the FOLLOW_PREFERENCE type before we try to build the HtmlComponent.";
            htmlComponentType = HtmlComponentFactory.getTypeFromPrefs();
        }
        if (htmlComponentType == null) {
            return null;
        }
        switch (htmlComponentType) {
            case HTMLPANEL: {
                return HtmlComponentFactory.buildHtmlPanel();
            }
            case HTMLRENDERER: {
                return HtmlComponentFactory.buildHTMLRenderer(false);
            }
            case ICEBROWSER: {
                return HtmlComponentFactory.buildHTMLRenderer(true);
            }
            case DUMMY: {
                return HtmlComponentFactory.buildDummyComponent();
            }
        }
        return null;
    }

    public static HtmlComponentType getExpectedHtmlComponentType(HtmlComponentType ... htmlComponentTypeArray) {
        return HtmlComponentFactory.getTypesToTry(htmlComponentTypeArray).get(0);
    }

    private static HtmlComponentType getTypeFromPrefs() {
        String string = Prefs.getStringPref((String)TYPE_PREF);
        try {
            HtmlComponentType htmlComponentType = HtmlComponentType.valueOf(string);
            return htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE ? null : htmlComponentType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setDefaultType(String string) {
        HtmlComponentType htmlComponentType = null;
        if (string == null || string.trim().length() == 0) {
            htmlComponentType = null;
        } else {
            try {
                htmlComponentType = HtmlComponentType.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                System.out.println("Invalid type.  Please enter one of: ");
                EnumSet<HtmlComponentType> enumSet = EnumSet.of(HtmlComponentType.HTMLPANEL, HtmlComponentType.HTMLRENDERER);
                for (HtmlComponentType htmlComponentType2 : enumSet) {
                    System.out.println("\t<strong>" + htmlComponentType2.toString() + "</strong> - uses " + htmlComponentType2.iRenderer + " for HTML rendering");
                }
            }
        }
        HtmlComponentFactory.setDefaultType(htmlComponentType);
    }

    public static void setDefaultType(HtmlComponentType htmlComponentType) {
        if (htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE) {
            throw new IllegalArgumentException("Cannot specify FOLLOW_PREFERENCE as the HTML component type to use for following the preference.");
        }
        if (htmlComponentType == null) {
            Prefs.remove((String)TYPE_PREF);
        } else {
            Prefs.setStringPref((String)TYPE_PREF, (String)htmlComponentType.toString());
        }
    }

    private static HtmlComponent<MatlabHtmlActions> buildHtmlPanel() {
        try {
            return MJHtmlPanel.createBrowser();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static HtmlComponent<MatlabHtmlActions> buildHTMLRenderer(boolean bl) {
        HTMLRenderer hTMLRenderer = new HTMLRenderer(bl);
        return new HtmlComponentAdapter(hTMLRenderer);
    }

    private static HtmlComponent<MatlabHtmlActions> buildDummyComponent() {
        DummyHtmlComponent dummyHtmlComponent = new DummyHtmlComponent();
        dummyHtmlComponent.setActions((HtmlActions)new DummyMatlabHtmlActions());
        return dummyHtmlComponent;
    }

    public static enum HtmlComponentType {
        HTMLPANEL("JxBrowser"),
        HTMLRENDERER("HTMLRenderer, using ICE browser"),
        ICEBROWSER("ICE browser"),
        FOLLOW_PREFERENCE("the browser specified by the HtmlComponent.DefaultType preference"),
        DUMMY("a dummy browser");

        private final String iRenderer;

        private HtmlComponentType(String string2) {
            this.iRenderer = string2;
        }
    }
}

