/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.FixedWidthPane;
import com.mathworks.mlwidgets.importtool.TextCellRenderer;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextTableHeaderRenderer;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.util.PlatformInfo;
import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class FixedWidthDragWindow
extends MJWindow {
    TextTable fTable;
    FixedWidthPane fPane;
    Cursor fFixedWidthCursor = new Cursor(10);
    boolean fAddCursor = false;
    int fMaxCharacters = 10;
    int fRectPadding = 4;

    public FixedWidthDragWindow(FixedWidthPane fixedWidthPane, TextTable textTable, boolean bl) {
        super(SwingUtilities.getWindowAncestor((Component)((Object)fixedWidthPane)), FixedWidthDragWindow.createGrahicsConfig());
        try {
            if (this.getGraphicsConfiguration() != null) {
                AWTUtilities.setWindowOpaque((Window)((Object)this), (boolean)false);
            } else {
                AWTUtilities.setWindowOpacity((Window)((Object)this), (float)0.5f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setName("FixedWidthDragWindow");
        this.fAddCursor = bl;
        this.fTable = textTable;
        this.fPane = fixedWidthPane;
        this.setAlwaysOnTop(true);
        this.setFocusable(true);
        this.setFocusableWindowState(true);
        this.setCursor(this.fFixedWidthCursor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FixedWidthDragWindow.this.closeWindow();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    FixedWidthDragWindow.this.closeWindow();
                }
            }
        });
        try {
            Rectangle rectangle = textTable.getVisibleRect();
            Point point = textTable.getTableHeader().getLocationOnScreen();
            rectangle.x = point.x;
            rectangle.y = point.y;
            TextCellRenderer textCellRenderer = (TextCellRenderer)this.fTable.getCellRenderer(0, 0);
            Font font = textCellRenderer.getRenderedFont();
            int n = (int)font.getStringBounds("_", textCellRenderer.getFontMetrics(font).getFontRenderContext()).getWidth();
            int n2 = (int)font.getStringBounds("_", textCellRenderer.getFontMetrics(font).getFontRenderContext()).getHeight();
            rectangle.width = n * this.fMaxCharacters;
            rectangle.height += n2 + this.fRectPadding;
            if (textTable.getTableHeader().getDefaultRenderer() instanceof TextTableHeaderRenderer) {
                rectangle.height += ((TextTableHeaderRenderer)((Object)textTable.getTableHeader().getDefaultRenderer())).getRulerLabelHeight() / 2;
                rectangle.height -= (n2 + this.fRectPadding) / 2;
            }
            if (!PlatformInfo.isLinux()) {
                this.setSize(rectangle.width, rectangle.height);
            } else {
                this.setSize(1, rectangle.height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeWindow() {
        try {
            this.fPane.closeDragWindow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }

    private static final GraphicsConfiguration createGrahicsConfig() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        GraphicsConfiguration graphicsConfiguration = null;
        for (int i = 0; i < graphicsDeviceArray.length && graphicsConfiguration == null; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length && graphicsConfiguration == null; ++j) {
                if (!AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)graphicsConfigurationArray[j])) continue;
                graphicsConfiguration = graphicsConfigurationArray[j];
            }
        }
        return graphicsConfiguration;
    }

    public void setLocation(Point point) {
        if (!this.isVisible()) {
            super.setLocation(point);
            return;
        }
        Point point2 = this.getModifiedLocation(point);
        super.setLocation(point2);
        this.repaint();
    }

    public Point getModifiedLocation(Point point) {
        TextCellRenderer textCellRenderer = (TextCellRenderer)this.fTable.getCellRenderer(0, 0);
        Font font = textCellRenderer.getRenderedFont();
        int n = (int)font.getStringBounds("_", textCellRenderer.getFontMetrics(font).getFontRenderContext()).getWidth();
        int n2 = (int)font.getStringBounds("_", textCellRenderer.getFontMetrics(font).getFontRenderContext()).getHeight();
        int n3 = this.fTable.getTableHeader().getLocationOnScreen().y + this.fTable.getTableHeader().getHeight();
        if (this.fTable.getTableHeader().getDefaultRenderer() instanceof TextTableHeaderRenderer) {
            n3 -= ((TextTableHeaderRenderer)((Object)this.fTable.getTableHeader().getDefaultRenderer())).getRulerLabelHeight() / 2;
        }
        Point point2 = new Point(point.x - this.getWidth() / 2 + 1, n3 - n2 / 2 - this.fRectPadding);
        return point2;
    }

    public Point getCenterTopLocation() {
        Rectangle rectangle = this.getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y);
        return point;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.fTable.getGridColor();
        if (this.fAddCursor) {
            color = Color.BLACK;
        }
        int n = this.getCharacterPosition();
        String string = n + "";
        TextCellRenderer textCellRenderer = (TextCellRenderer)this.fTable.getCellRenderer(0, 0);
        Font font = textCellRenderer.getRenderedFont();
        int n2 = (int)font.getStringBounds(string, textCellRenderer.getFontMetrics(font).getFontRenderContext()).getWidth();
        int n3 = (int)font.getStringBounds(string, textCellRenderer.getFontMetrics(font).getFontRenderContext()).getHeight();
        int n4 = this.fRectPadding + n3;
        int n5 = this.fRectPadding + n2;
        graphics2D.setColor(color);
        graphics2D.drawLine(this.getWidth() / 2, n4 - 1, this.getWidth() / 2, this.getHeight());
        if (!PlatformInfo.isLinux()) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(this.getWidth() / 2 - n5 / 2, 0, n5 - 1, n4);
            graphics2D.setColor(color);
            graphics2D.drawRect(this.getWidth() / 2 - n5 / 2, 0, n5 - 1, n4);
            graphics2D.setColor(color);
            graphics2D.setFont(this.fTable.getFont());
            FontMetrics fontMetrics = this.fTable.getFontMetrics(this.fTable.getFont());
            graphics2D.drawString(string, (this.getWidth() - fontMetrics.stringWidth(string)) / 2, n4 - (n4 - fontMetrics.getHeight()));
        }
    }

    public int getCharacterPosition() {
        if (!this.isVisible()) {
            return -1;
        }
        Point point = this.getLocationOnScreen();
        point.x += this.getWidth() / 2;
        point.y += this.getWidth() / 2;
        int n = this.fTable.getCharacterPositionForLocationOnScreen(point);
        return n;
    }
}

