/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateCell;
import com.mathworks.mlwidgets.importtool.DateConversionRule;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportUIState;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import java.awt.Point;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class WorksheetTableModel
extends AbstractFileTableModel {
    private String fSheetName;
    private String fWorkbookName;
    private Integer fTopHeaderRow;
    static final int UNINITIALIZED_CLASS = -1;
    private volatile Object fSpreadsheet;
    private volatile int fDefaultHeaderRow = 0;
    private volatile SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] fColumnTargetTypes = new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[0];
    public static int DEFAULT_TEST_ROW_COUNT = 10;
    public static int DEFAULT_TEST_COLUMN_COUNT = 20;

    @Override
    protected void rebuild(final int n, final int n2) {
        MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

            public double[] runOnMatlabThread() {
                try {
                    return (double[])Matlab.mtFeval((String)"GetSheetDimensions", (Object[])new Object[]{WorksheetTableModel.this.fSpreadsheet, WorksheetTableModel.this.fSheetName}, (int)1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(double[] dArray) {
                if (dArray == null) {
                    return;
                }
                if (dArray.length != 4) {
                    return;
                }
                int[] nArray = new int[]{(int)(dArray[1] + dArray[0]) - 1, (int)(dArray[3] + dArray[2]) - 1};
                int[] nArray2 = new int[]{(int)dArray[0] - 1, (int)dArray[2] - 1};
                if (WorksheetTableModel.this.fDimensions[0] != nArray[0] || WorksheetTableModel.this.fDimensions[1] != nArray[1] || WorksheetTableModel.this.fStartCell[0] != nArray2[0] || WorksheetTableModel.this.fStartCell[1] != nArray2[1]) {
                    WorksheetTableModel.this.fDimensions[0] = 0;
                    WorksheetTableModel.this.fDimensions[1] = 0;
                    WorksheetTableModel.this.fStartCell[0] = 0;
                    WorksheetTableModel.this.fStartCell[1] = 0;
                    WorksheetTableModel.this.fTableStructureInitialized = false;
                    WorksheetTableModel.this.fTemporaryBlockCache = null;
                    WorksheetTableModel.this.fInitialSelection = null;
                } else {
                    WorksheetTableModel.this.fTemporaryBlockCache = WorksheetTableModel.this.getClosestSpreadsheetDataSection(n, n2);
                }
                WorksheetTableModel.this.fCurrentMatlabBlock = null;
                WorksheetTableModel.this.fBlockCache.clear();
                Point point = WorksheetTableModel.this.getPointForIndices(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
                WorksheetTableModel.this.requestValueFromMatlab(point.x + 1, point.y + 1, WorksheetTableModel.this.ROWBLOCKSIZE, WorksheetTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
    }

    SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType getColumnTargetType(int n) {
        if (this.fColumnTargetTypes == null || this.fColumnTargetTypes.length <= n) {
            return null;
        }
        return this.fColumnTargetTypes[n];
    }

    SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getSelectedColumnVectorTargetTypes(int[] nArray) {
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.fColumnTargetTypes[nArray[i]]);
        }
        return arrayList.toArray(new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[1]);
    }

    private SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getSelectedColumnVectorTargetTypes(String string) {
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        if (list.isEmpty()) {
            return new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[0];
        }
        int[] nArray = list.get(0);
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int i = nArray[1] - 1; i <= nArray[3] - 1; ++i) {
            arrayList.add(this.fColumnTargetTypes[i]);
        }
        return arrayList.toArray(new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[1]);
    }

    Object[][] getSelectedCellColumnVectors(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Object[][] objectArray = new Object[stringArray.length][stringArray[0].length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray = this.getSelectedColumnVectorTargetTypes(stringArray[i][j]);
                boolean[] blArray = new boolean[spreadsheetColumnTargetTypeArray.length];
                for (int k = 0; k < blArray.length; ++k) {
                    blArray[k] = spreadsheetColumnTargetTypeArray[k] == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY;
                }
                objectArray[i][j] = blArray;
            }
        }
        return objectArray;
    }

    private List<Integer> getSelectedCellColumnVectorPositions(String[] stringArray) {
        return this.getSpreadsheetColumnTargetTypePositions(stringArray, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY);
    }

    private List<Integer> getSelectedNumericColumnVectorPositions(String[] stringArray) {
        return this.getSpreadsheetColumnTargetTypePositions(stringArray, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
    }

    private List<Integer> getSpreadsheetColumnTargetTypePositions(String[] stringArray, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            List<int[]> list = ImportToolUtils.fromExcelRange(stringArray[i]);
            int[] nArray = list.get(0);
            n = i == 0 ? nArray[1] - 1 : nArray[1] - 1 - n2;
            n2 = n2 + nArray[3] - nArray[1] + 1;
            for (int j = nArray[1] - 1; j <= nArray[3] - 1; ++j) {
                if (this.fColumnTargetTypes[j] != spreadsheetColumnTargetType) continue;
                arrayList.add(j - n);
            }
        }
        return arrayList;
    }

    public void setColumnTargetType(int n, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
        if (n < this.fColumnTargetTypes.length && this.fColumnTargetTypes[n] == spreadsheetColumnTargetType) {
            return;
        }
        if (n >= this.fColumnTargetTypes.length) {
            this.fColumnTargetTypes = Arrays.copyOf(this.fColumnTargetTypes, n + 1);
        }
        this.reset();
        this.fColumnTargetTypes[n] = spreadsheetColumnTargetType;
    }

    @Override
    boolean isUntreatedAt(int n, int n2) {
        if ((this.fTargetType == ImportClient.TargetType.COLUMNVECTORS || this.fTargetType == ImportClient.TargetType.DATASET) && n2 < this.fColumnTargetTypes.length && this.fColumnTargetTypes[n2] == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY) {
            return false;
        }
        if (this.fTargetType == ImportClient.TargetType.CELLARRAY) {
            return false;
        }
        return super.isUntreatedAt(n, n2);
    }

    @Override
    protected void requestValueFromMatlab(int n, int n2, int n3, int n4) {
        SpreadsheetDataSection spreadsheetDataSection;
        Point point = this.getPointForIndices(n, n2);
        if (!point.equals(this.fCurrentMatlabBlock) && ((spreadsheetDataSection = (SpreadsheetDataSection)this.fBlockCache.get(point)) == null || spreadsheetDataSection.isRulesDirty())) {
            this.fCurrentMatlabBlock = point;
            this.makeCallToMatlab(new MatlabWorksheetUpdateRequest(this.fSpreadsheet, this.fSheetName, this.fRules, n, n3, n2, n4));
        }
    }

    protected WorksheetTableModel(Object object, String string, String string2, List<WorksheetRule> list) {
        this.fSpreadsheet = object;
        this.fSheetName = string2;
        this.fRules = list;
        this.fWorkbookName = string;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        if (Matlab.isMatlabAvailable()) {
            this.requestValueFromMatlab(1, 1, this.ROWBLOCKSIZE, this.COLUMNBLOCKSIZE);
        }
    }

    WorksheetTableModel(SpreadsheetDataSection spreadsheetDataSection, String string, String string2) {
        this.fSheetName = string2;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        this.fBlockCache.put(new Point(0, 0), spreadsheetDataSection);
        this.fWorkbookName = string;
    }

    String getWorkbookName() {
        return this.fWorkbookName;
    }

    void setWorkbookName(String string) {
        this.fWorkbookName = string;
    }

    @Override
    void setHeaderRow(int n) {
        this.fTopHeaderRow = n;
    }

    @Override
    Integer getTopHeaderRow() {
        if (this.fTopHeaderRow == null) {
            return this.fDefaultHeaderRow;
        }
        return this.fTopHeaderRow;
    }

    void populateSpreadsheetImportUIState(SpreadsheetImportUIState spreadsheetImportUIState, String string, int[] nArray) {
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int n : nArray) {
            arrayList.add(this.fColumnTargetTypes[n]);
        }
        spreadsheetImportUIState.setSelectedColumnTargetTypes(arrayList);
        spreadsheetImportUIState.setFile(new File(this.fWorkbookName));
        spreadsheetImportUIState.setDimensions(this.fDimensions);
        spreadsheetImportUIState.setRules(this.fRules);
        spreadsheetImportUIState.setSheetName(this.fSheetName);
        spreadsheetImportUIState.setIsRangeDefaultSelection(this.isRangeDefaultSelection(string));
    }

    private boolean hasExcelDates() {
        int n = this.getRowCount();
        n = n < DEFAULT_TEST_ROW_COUNT ? n : DEFAULT_TEST_ROW_COUNT;
        int n2 = this.getColumnCount();
        n2 = n2 < DEFAULT_TEST_COLUMN_COUNT ? n2 : DEFAULT_TEST_COLUMN_COUNT;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.getValueAt(i, j);
                if (!(object instanceof DateCell)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<WorksheetRule> getDefaultWorksheetRuleList() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        if (this.hasExcelDates()) {
            arrayList.add(new DateConversionRule());
        }
        arrayList.add(new NonNumericReplacementRule());
        return arrayList;
    }

    @Override
    Object[] importData(String[] stringArray, String[] stringArray2, String string, String[][] stringArray3, int n) throws Exception {
        ArrayList<WorksheetRule> arrayList = this.fRules;
        if ((double)n > 2000000.0) {
            boolean bl = false;
            for (WorksheetRule worksheetRule : this.fRules) {
                if (!worksheetRule.codeGenUsesDates()) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2 = ImportToolUtils.getResourceString("messages.largeimport");
                int n2 = MJOptionPane.showConfirmDialog(null, (Object)string2, (String)"Import Tool", (int)1, (int)3);
                if (n2 == 2) {
                    return null;
                }
                if (n2 == 0) {
                    arrayList = new ArrayList<WorksheetRule>();
                    for (WorksheetRule worksheetRule : this.fRules) {
                        if (worksheetRule.codeGenUsesDates()) continue;
                        arrayList.add(worksheetRule);
                    }
                }
            }
        }
        if (this.fTargetType == ImportClient.TargetType.COLUMNVECTORS) {
            Object[][] objectArray = this.getSelectedCellColumnVectors(stringArray3);
            return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fSpreadsheet, stringArray, string, this.fSheetName, stringArray3, arrayList.toArray(), objectArray}, (int)2);
        }
        if (this.fTargetType == ImportClient.TargetType.DATASET) {
            Object[][] objectArray = this.getSelectedCellColumnVectors(stringArray3);
            return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fSpreadsheet, stringArray, string, this.fSheetName, stringArray3, arrayList.toArray(), objectArray, stringArray2}, (int)2);
        }
        return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fSpreadsheet, stringArray, string, this.fSheetName, stringArray3, arrayList.toArray()}, (int)2);
    }

    private String generateXLSReadScriptSingleBlock(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(" = xlsread(");
        } else if (string4 == null) {
            stringBuilder.append("[~, ~, ");
            stringBuilder.append(string3);
            stringBuilder.append("] = xlsread(");
        } else {
            stringBuilder.append("[~, ~, ");
            stringBuilder.append(string3);
            stringBuilder.append(", ");
            stringBuilder.append(string4);
            stringBuilder.append("] = xlsread(");
        }
        stringBuilder.append("'");
        stringBuilder.append(this.fWorkbookName.replaceAll("'", "''"));
        stringBuilder.append("','");
        stringBuilder.append(this.fSheetName);
        if (string.length() == 0 && string4 == null) {
            stringBuilder.append("'");
        } else {
            stringBuilder.append("','");
            stringBuilder.append(string);
            stringBuilder.append("'");
        }
        if (string4 != null) {
            stringBuilder.append(",'',@convertSpreadsheetDates);\n");
        } else {
            stringBuilder.append(");\n");
        }
        return stringBuilder.toString();
    }

    private boolean isRangeEntireTable(String string) {
        int[] nArray;
        if (string == null) {
            return false;
        }
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        return list.size() == 1 && (nArray = list.get(0)) != null && nArray.length == 4 && nArray[0] == 1 && nArray[1] == 1 && nArray[2] == this.getRowCount() && nArray[3] == this.getColumnCount();
    }

    private boolean isRangeDefaultSelection(String string) {
        int[] nArray;
        if (string == null) {
            return false;
        }
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        return list.size() == 1 && (nArray = list.get(0)) != null && this.fInitialSelection != null && nArray.length == 4 && this.fInitialSelection.length == 4 && nArray[0] == this.fInitialSelection[0] + 1 && nArray[1] == this.fInitialSelection[1] + 1 && nArray[2] == this.fInitialSelection[2] + 1 && nArray[3] == this.fInitialSelection[3] + 1;
    }

    void generateMatlabFunctionCommentHeader(String[][] stringArray, String[] stringArray2, String string, GeneratedCode generatedCode) {
        if (stringArray != null && stringArray.length >= 1 && stringArray[0].length >= 1) {
            int n;
            generatedCode.addCode("\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilearg"));
            generatedCode.addCode("\n%\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE,SHEET) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetarg"));
            generatedCode.addCode("\n%\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE,SHEET,RANGE) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetrangearg"));
            if (this.fRules != null && !this.fRules.isEmpty()) {
                generatedCode.addCode("\n%\n");
                for (n = 0; n < this.fRules.size(); ++n) {
                    if (n % 2 == 0) {
                        generatedCode.addCode("%\t");
                    } else {
                        generatedCode.addCode("%   ");
                    }
                    generatedCode.addCode(((WorksheetRule)this.fRules.get(n)).getSummaryComment());
                    generatedCode.addCode("\n");
                }
            }
            n = stringArray.length > 1 || stringArray[0].length > 1 ? (stringArray2.length >= 2 ? 1 : 0) : (stringArray2.length >= 2 && this.isColumnExcludeRules() ? 1 : 0);
            generatedCode.addCode("%\n% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.example"));
            generatedCode.addCode("\r");
            if (n == 0) {
                if (stringArray2.length > 1) {
                    generatedCode.addCode("%   data = ");
                } else {
                    generatedCode.addCode("%   ");
                    generatedCode.addCode(stringArray2[0]);
                    generatedCode.addCode(" = ");
                }
            } else {
                generatedCode.addCode("%   ");
            }
            generatedCode.addCode(string);
            generatedCode.addCode("('");
            int n2 = this.fWorkbookName.lastIndexOf(File.separator);
            if (n2 >= 0) {
                generatedCode.addCode(this.fWorkbookName.substring(n2 + 1).replaceAll("'", "''"));
            } else {
                generatedCode.addCode(this.fWorkbookName.replaceAll("'", "''"));
            }
            generatedCode.addCode("','");
            generatedCode.addCode(this.fSheetName);
            generatedCode.addCode("','");
            generatedCode.addCode(stringArray[0][0]);
            generatedCode.addCode("');\n");
            if (stringArray2.length > 1 && n == 0) {
                int n3 = stringArray2.length > 7 ? 7 : stringArray2.length;
                for (int i = 0; i < n3; ++i) {
                    if (i % 2 == 0) {
                        generatedCode.addCode("%\t");
                    } else {
                        generatedCode.addCode("%   ");
                    }
                    generatedCode.addCode(stringArray2[i]);
                    generatedCode.addCode(" = data(:,");
                    generatedCode.addCode(Integer.toString(i + 1));
                    generatedCode.addCode(");\n");
                }
                if (n3 < stringArray2.length) {
                    generatedCode.addCode("%    ...\n");
                }
            }
            generatedCode.addCode("%\n%   ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.seealso"));
            generatedCode.addCode("\n");
            generatedCode.addCode(WorksheetTableModel.getTimeStampComment());
            generatedCode.addCode("\n");
        }
    }

    private static String getTimeStampComment() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(ImportToolUtils.getResourceString("codeGen.timestamp"));
        stringBuilder.append(" ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        stringBuilder.append(simpleDateFormat.format(date));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static void generateReplaceNaNsWithEmpty(GeneratedCode generatedCode, String string) {
        generatedCode.addCode(string);
        generatedCode.addCode("(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),");
        generatedCode.addCode(string);
        generatedCode.addCode(")) = {''};\n");
    }

    @Override
    protected void makeCallToMatlab(AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        final MatlabWorksheetUpdateRequest matlabWorksheetUpdateRequest = (MatlabWorksheetUpdateRequest)matlabUpdateRequest;
        if (this.fMatlabBusy) {
            if (this.fTargetType == ImportClient.TargetType.COLUMNVECTORS || this.fTargetType == ImportClient.TargetType.DATASET) {
                matlabWorksheetUpdateRequest.setColumnTargetTypes(this.fColumnTargetTypes);
            } else {
                matlabWorksheetUpdateRequest.setColumnTargetTypes(null);
            }
            this.setQueuedItem(matlabWorksheetUpdateRequest);
        } else {
            this.fMatlabBusy = true;
            this.setQueuedItem(null);
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Object object;
                        if (WorksheetTableModel.this.fDimensions[0] == 0 && WorksheetTableModel.this.fDimensions[1] == 0) {
                            object = (double[])Matlab.mtFeval((String)"GetSheetDimensions", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                            if (object != null && ((Object)object).length >= 4) {
                                double[] dArray;
                                double[] dArray2 = (double[])Matlab.mtFeval((String)"GetInitialSelection", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                                if (dArray2 != null && dArray2.length == 4) {
                                    WorksheetTableModel.this.setInitialSelection((int)dArray2[0] - 1, (int)dArray2[1] - 1, (int)dArray2[2] - 1, (int)dArray2[3] - 1);
                                }
                                if ((dArray = (double[])Matlab.mtFeval((String)"GetDefaultHeaderRow", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1)) != null && dArray.length == 1) {
                                    WorksheetTableModel.this.fDefaultHeaderRow = (int)dArray[0] - 1;
                                }
                                boolean[] blArray = (boolean[])Matlab.mtFeval((String)"GetNumericContainerColumns", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                                WorksheetTableModel.access$602(WorksheetTableModel.this, new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[blArray.length]);
                                for (int i = 0; i < WorksheetTableModel.this.fColumnTargetTypes.length; ++i) {
                                    ((WorksheetTableModel)WorksheetTableModel.this).fColumnTargetTypes[i] = blArray[i] ? SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY : SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY;
                                }
                                WorksheetTableModel.this.setSheetDimensions((int)(object[0] + object[1]) - 1, (int)(object[2] + object[3]) - 1, (int)object[0] - 1, (int)object[2] - 1);
                            }
                            if (WorksheetTableModel.this.fDimensions[0] == 0 || WorksheetTableModel.this.fDimensions[1] == 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        WorksheetTableModel.this.matlabCallback(null);
                                    }
                                });
                                return;
                            }
                        }
                        if (WorksheetTableModel.this.fDimensions[0] < AbstractFileTableModel.NONWINDOWED_SHEETSIZE[0] && WorksheetTableModel.this.fDimensions[1] < AbstractFileTableModel.NONWINDOWED_SHEETSIZE[1]) {
                            matlabWorksheetUpdateRequest.iStartRow = 1;
                            matlabWorksheetUpdateRequest.iStartCol = 1;
                            matlabWorksheetUpdateRequest.iEndCol = WorksheetTableModel.this.fDimensions[1];
                            matlabWorksheetUpdateRequest.iEndRow = WorksheetTableModel.this.fDimensions[0];
                            WorksheetTableModel.this.ROWBLOCKSIZE = WorksheetTableModel.this.fDimensions[0];
                            WorksheetTableModel.this.COLUMNBLOCKSIZE = WorksheetTableModel.this.fDimensions[1];
                        }
                        if (WorksheetTableModel.this.fTargetType == ImportClient.TargetType.COLUMNVECTORS || WorksheetTableModel.this.fTargetType == ImportClient.TargetType.DATASET) {
                            matlabWorksheetUpdateRequest.setColumnTargetTypes(WorksheetTableModel.this.fColumnTargetTypes);
                        } else {
                            matlabWorksheetUpdateRequest.setColumnTargetTypes(null);
                        }
                        object = matlabWorksheetUpdateRequest.mtFeval();
                        SwingUtilities.invokeLater(new Runnable((SpreadsheetDataSection)object){
                            final /* synthetic */ SpreadsheetDataSection val$spreadsheetDataSection;
                            {
                                this.val$spreadsheetDataSection = spreadsheetDataSection;
                            }

                            @Override
                            public void run() {
                                WorksheetTableModel.this.matlabCallback(this.val$spreadsheetDataSection);
                            }
                        });
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
        }
    }

    @Override
    protected String[] getDefaultColumnVarNames(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string;
            String string2 = string = this.getDefaultColumnVariableName(i);
            int n2 = 1;
            while (arrayList.contains(string2)) {
                string2 = string + "_" + Integer.toString(n2);
                ++n2;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[1]);
    }

    private String getDefaultColumnVariableName(int n) {
        Object object;
        String string;
        block2: {
            block1: {
                String string2;
                string = "column" + ImportToolUtils.intToColumnString(n + 1);
                int n2 = this.getTopHeaderRow();
                if (n2 < 0) break block1;
                object = this.getValueAt(n2, n);
                if (!(object instanceof String) || !(string2 = ((String)object).trim()).matches("^[a-zA-Z].*")) break block2;
                string = string2.replaceAll("[^a-zA-Z0-9]", "");
                break block2;
            }
            for (int i = 0; i < (this.getRowCount() < 100 ? this.getRowCount() : 100); ++i) {
                String string3;
                Object object2 = this.getValueAt(i, n);
                if (!(object2 instanceof String) || !(string3 = ((String)object2).trim()).matches("^[a-zA-Z].*")) continue;
                string = string3.replaceAll("[^a-zA-Z0-9]", "");
                break;
            }
        }
        object = string;
        return string;
    }

    @Override
    Object getParsedValueAt(int n, int n2) {
        return null;
    }

    static /* synthetic */ SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] access$602(WorksheetTableModel worksheetTableModel, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray) {
        worksheetTableModel.fColumnTargetTypes = spreadsheetColumnTargetTypeArray;
        return spreadsheetColumnTargetTypeArray;
    }

    static class MatlabWorksheetUpdateRequest
    extends AbstractFileTableModel.MatlabUpdateRequest {
        private Object iSpreadsheetObject;
        private String iSheetName;
        private SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] iColumnTargetTypes;

        MatlabWorksheetUpdateRequest(Object object, String string, List<WorksheetRule> list, int n, int n2, int n3, int n4) {
            this.iSpreadsheetObject = object;
            this.iSheetName = string;
            this.iStartRow = n;
            this.iEndRow = n2;
            this.iStartCol = n3;
            this.iEndCol = n4;
            this.iRules = list;
        }

        @Override
        protected SpreadsheetDataSection mtFeval() {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4 = new Object[]{this.iSpreadsheetObject, this.iSheetName, ImportToolUtils.toExcelRange(this.iStartRow, this.iEndRow, this.iStartCol, this.iEndCol)};
            try {
                objectArray3 = (Object[])Matlab.mtFeval((String)"Read", (Object[])objectArray4, (int)3);
            }
            catch (Exception exception) {
                return null;
            }
            double[] dArray = (double[])objectArray3[0];
            if (objectArray3[1] instanceof String[]) {
                objectArray2 = (String[])objectArray3[1];
                int n = objectArray2.length;
                objectArray = new Object[n];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
            } else {
                objectArray = (Object[])objectArray3[1];
            }
            objectArray2 = (double[])objectArray3[2];
            DateCell.addDateCells(objectArray, (double[])objectArray2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (this.iColumnTargetTypes != null) {
                for (int i = 0; i < this.iColumnTargetTypes.length; ++i) {
                    if (this.iColumnTargetTypes[i] != SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY) continue;
                    arrayList.add(i - this.iStartCol + 1);
                }
            }
            Pair<Class[], Object[]> pair = AbstractFileTableModel.getRuleResults(objectArray, dArray, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList);
            Class[] classArray = (Class[])pair.getFirst();
            Object[] objectArray5 = (Object[])pair.getSecond();
            return new SpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, objectArray, dArray, classArray, objectArray5);
        }

        private void setColumnTargetTypes(SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray) {
            this.iColumnTargetTypes = spreadsheetColumnTargetTypeArray;
        }
    }

    static interface WorksheetCachedDataListener {
        public void worksheetCachedDataChanged(EventObject var1);
    }

    static class MatlabRunnable
    implements Runnable {
        private AbstractFileTableModel.MatlabUpdateRequest iQueuedUpdateRequest;
        private WorksheetTableModel iReqester;

        MatlabRunnable(WorksheetTableModel worksheetTableModel, AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
            this.iReqester = worksheetTableModel;
            this.iQueuedUpdateRequest = matlabUpdateRequest;
        }

        @Override
        public void run() {
            try {
                final SpreadsheetDataSection spreadsheetDataSection = this.iQueuedUpdateRequest.mtFeval();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MatlabRunnable.this.iReqester.matlabCallback(spreadsheetDataSection);
                    }
                });
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
        }
    }
}

