/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.path;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class PathUtils {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.path.resources.RES_PathBrowser");
    public static final int CD_CHANGE = 1;
    public static final int PATH_CHANGE = 2;
    private static boolean sChangeNotificationDialogShowing = false;

    private PathUtils() {
    }

    public static boolean changeNotificationWarningThrown(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            bl = ((String)object).contains("changeNotification");
        }
        return bl;
    }

    public static void showChangeNotificationDialog(Frame frame, int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("reason must be one of CD_CHANGE or PATH_CHANGE");
        }
        ChangeNotificationDialog changeNotificationDialog = new ChangeNotificationDialog(frame, n);
        if (SwingUtilities.isEventDispatchThread()) {
            changeNotificationDialog.run();
        } else {
            SwingUtilities.invokeLater(changeNotificationDialog);
        }
        sChangeNotificationDialogShowing = true;
    }

    public static boolean isChangeNotificationDialogShowing() {
        return sChangeNotificationDialogShowing;
    }

    public static void showInvalidPathEntryDialog(Component component, String string) {
        MJOptionPane.showMessageDialog((Component)component, (Object)sRes.getString("path.invalidentry.message"), (String)string, (int)0);
    }

    private static class ChangeNotificationDialog
    extends MJDialog
    implements Runnable {
        private MJButton fOKButton;
        private Frame fFrame;

        ChangeNotificationDialog(Frame frame, int n) {
            super(frame, sRes.getString(n == 1 ? "cnd.title.cd" : "cnd.title.path"), false);
            this.fFrame = frame;
            MyActionListener myActionListener = new MyActionListener();
            this.addWindowListener(myActionListener);
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            MJButton mJButton = new MJButton(sRes.getString("cnd.help"));
            mJButton.setActionCommand("Help");
            mJButton.setName("Help");
            mJButton.addActionListener((ActionListener)myActionListener);
            this.fOKButton = new MJButton(sRes.getString("cnd.OK"));
            this.fOKButton.setActionCommand("OK");
            this.fOKButton.setName("OK");
            this.fOKButton.addActionListener((ActionListener)myActionListener);
            MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2));
            if (PlatformInfo.isMacintosh()) {
                mJPanel.add((Component)mJButton);
                mJPanel.add((Component)this.fOKButton);
            } else {
                mJPanel.add((Component)this.fOKButton);
                mJPanel.add((Component)mJButton);
            }
            this.setName("ShowChangeNotificationDialog");
            this.getContentPane().add((Component)mJPanel, "South");
            String string = "<html>" + sRes.getString(n == 1 ? "cnd.message.cd" : "cnd.message.path") + sRes.getString("cnd.message.reason") + "</html>";
            MJLabel mJLabel = new MJLabel(string, (Icon)DialogIcon.WARNING_32x32.getIcon(), 2);
            mJLabel.setIconTextGap(10);
            mJLabel.setHorizontalTextPosition(4);
            mJLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)mJLabel, "Center");
            this.pack();
        }

        void fixFocus() {
            this.fOKButton.requestFocus();
        }

        @Override
        public void run() {
            Rectangle rectangle;
            Dimension dimension;
            if (this.fFrame == null) {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            } else {
                rectangle = this.fFrame.getBounds();
            }
            dimension = this.getSize();
            rectangle.x = rectangle.x + rectangle.width / 2 - dimension.width / 2;
            rectangle.y = rectangle.y + rectangle.height / 3 - dimension.height / 2;
            this.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
            this.setVisible(true);
            this.setResizable(false);
            this.fixFocus();
        }

        private class MyActionListener
        extends WindowAdapter
        implements ActionListener {
            private MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Help")) {
                    String string = HelpUtils.getMapfileName("matlab", "env_csh");
                    MLHelpServices.cshDisplayTopic((Object)ChangeNotificationDialog.this, (String)string, (String)"desktop_current_dir_warning");
                } else if (actionEvent.getActionCommand().equals("OK")) {
                    ChangeNotificationDialog.this.dispose();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ChangeNotificationDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                sChangeNotificationDialogShowing = false;
            }
        }
    }
}

