/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.SyntaxHighlightingColorPanel;
import com.mathworks.mlwidgets.prefs.SyntaxPreviewPane;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.color.ColorPicker;
import com.mathworks.widgets.text.mcode.MSyntaxHighlighting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ColorPrefsPanel
extends MJPanel {
    private static ColorPrefsPanel sPrefsPanel = null;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private final EditorSyntaxHighlighting fHighlighting;
    private SyntaxHighlightingColorPanel fSynColorsPanel;
    private SyntaxHighlightingColorPanel fColorsPanel;
    private SyntaxHighlightingColorPanel fCWColorsPanel;
    private MJCheckBox fSystemCheckbox;
    private SyntaxPreviewPane fPreviewPane;
    private CWPreviewPane fCWPreviewPane;
    public static final String NAME_PANEL = "ColorPreferencesPanel";
    public static final String NAME_SYSTEM_COLORS_CHECKBOX = "UseSystemColorsCheckbox";
    public static final String NAME_DESKTOP_TEXT = BUNDLE.getString("gpcp.text");
    public static final String NAME_DESKTOP_BACKGROUND = BUNDLE.getString("gpcp.background");
    public static final String NAME_PREVIEW_PANE = "ColorPreviewPane";
    public static final String NAME_PREVIEW_PANE_CW = "ColorPreviewPane_CW";
    public static final String NAME_RESTORE_DEFAULTS = "RestoreDefaultsButton";

    public ColorPrefsPanel() {
        MJPanel mJPanel;
        SyntaxHighlightingColor syntaxHighlightingColor2;
        this.setName(NAME_PANEL);
        this.fColorsPanel = new SyntaxHighlightingColorPanel(null);
        this.fColorsPanel.addLabelItem(NAME_DESKTOP_TEXT, "ColorsText", PrefsAWT.getColorPref((String)"ColorsText", (Color)ColorPrefs.DEFAULT_TEXT_COLOR), new ColorPickerActionListener("ColorsText"));
        this.fColorsPanel.addLabelItem(NAME_DESKTOP_BACKGROUND, "ColorsBackground", PrefsAWT.getColorPref((String)"ColorsBackground", (Color)ColorPrefs.DEFAULT_BACKGROUND_COLOR), new ColorPickerActionListener("ColorsBackground"));
        this.fSystemCheckbox = new MJCheckBox(BUNDLE.getString("gpcp.use_system_colors"), Prefs.getBooleanPref((String)"ColorsUseSystem", (boolean)true));
        this.fSystemCheckbox.setName(NAME_SYSTEM_COLORS_CHECKBOX);
        this.fSystemCheckbox.addItemListener((ItemListener)new SystemCheckboxListener());
        this.fColorsPanel.setEnabled(!this.fSystemCheckbox.isSelected());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BUNDLE.getString("gpcp.desktop_tool_colors"));
        mJPanel2.setBorder((Border)titledBorder);
        mJPanel2.add((Component)this.fSystemCheckbox, (Object)"North");
        mJPanel2.add((Component)((Object)this.fColorsPanel), (Object)"Center");
        this.fSynColorsPanel = new SyntaxHighlightingColorPanel(BUNDLE.getString("gpcp.m_file_syntax_highlighting_title"));
        this.fHighlighting = new MSyntaxHighlighting();
        for (SyntaxHighlightingColor syntaxHighlightingColor2 : this.fHighlighting.getColors()) {
            mJPanel = this.fSynColorsPanel.addLabelItem(syntaxHighlightingColor2.getDisplayName(), syntaxHighlightingColor2, new SyntaxHighlightingColorListener(syntaxHighlightingColor2));
            if (!syntaxHighlightingColor2.getPreferenceKey().equals(ColorPrefs.MatlabColor.ERROR.getKey())) continue;
            mJPanel.getColorPicker().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPrefsPanel.this.fPreviewPane.setValue(ColorPrefsPanel.this.fPreviewPane.getEditorKit(), ColorPrefs.MatlabColor.ERROR.getKey(), ((DropdownButton)actionEvent.getSource()).getValue());
                }
            });
        }
        this.fPreviewPane = new SyntaxPreviewPane(NAME_PREVIEW_PANE, BUNDLE.getString("gpcp.acc.MSample"));
        this.fPreviewPane.setText(BUNDLE.getString("gpcp.sample_editor_code"));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        titledBorder = BorderFactory.createTitledBorder(BUNDLE.getString("gpcp.editor.sample"));
        mJPanel3.setBorder((Border)titledBorder);
        mJPanel3.add((Component)((Object)this.fPreviewPane), (Object)"Center");
        this.fCWPreviewPane = new CWPreviewPane(NAME_PREVIEW_PANE_CW, BUNDLE.getString("gpcp.acc.MSample"));
        this.fCWPreviewPane.updateText(ColorPrefs.getColorPref((String)ColorPrefs.MatlabColor.CW_ERROR.getKey()), ColorPrefs.getColorPref((String)ColorPrefs.MatlabColor.CW_WARNING.getKey()), ColorPrefs.getHyperlinkColor());
        syntaxHighlightingColor2 = new MJPanel((LayoutManager)new BorderLayout());
        titledBorder = BorderFactory.createTitledBorder(BUNDLE.getString("gpcp.commandwindow.sample"));
        syntaxHighlightingColor2.setBorder((Border)titledBorder);
        syntaxHighlightingColor2.add((Component)((Object)this.fCWPreviewPane), (Object)"Center");
        mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new MGridLayout(1, 0, 4, 4, 131072));
        mJPanel.add((Component)mJPanel3);
        mJPanel.add((Component)syntaxHighlightingColor2);
        this.fCWColorsPanel = new SyntaxHighlightingColorPanel(BUNDLE.getString("gpcp.CWColors"));
        this.fCWColorsPanel.addLabelItem(BUNDLE.getString("gpcp.cmdwindow_errortext"), ColorPrefs.MatlabColor.CW_ERROR.getKey(), ColorPrefs.getColorPref((String)ColorPrefs.MatlabColor.CW_ERROR.getKey()), new CWColorPickerActionListener(ColorPrefs.MatlabColor.CW_ERROR.getKey()));
        this.fCWColorsPanel.addLabelItem(BUNDLE.getString("gpcp.cmdwindow_warningtext"), ColorPrefs.MatlabColor.CW_WARNING.getKey(), ColorPrefs.getColorPref((String)ColorPrefs.MatlabColor.CW_WARNING.getKey()), new CWColorPickerActionListener(ColorPrefs.MatlabColor.CW_WARNING.getKey()));
        this.fCWColorsPanel.addLabelItem(BUNDLE.getString("gpcp.hyperlinkcolor"), "Colors_HTML_HTMLLinks", ColorPrefs.getHyperlinkColor(), new CWColorPickerActionListener("Colors_HTML_HTMLLinks"));
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.add((Component)mJPanel2);
        this.add((Component)((Object)this.fSynColorsPanel));
        this.add((Component)((Object)this.fCWColorsPanel));
        this.add((Component)mJPanel);
        this.add(this.createRestoreDefaultsPanel());
    }

    private Component createRestoreDefaultsPanel() {
        MJButton mJButton = new MJButton(BUNDLE.getString("gpcp.restoredefaultcolors"));
        mJButton.setName(NAME_RESTORE_DEFAULTS);
        mJButton.addActionListener((ActionListener)new RestoreDefaultsActionListener());
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add(Box.createHorizontalGlue(), (Object)"Center");
        mJPanel.add((Component)mJButton, (Object)"East");
        return mJPanel;
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            ColorPrefsPanel.sPrefsPanel.fPreviewPane.cleanup();
            sPrefsPanel = null;
        }
        sPrefsPanel = new ColorPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        for (int i = 0; i < this.fSynColorsPanel.getNumEntries(); ++i) {
            ColorPrefs.setColorPref((String)this.fSynColorsPanel.getPrefsKey(i), (Color)this.fSynColorsPanel.getColor(i));
        }
        ColorPrefs.notifyColorListeners((String)"Colors_M_");
        ColorPrefs.setColorPref((String)this.fCWColorsPanel.getPrefsKey(0), (Color)this.fCWColorsPanel.getColor(0));
        ColorPrefs.notifyColorListeners((String)ColorPrefs.MatlabColor.CW_ERROR.getKey());
        ColorPrefs.setColorPref((String)this.fCWColorsPanel.getPrefsKey(1), (Color)this.fCWColorsPanel.getColor(1));
        ColorPrefs.notifyColorListeners((String)ColorPrefs.MatlabColor.CW_WARNING.getKey());
        ColorPrefs.setColorPref((String)this.fCWColorsPanel.getPrefsKey(2), (Color)this.fCWColorsPanel.getColor(2));
        ColorPrefs.notifyColorListeners((String)"Colors_HTML_");
        PrefsAWT.setColorPref((String)"ColorsText", (Color)this.fColorsPanel.getColor(0));
        PrefsAWT.setColorPref((String)"ColorsBackground", (Color)this.fColorsPanel.getColor(1));
        Prefs.setBooleanPref((String)"ColorsUseSystem", (boolean)this.fSystemCheckbox.isSelected());
        ColorPrefs.notifyColorListeners((String)"ColorsText");
        ColorPrefs.notifyColorListeners((String)"ColorsBackground");
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_colors_prefs"};
    }

    private String createHTMLColor(Color color) {
        String string = "<FONT COLOR=#" + String.format("%02x", color.getRed()) + String.format("%02x", color.getGreen()) + String.format("%02x", color.getBlue()) + ">";
        return string;
    }

    private class CWPreviewPane
    extends MJPanel {
        MJLabel fLabel;

        CWPreviewPane(String string, String string2) {
            super((LayoutManager)new BorderLayout());
            this.fLabel = new MJLabel();
            this.fLabel.setName(string);
            this.fLabel.getAccessibleContext().setAccessibleName(string2);
            this.fLabel.setFont(FontPrefs.getCodeFont());
            this.add((Component)this.fLabel, "Center");
        }

        void setForegroundColor(Color color) {
            this.fLabel.setForeground(color);
        }

        void setBackgroundColor(Color color) {
            this.setBackground(color);
        }

        void updateText(Color color, Color color2, Color color3) {
            this.setBackground(ColorPrefsPanel.this.fColorsPanel.getColor(1));
            this.fLabel.setForeground(ColorPrefsPanel.this.fColorsPanel.getColor(0));
            this.fLabel.setText("<html>>> samplefunction<P>Link to sample: " + ColorPrefsPanel.this.createHTMLColor(color3) + "<u>link</u></FONT> " + "<P>" + ColorPrefsPanel.this.createHTMLColor(color2) + "Warning: Min value set to 0</FONT> " + "<P>" + ColorPrefsPanel.this.createHTMLColor(color2) + "> In " + "<u>samplefunction at 4</u></FONT>" + "<P>" + ColorPrefsPanel.this.createHTMLColor(color) + "Error using <u><b>samplefunction</b></u></FONT>" + "<P>" + ColorPrefsPanel.this.createHTMLColor(color) + "Invalid type</FONT>" + "<P>" + ">>");
        }
    }

    private class SyntaxHighlightingColorListener
    implements ActionListener {
        private final SyntaxHighlightingColor fColor;

        private SyntaxHighlightingColorListener(SyntaxHighlightingColor syntaxHighlightingColor) {
            this.fColor = syntaxHighlightingColor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() == 1001) {
                ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
                Color color = (Color)colorPicker.getValue();
                ColorPrefsPanel.this.fPreviewPane.setSyntaxColor(ColorPrefsPanel.this.fHighlighting, this.fColor, color);
            }
        }
    }

    private class CWColorPickerActionListener
    implements ActionListener {
        private final String fPrefKey;

        private CWColorPickerActionListener(String string) {
            this.fPrefKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
            Color color = (Color)colorPicker.getValue();
            Color color2 = this.fPrefKey.equals(ColorPrefs.MatlabColor.CW_ERROR.getKey()) ? color : ColorPrefsPanel.this.fCWColorsPanel.getColor(0);
            Color color3 = this.fPrefKey.equals(ColorPrefs.MatlabColor.CW_WARNING.getKey()) ? color : ColorPrefsPanel.this.fCWColorsPanel.getColor(1);
            Color color4 = this.fPrefKey.equals("Colors_HTML_HTMLLinks") ? color : ColorPrefsPanel.this.fCWColorsPanel.getColor(2);
            ColorPrefsPanel.this.fCWPreviewPane.updateText(color2, color3, color4);
        }
    }

    private class ColorPickerActionListener
    implements ActionListener {
        private final String fPrefKey;

        private ColorPickerActionListener(String string) {
            this.fPrefKey = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker colorPicker = (ColorPicker)actionEvent.getSource();
            Color color = (Color)colorPicker.getValue();
            if (this.fPrefKey.equals("ColorsText")) {
                ColorPrefsPanel.this.fPreviewPane.setTextColor(color, false);
                ColorPrefsPanel.this.fCWPreviewPane.setForegroundColor(color);
            } else if (this.fPrefKey.equals("ColorsBackground")) {
                ColorPrefsPanel.this.fPreviewPane.setBackgroundColor(color, false);
                ColorPrefsPanel.this.fCWPreviewPane.setBackgroundColor(color);
            }
        }
    }

    private class SystemCheckboxListener
    implements ItemListener {
        private SystemCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = ColorPrefsPanel.this.fSystemCheckbox.isSelected();
            ColorPrefsPanel.this.fColorsPanel.setEnabled(!bl);
            if (bl) {
                ColorPrefsPanel.this.fPreviewPane.setTextColor(ColorPrefs.getSystemTextColor(), false);
                ColorPrefsPanel.this.fPreviewPane.setBackgroundColor(ColorPrefs.getSystemBackgroundColor(), false);
                ColorPrefsPanel.this.fCWPreviewPane.setForegroundColor(ColorPrefs.getSystemTextColor());
                ColorPrefsPanel.this.fCWPreviewPane.setBackgroundColor(ColorPrefs.getSystemBackgroundColor());
            } else {
                ColorPrefsPanel.this.fPreviewPane.setTextColor(ColorPrefsPanel.this.fColorsPanel.getColor(0), false);
                ColorPrefsPanel.this.fPreviewPane.setBackgroundColor(ColorPrefsPanel.this.fColorsPanel.getColor(1), false);
                ColorPrefsPanel.this.fCWPreviewPane.setForegroundColor(ColorPrefsPanel.this.fColorsPanel.getColor(0));
                ColorPrefsPanel.this.fCWPreviewPane.setBackgroundColor(ColorPrefsPanel.this.fColorsPanel.getColor(1));
            }
        }
    }

    private class RestoreDefaultsActionListener
    implements ActionListener {
        private RestoreDefaultsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPrefsPanel.this.fSystemCheckbox.setSelected(true);
            ColorPrefsPanel.this.fColorsPanel.setColor(0, ColorPrefs.DEFAULT_TEXT_COLOR);
            ColorPrefsPanel.this.fColorsPanel.setColor(1, ColorPrefs.DEFAULT_BACKGROUND_COLOR);
            for (int i = 0; i < ColorPrefsPanel.this.fHighlighting.getColors().size(); ++i) {
                ColorPrefsPanel.this.fSynColorsPanel.setColor(i, ((SyntaxHighlightingColor)ColorPrefsPanel.this.fHighlighting.getColors().get(i)).getDefaultColor());
            }
            ColorPrefsPanel.this.fCWColorsPanel.setColor(0, ColorPrefs.getDefaultColor((String)ColorPrefs.MatlabColor.CW_ERROR.getKey()));
            ColorPrefsPanel.this.fCWColorsPanel.setColor(1, ColorPrefs.getDefaultColor((String)ColorPrefs.MatlabColor.CW_WARNING.getKey()));
            ColorPrefsPanel.this.fCWColorsPanel.setColor(2, ColorPrefs.getDefaultHyperlinkColor());
            ColorPrefsPanel.this.fPreviewPane.setTextColor(ColorPrefs.getTextColor(), false);
            ColorPrefsPanel.this.fPreviewPane.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
            ColorPrefsPanel.this.fCWPreviewPane.updateText(ColorPrefs.getDefaultColor((String)ColorPrefs.MatlabColor.CW_ERROR.getKey()), ColorPrefs.getDefaultColor((String)ColorPrefs.MatlabColor.CW_WARNING.getKey()), ColorPrefs.getDefaultHyperlinkColor());
        }
    }
}

