/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.util.productinfo;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.util.productinfo.HelpAddonItem;
import com.mathworks.mlwidgets.util.productinfo.InfoListener;
import com.mathworks.mlwidgets.util.productinfo.PrefPanelItem;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ProductInfoUtils
implements ErrorHandler {
    private static Vector<InfoListener> sListeners = new Vector();
    private static boolean sRegistered = false;
    private static boolean sInitialized = false;
    private static ProductInfoUtils sPIU;
    private static Matlab sMatlab;
    private static ProductInfoManager sProductManager;
    private static DocumentBuilder sDocBuilder;
    private static Vector<String> sCategories;
    private static Vector<String> sRealCategories;
    private static Hashtable<String, String> sCategoriesIcons;
    private static boolean sIsParsing;
    private static boolean sParsePending;
    private static boolean sStandaloneMode;
    private static Vector<String> sStandaloneProductList;
    private static ResourceBundle sRes;
    private static Map<String, String> sPath2FilenameMap;
    private static final String NO_FILE = "";

    private ProductInfoUtils() {
        sPIU = this;
        if (sMatlab == null && Matlab.isMatlabAvailable()) {
            sMatlab = new Matlab();
        }
        if (Matlab.isMatlabAvailable()) {
            ProductInfoUtils.pathChanged();
        }
    }

    public static String[] getClassNames() {
        return new String[]{"com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils"};
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void pathChanged() {
        Object object;
        String[] stringArray = !sStandaloneMode ? MatlabPath.getSearchPath() : ProductInfoUtils.getTestingPath();
        if (stringArray == null) {
            return;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String object32 : stringArray) {
            if (linkedHashMap.containsKey(object32)) continue;
            object = sPath2FilenameMap.get(object32);
            if (object == null) {
                void var7_14;
                if (sStandaloneMode) {
                    File file = new File(object32);
                } else {
                    File file = new File(object32, "info.xml");
                }
                if (var7_14.exists()) {
                    object = FileUtils.getLocalizedFilename((String)var7_14.getAbsolutePath(), (Locale)HelpUtils.getLanguageLocale().getLocaleForLangLocaleString());
                    if (PlatformInfo.isWindows()) {
                        object = ((String)object).toLowerCase();
                    }
                } else {
                    object = NO_FILE;
                }
            }
            linkedHashMap.put(object32, (String)object);
        }
        sPath2FilenameMap = linkedHashMap;
        Object object4 = null;
        int n = 0;
        Collection<String> collection = ProductInfoUtils.compact(linkedHashMap.values());
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            n = 1;
            object4 = ProductInfoUtils.parseFiles(collection);
        } else {
            String[] stringArray2;
            Object var5_7 = null;
            for (String string : collection) {
                Product product = ProductInfoUtils.sProductManager.getProductByFilename(string);
                if (product == null) {
                    void var5_8;
                    Product product2 = ProductInfoUtils.parseFile(string);
                    if (product2 == null) continue;
                    n = 1;
                    ProductInfoUtils.sProductManager.addProductAfter(product2, (Product)var5_8);
                    Product product3 = product2;
                    if (object4 == null) {
                        object4 = new ArrayList();
                    }
                    object4.add(product2);
                    continue;
                }
                Product product4 = product;
            }
            object = ProductInfoUtils.sProductManager.getAllFilenames();
            for (String string : stringArray2 = object.toArray(new String[object.size()])) {
                if (collection.contains(string)) continue;
                ProductInfoUtils.sProductManager.removeProductByFilename(string);
                n = 1;
            }
        }
        if (n != 0) {
            ProductInfoUtils.notifyListenersToRefresh();
        }
        if (object4 != null && !sStandaloneMode) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object = (Product)iterator.next();
                ((Product)object).getItems();
            }
        }
    }

    private static Collection<String> compact(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(collection);
        for (String string : arrayList2) {
            if (string.equals(NO_FILE)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Product parseFile(String string) {
        String[] stringArray;
        Product product = null;
        Document document = ProductInfoUtils.getDomDocument(string);
        if (document != null && (stringArray = ProductInfoUtils.findDocumentInfo(document)) != null) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            boolean bl = true;
            if (string4.toLowerCase().equals("false")) {
                bl = false;
            }
            File file = new File(string);
            String string5 = file.getParent();
            String string6 = ProductInfoUtils.getAbsolutePath(stringArray[3], string5);
            String string7 = stringArray[4];
            if (string7 != null && (string7.startsWith("/") || string7.startsWith("\\"))) {
                string7 = string7.substring(1);
            }
            String string8 = ProductInfoUtils.getAbsolutePath(string7, string5);
            String string9 = ProductInfoUtils.getAbsolutePath(stringArray[5], string5);
            int n = -1;
            try {
                n = Integer.parseInt(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Warning: MathWorksID value in " + string + " must be an integer.");
            }
            PrefPanelItem[] prefPanelItemArray = ProductInfoUtils.findPrefsPanelInfo(file, document);
            String[] stringArray2 = ProductInfoUtils.findDialogPrefsPanelInfo(document);
            Element element = document.getDocumentElement();
            product = new Product(string, string3, n, string2, bl, string6, string8, string9, prefPanelItemArray, stringArray2, null, element);
            ProductInfoUtils.findHelpAddonInfo(product, document, string2, string5);
            String string10 = "$docroot/toolbox/";
            if (string7.startsWith(string10)) {
                product.setDocDir(string7.substring(string10.length()));
            } else if (string7.equals("$docroot/techdoc")) {
                product.setDocDir("matlab");
            }
            if (!sCategories.contains(string2)) {
                sCategories.addElement(string2);
                sCategoriesIcons.put(string2, string6);
            }
            if (!sRealCategories.contains(string2) && product.hasItems()) {
                sRealCategories.addElement(string2);
            }
        }
        return product;
    }

    private static List<Product> parseFiles(Collection<String> collection) {
        if (!sIsParsing) {
            sIsParsing = true;
            ArrayList<Product> arrayList = new ArrayList<Product>();
            Product product = null;
            for (String string : collection) {
                Product product2 = ProductInfoUtils.parseFile(string);
                if (product2 == null) continue;
                if (!ProductInfoUtils.sProductManager.replaceProduct(string, product2)) {
                    ProductInfoUtils.sProductManager.addProductAfter(product2, product);
                }
                product = product2;
                arrayList.add(product2);
            }
            sIsParsing = false;
            if (sParsePending) {
                sParsePending = false;
                ProductInfoUtils.pathChanged();
            }
            return arrayList;
        }
        sParsePending = true;
        return null;
    }

    private static Document getDomDocument(String string) {
        Document document = null;
        try {
            if (sDocBuilder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                sDocBuilder = documentBuilderFactory.newDocumentBuilder();
                sDocBuilder.setErrorHandler(sPIU);
            }
            try {
                document = sDocBuilder.parse(new InputSource(new FileInputStream(string)));
            }
            catch (SAXParseException sAXParseException) {
                System.out.println("Could not parse the file: " + string);
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    private static String[] findDocumentInfo(Document document) {
        String[] stringArray = new String[7];
        try {
            Element element = document.getDocumentElement();
            String string = ProductInfoUtils.getValue(element, "type", NO_FILE);
            if (string.equals(NO_FILE)) {
                string = ProductInfoUtils.getValue(element, "area", NO_FILE);
            }
            String string2 = ProductInfoUtils.getValue(element, "product_name_ends_with_type", "true");
            String string3 = ProductInfoUtils.getValue(element, "name", NO_FILE);
            String string4 = ProductInfoUtils.getValue(element, "MathWorksID", "-1");
            String string5 = ProductInfoUtils.getValue(element, "icon", NO_FILE);
            String string6 = ProductInfoUtils.getValue(element, "help_location", NO_FILE);
            String string7 = ProductInfoUtils.getValue(element, "help_contents_icon", NO_FILE);
            if (string.length() == 0 || string3.length() == 0) {
                return null;
            }
            stringArray[0] = string;
            stringArray[1] = string3;
            stringArray[2] = string2;
            stringArray[3] = string5;
            stringArray[4] = string6;
            stringArray[5] = string7;
            stringArray[6] = string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    private static String[] findDialogPrefsPanelInfo(Document document) {
        Element element = document.getDocumentElement();
        String[] stringArray = null;
        Vector<Element> vector = new Vector<Element>();
        try {
            Element element2;
            String string;
            int n;
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node = nodeList.item(n);
                if (!(node instanceof Element) || !(string = (element2 = (Element)node).getTagName()).equals("dialogpref_registrar")) continue;
                vector.addElement(element2);
            }
            n = vector.size();
            if (n > 0) {
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    element2 = (Element)vector.elementAt(i);
                    string = ProductInfoUtils.getValue(element2, "source", null);
                    if (string == null) continue;
                    stringArray[i] = string;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    private static <T> T[] parseList(Element element, String string, T[] TArray, Parser<T> parser) {
        LinkedList<T> linkedList = new LinkedList<T>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(string2 = (element2 = (Element)node).getTagName()).equals(string)) continue;
            linkedList.add(parser.parse(element2));
        }
        return linkedList.toArray(TArray);
    }

    static String getValue(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i) == null || !nodeList.item(i).getParentNode().equals(element) || nodeList.item(i).getFirstChild() == null) continue;
                return nodeList.item(i).getFirstChild().getNodeValue();
            }
        }
        return string2;
    }

    private static PrefPanelItem[] findPrefsPanelInfo(File file, Document document) {
        Element element = document.getDocumentElement();
        return ProductInfoUtils.getPrefPanelItems(file, element);
    }

    private static PrefPanelItem[] getPrefPanelItems(File file, Element element) {
        PrefPanelItem[] prefPanelItemArray = null;
        Vector<Element> vector = new Vector<Element>();
        try {
            Element element2;
            String string;
            int n;
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node = nodeList.item(n);
                if (!(node instanceof Element) || !(string = (element2 = (Element)node).getTagName()).equals("preference_panel")) continue;
                vector.addElement(element2);
            }
            n = vector.size();
            if (n > 0) {
                prefPanelItemArray = new PrefPanelItem[n];
                for (int i = 0; i < n; ++i) {
                    PrefPanelItem[] prefPanelItemArray2;
                    element2 = (Element)vector.elementAt(i);
                    string = ProductInfoUtils.getValue(element2, "label", null);
                    String string2 = ProductInfoUtils.getValue(element2, "source", null);
                    if (string != null && string2 != null) {
                        prefPanelItemArray[i] = new PrefPanelItem(file, string, string2);
                    }
                    if ((prefPanelItemArray2 = ProductInfoUtils.getPrefPanelItems(file, element2)) == null) continue;
                    for (PrefPanelItem prefPanelItem : prefPanelItemArray2) {
                        prefPanelItemArray[i].addSubpanelItem(prefPanelItem);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return prefPanelItemArray;
    }

    private static void findHelpAddonInfo(Product product, Document document, String string, String string2) {
        try {
            NodeList nodeList = document.getElementsByTagName("help_addon");
            if (nodeList != null) {
                int n;
                Vector<HelpAddonItem> vector = new Vector<HelpAddonItem>();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    String string3;
                    NamedNodeMap namedNodeMap;
                    Node node = nodeList.item(n);
                    if (node.getFirstChild() == null || (namedNodeMap = node.getAttributes()) == null) continue;
                    String string4 = ProductInfoUtils.getAbsolutePath(node.getFirstChild().getNodeValue().trim(), string2);
                    String string5 = NO_FILE;
                    Node node2 = namedNodeMap.getNamedItem("name");
                    if (node2 != null) {
                        string5 = node2.getNodeValue();
                    }
                    String string6 = string;
                    Node node3 = namedNodeMap.getNamedItem("category");
                    if (node3 != null) {
                        string6 = node3.getNodeValue();
                    }
                    String string7 = string;
                    Node node4 = namedNodeMap.getNamedItem("product_name_ends_with_type");
                    if (node4 != null) {
                        string7 = node4.getNodeValue();
                    }
                    boolean bl = true;
                    if (string7.toLowerCase().equals("false")) {
                        bl = false;
                    }
                    boolean bl2 = false;
                    Node node5 = namedNodeMap.getNamedItem("productlevel");
                    if (node5 != null && (string3 = node5.getNodeValue()).equals("true")) {
                        HelpAddonItem helpAddonItem = new HelpAddonItem(string4, string5, string6, bl, bl2);
                        product.addProductLevelHelpAddon(helpAddonItem);
                        bl2 = true;
                    }
                    if (bl2) continue;
                    vector.addElement(new HelpAddonItem(string4, string5, string6, bl, bl2));
                }
                n = vector.size();
                if (n > 0) {
                    HelpAddonItem[] helpAddonItemArray = new HelpAddonItem[n];
                    helpAddonItemArray = vector.toArray(helpAddonItemArray);
                    product.setHelpAddonItems(helpAddonItemArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getToolboxDirectory(String string) {
        String string2 = Matlab.isMatlabAvailable() ? Matlab.matlabRoot() : "S:/A/matlab";
        return string2 + string.replace('$', '/');
    }

    static String getAbsolutePath(String string, String string2) {
        if (string.startsWith("$docroot")) {
            String string3 = ProductInfoUtils.getDocrootDirectory();
            string = string.substring("$docroot".length() + 1);
            return FileUtils.getLocalizedFilename((String)string3, (String)string, (Locale)HelpUtils.getLanguageLocale().getLocaleForLangLocaleString());
        }
        string = (string = ProductInfoUtils.resolveNonDocrootPath(string, string2)).length() == 0 ? string : FileUtils.getLocalizedFilename((String)string, (Locale)HelpUtils.getLanguageLocale().getLocaleForLangLocaleString());
        return string;
    }

    private static String getDocrootDirectory() {
        return Matlab.isMatlabAvailable() ? MLHelpServices.getDocRoot() : "S:/A/matlab/help";
    }

    private static String resolveNonDocrootPath(String string, String string2) {
        if (string2.endsWith("/info.xml") || string2.endsWith("\\info.xml")) {
            string2 = string2.substring(0, string2.length() - "/info.xml".length());
        }
        if (string.startsWith("$toolbox")) {
            return ProductInfoUtils.getToolboxDirectory(string);
        }
        if (string.length() != 0) {
            if (string.equals(".")) {
                return string2;
            }
            if (string.startsWith("../") || string.startsWith("..\\")) {
                return string2 + "/" + string;
            }
            File file = new File(string);
            if (!file.isAbsolute() || !file.exists()) {
                return string2 + "/" + string;
            }
            return string;
        }
        return NO_FILE;
    }

    public static Product getProductByNameOrFirstMatch(String string, boolean bl, String string2) {
        string = string.toLowerCase();
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            ProductInfoUtils.getAllProductsInfo();
        }
        Collection collection = ProductInfoUtils.sProductManager.getProductsInDisplayOrder();
        for (Product product : collection) {
            if (product == null || product.getName() == null) continue;
            String string3 = product.getName().toLowerCase(Locale.ENGLISH);
            if ((!bl || !string3.equals(string)) && (bl || !string3.startsWith(string))) continue;
            if (string2 == null) {
                return product;
            }
            if (!product.getCategory().toLowerCase(Locale.ENGLISH).startsWith(string2.toLowerCase())) continue;
            return product;
        }
        return null;
    }

    public static Product getProductByName(String string) {
        return ProductInfoUtils.getProductByNameOrFirstMatch(string, true, null);
    }

    public static Product getProductByFirstMatch(String string, String string2) {
        return ProductInfoUtils.getProductByNameOrFirstMatch(string, false, string2);
    }

    public static Vector<String> getDialogPanelRegistrants() {
        Vector<String> vector = new Vector<String>();
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            ProductInfoUtils.getAllProductsInfo();
        }
        Collection collection = ProductInfoUtils.sProductManager.getProductsInDisplayOrder();
        for (Product product : collection) {
            String[] stringArray = product.getDialogPrefsPanelItems();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                vector.addElement(string);
            }
        }
        return vector;
    }

    public static Vector<PrefPanelItem> getAllPrefPanels() {
        Vector<PrefPanelItem> vector = new Vector<PrefPanelItem>();
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            ProductInfoUtils.getAllProductsInfo();
        }
        Collection collection = ProductInfoUtils.sProductManager.getProductsInDisplayOrder();
        for (Product product : collection) {
            PrefPanelItem[] prefPanelItemArray = product.getPrefsPanelItems();
            if (prefPanelItemArray == null) continue;
            for (PrefPanelItem prefPanelItem : prefPanelItemArray) {
                vector.addElement(prefPanelItem);
            }
        }
        return vector;
    }

    public static void clearAndReparseProducts() {
        if (Matlab.isMatlabAvailable()) {
            ProductInfoUtils.sProductManager.removeAll();
            sPath2FilenameMap.clear();
            ProductInfoUtils.pathChanged();
        }
    }

    public static synchronized Product[] getAllProductsInfo() {
        if (sPIU == null) {
            sPIU = new ProductInfoUtils();
        }
        if (!sInitialized && ProductInfoUtils.sProductManager.getNumFiles() == 0 && Matlab.isMatlabAvailable()) {
            ProductInfoUtils.registerWithPathListener();
        }
        return ProductInfoUtils.sProductManager.getProductsInDisplayOrder().toArray(new Product[0]);
    }

    public static synchronized Product[] getAllProductsInMatlabSimulinkGroupInfo() {
        if (sPIU == null) {
            sPIU = new ProductInfoUtils();
        }
        if (!sInitialized && ProductInfoUtils.sProductManager.getNumFiles() == 0 && Matlab.isMatlabAvailable()) {
            ProductInfoUtils.registerWithPathListener();
        }
        return ProductInfoUtils.sProductManager.getProductsInMatlabSimulinkGroupOrder().toArray(new Product[0]);
    }

    public static boolean areaContainsProducts(String string) {
        Product[] productArray;
        for (Product product : productArray = ProductInfoUtils.getAllProductsInfo()) {
            if (!product.getCategory().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProductInstalled(String string) {
        return ProductInfoUtils.getProductByName(string) != null;
    }

    public static Vector<String> getCategories() {
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            ProductInfoUtils.getAllProductsInfo();
        }
        return (Vector)sCategories.clone();
    }

    public static Vector<String> getCategoriesWithDisplayItems() {
        if (ProductInfoUtils.sProductManager.getNumFiles() == 0) {
            ProductInfoUtils.getAllProductsInfo();
        }
        return (Vector)sRealCategories.clone();
    }

    public static String getIconLocationForCategory(String string) {
        return sCategoriesIcons.get(string);
    }

    private static void registerWithPathListener() {
        sRegistered = true;
        sInitialized = true;
        MatlabPath.addActionListener((ActionListener)new PathActionListener());
    }

    public static void registerInfoListener(InfoListener infoListener) {
        if (!sRegistered) {
            ProductInfoUtils.registerWithPathListener();
        }
        sListeners.add(infoListener);
    }

    public static void unregisterInfoListener(InfoListener infoListener) {
        sListeners.remove(infoListener);
    }

    private static void notifyListenersToRefresh() {
        ArrayList<InfoListener> arrayList = new ArrayList<InfoListener>(sListeners);
        for (InfoListener infoListener : arrayList) {
            infoListener.infoChanged(ProductInfoUtils.sProductManager.getProductsInDisplayOrder().toArray(new Product[0]));
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    public static int getPathPosition(Product product) {
        return ProductInfoUtils.sProductManager.getPathPosition(product);
    }

    public static String appendCategoryToProductName(String string, String string2) {
        if (string2.equals("toolbox")) {
            return string + " " + sRes.getString("product.toolbox");
        }
        if (string2.equals("blockset")) {
            return string + " " + sRes.getString("product.blockset");
        }
        return string;
    }

    private static int compareTwoProducts(Product product, Product product2, boolean bl) {
        int n;
        TypeOrder typeOrder;
        TypeOrder typeOrder2;
        int n2;
        String string = product.getCategory().toLowerCase();
        String string2 = product2.getCategory().toLowerCase();
        if (bl) {
            string = ProductInfoUtils.getMatlabOrSimulinkType(string);
            string2 = ProductInfoUtils.getMatlabOrSimulinkType(string2);
        }
        if ((n2 = (typeOrder2 = ProductInfoUtils.getTypeOrder(string)).compareTo(typeOrder = ProductInfoUtils.getTypeOrder(string2))) != 0) {
            return n2;
        }
        String string3 = product.getName().toLowerCase();
        String string4 = product2.getName().toLowerCase();
        if (string.equals("matlab")) {
            if (string3.equals("matlab")) {
                return string4.equals("matlab") ? 0 : -1;
            }
            if (string4.equals("matlab")) {
                return 1;
            }
        } else if (string.equals("simulink")) {
            if (string3.equals("simulink")) {
                return string4.equals("simulink") ? 0 : -1;
            }
            if (string4.equals("simulink")) {
                return 1;
            }
        }
        if ((n = string3.compareTo(string4)) == 0) {
            return product.getFilename(true).compareTo(product2.getFilename(true));
        }
        return n;
    }

    private static TypeOrder getTypeOrder(String string) {
        try {
            return TypeOrder.valueOf(string.toUpperCase() + "_TYPE");
        }
        catch (Exception exception) {
            return TypeOrder.OTHER_TYPE;
        }
    }

    private static String getMatlabOrSimulinkType(String string) {
        if (string.equals("toolbox")) {
            string = "matlab";
        } else if (string.equals("blockset")) {
            string = "simulink";
        }
        return string;
    }

    private static void initializeStandaloneMode(Vector<String> vector) {
        sStandaloneMode = true;
        sProductManager = new ProductInfoManager();
        sStandaloneProductList = vector;
        ProductInfoUtils.pathChanged();
    }

    public static void addProduct(String string) {
        ProductInfoUtils.addProductXmlFile(string + File.separator + "info.xml", false);
    }

    public static void removeProduct(String string) {
        ProductInfoUtils.removeProductXmlFile(string + File.separator + "info.xml");
    }

    private static void addProductXmlFile(String string, boolean bl) {
        if (!sStandaloneMode) {
            ProductInfoUtils.initializeStandaloneMode(null);
        }
        if (sStandaloneProductList == null) {
            sStandaloneProductList = new Vector();
        }
        if (bl) {
            sStandaloneProductList.add(0, string);
        } else {
            sStandaloneProductList.add(string);
        }
        ProductInfoUtils.pathChanged();
    }

    private static void removeProductXmlFile(String string) {
        if (sStandaloneProductList != null) {
            sStandaloneProductList.remove(string);
            ProductInfoUtils.pathChanged();
        }
    }

    private static void initializeProductsForTesting(Vector<String> vector) {
        ProductInfoUtils.initializeStandaloneMode(vector);
    }

    private static void addPathForTesting(String string, boolean bl) {
        ProductInfoUtils.addProductXmlFile(string, bl);
    }

    private static void removePathForTesting(String string) {
        ProductInfoUtils.removeProductXmlFile(string);
    }

    private static String[] getTestingPath() {
        if (sStandaloneProductList != null) {
            return sStandaloneProductList.toArray(new String[sStandaloneProductList.size()]);
        }
        return new String[0];
    }

    private static void cleanupForTesting() {
        ProductInfoUtils.sProductManager.removeAll();
        sStandaloneMode = false;
    }

    static {
        sProductManager = new ProductInfoManager();
        sCategories = new Vector();
        sRealCategories = new Vector();
        sCategoriesIcons = new Hashtable(13);
        sIsParsing = false;
        sParsePending = false;
        sStandaloneMode = false;
        sStandaloneProductList = null;
        sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.util.productinfo.resources.RES_ProductInfo");
        sPath2FilenameMap = new LinkedHashMap<String, String>();
        ProductInfoUtils.getAllProductsInfo();
    }

    private static class MatlabSimulinkGroupOrderComparator
    implements Comparator<Product> {
        private MatlabSimulinkGroupOrderComparator() {
        }

        @Override
        public int compare(Product product, Product product2) {
            return ProductInfoUtils.compareTwoProducts(product, product2, true);
        }
    }

    private static class DisplayOrderComparator
    implements Comparator<Product> {
        private DisplayOrderComparator() {
        }

        @Override
        public int compare(Product product, Product product2) {
            return ProductInfoUtils.compareTwoProducts(product, product2, false);
        }
    }

    private static enum TypeOrder {
        MATLAB_TYPE,
        TOOLBOX_TYPE,
        SIMULINK_TYPE,
        BLOCKSET_TYPE,
        LINKS_TYPE,
        OTHER_TYPE;

    }

    private static class ProductInfoManager {
        private final List<Product> iProductsPathOrder = new ArrayList<Product>();
        private final SortedSet<Product> iProductsDisplayOrder = new TreeSet<Product>(new DisplayOrderComparator());
        private final SortedSet<Product> iMatlabSimulinkGroupOrder = new TreeSet<Product>(new MatlabSimulinkGroupOrderComparator());
        private final Map<String, Product> iProductsByFilePath = new HashMap<String, Product>();
        private final List<Product> iProdLevelAddons = new ArrayList<Product>();
        private final Map<Product, List<Product>> iAddonsByProduct = new HashMap<Product, List<Product>>();

        private ProductInfoManager() {
        }

        private void addProductAfter(Product product, Product product2) {
            if (product2 == null) {
                this.addProduct(0, product);
            } else {
                int n = this.getPathPosition(product2) + 1;
                this.addProduct(n, product);
            }
        }

        private void addProduct(int n, Product product) {
            this.iProductsPathOrder.add(n, product);
            this.iProductsDisplayOrder.add(product);
            this.iMatlabSimulinkGroupOrder.add(product);
            this.iProductsByFilePath.put(product.getFilename(), product);
            if (product.getProductLevelHelpAddons() != null) {
                List<HelpAddonItem> list = product.getProductLevelHelpAddons();
                for (HelpAddonItem helpAddonItem : list) {
                    this.addProdLevelHelpAddon(product, helpAddonItem);
                }
            }
        }

        private boolean removeProductByFilename(String string) {
            Product product = this.iProductsByFilePath.remove(string);
            if (product != null) {
                this.iProductsPathOrder.remove(product);
                this.iProductsDisplayOrder.remove(product);
                this.iMatlabSimulinkGroupOrder.remove(product);
                List<Product> list = this.iAddonsByProduct.get(product);
                if (list != null) {
                    for (Product product2 : list) {
                        this.iProdLevelAddons.remove(product2);
                        this.iMatlabSimulinkGroupOrder.remove(product2);
                        this.iProductsDisplayOrder.remove(product2);
                    }
                }
                return true;
            }
            return false;
        }

        private void addProdLevelHelpAddon(Product product, HelpAddonItem helpAddonItem) {
            Product product2 = new Product(null, helpAddonItem.getName(), -1, helpAddonItem.getCategory(), helpAddonItem.getAppendCategoryToName(), null, helpAddonItem.getLocation(), null, null, null, null, null);
            product2.setParent(product);
            this.iProdLevelAddons.add(product2);
            this.iMatlabSimulinkGroupOrder.add(product2);
            this.iProductsDisplayOrder.add(product2);
            List<Product> list = this.iAddonsByProduct.get(product);
            if (list == null) {
                list = new ArrayList<Product>();
                this.iAddonsByProduct.put(product, list);
            }
            list.add(product2);
        }

        private Collection<Product> getProductsInDisplayOrder() {
            return this.iProductsDisplayOrder;
        }

        private Collection<Product> getProductsInMatlabSimulinkGroupOrder() {
            return this.iMatlabSimulinkGroupOrder;
        }

        private Product getProductByFilename(String string) {
            return this.iProductsByFilePath.get(string);
        }

        private int getPathPosition(Product product) {
            int n = this.iProductsPathOrder.indexOf(product);
            if (n > -1) {
                return n;
            }
            return this.iProductsPathOrder.size() + this.iProdLevelAddons.indexOf(product);
        }

        private Collection<String> getAllFilenames() {
            return this.iProductsByFilePath.keySet();
        }

        private int getNumFiles() {
            return this.iProductsByFilePath.size();
        }

        private boolean replaceProduct(String string, Product product) {
            Product product2 = this.iProductsByFilePath.get(string);
            if (product2 != null) {
                int n = this.getPathPosition(product2);
                this.removeProductByFilename(product2.getFilename());
                this.addProduct(n, product);
                return true;
            }
            return false;
        }

        private void removeAll() {
            this.iProductsByFilePath.clear();
            this.iProductsDisplayOrder.clear();
            this.iProductsPathOrder.clear();
            this.iMatlabSimulinkGroupOrder.clear();
            this.iProdLevelAddons.clear();
            this.iAddonsByProduct.clear();
        }
    }

    private static class PathActionListener
    implements ActionListener {
        private PathActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (sPIU == null) {
                sPIU = new ProductInfoUtils();
            }
            ProductInfoUtils.pathChanged();
        }
    }

    private static interface Parser<T> {
        public T parse(Element var1);
    }
}

