/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;

public class WorkspaceDnDListener
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    private IGraphableInfoProvider fGIP;
    private final Component fComponent;

    public WorkspaceDnDListener(Component component, IGraphableInfoProvider iGraphableInfoProvider) {
        this.fGIP = iGraphableInfoProvider;
        this.fComponent = component;
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 3, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (!WorkspaceDnDListener.isValidDragGesture(dragGestureEvent)) {
            return;
        }
        String[] stringArray = this.fGIP.getGraphableNames();
        if (stringArray.length == 0) {
            return;
        }
        SimpleVariableDefinition[] simpleVariableDefinitionArray = new SimpleVariableDefinition[stringArray.length];
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        simpleVariableDefinitionArray[0] = new SimpleVariableDefinition(new VariableIdentifier(stringArray[0], null, 0));
        for (int i = 1; i < stringArray.length; ++i) {
            if (i < stringArray.length) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
            simpleVariableDefinitionArray[i] = new SimpleVariableDefinition(new VariableIdentifier(stringArray[i], null, 0));
        }
        Transferable[] transferableArray = new Transferable[]{MLDataFlavor.encodeSimpleVariableListFlavor((SimpleVariableDefinition[])simpleVariableDefinitionArray), new StringSelection(stringBuilder.toString())};
        Transferable transferable = MJTransferable.getCombinedTransferable((Transferable[])transferableArray);
        try {
            dragGestureEvent.startDrag(MJDragCursorUtilities.getCursor((int)1), WorkspaceIcon.getDefaultIcon().getImage(), new Point(0, 0), transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent) || dropTargetDragEvent.isDataFlavorSupported(MLDataFlavor.matReferenceListFlavor)) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (MJDataFlavor.isDecodableFileFlavor((DropTargetDropEvent)dropTargetDropEvent)) {
            try {
                File[] fileArray;
                dropTargetDropEvent.acceptDrop(1);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                for (File file : fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable)) {
                    WorkspaceCommands.importDataMat(file);
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (WorkspaceCommands.importVariablesFromDropEvent(this.fComponent, dropTargetDropEvent)) {
            return;
        }
        dropTargetDropEvent.rejectDrop();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private static boolean isValidDragGesture(DragGestureEvent dragGestureEvent) {
        MouseEvent mouseEvent;
        InputEvent inputEvent;
        return !PlatformInfo.isMacintosh() || !((inputEvent = dragGestureEvent.getTriggerEvent()) instanceof MouseEvent) || !(mouseEvent = (MouseEvent)inputEvent).isPopupTrigger();
    }
}

